<?php

namespace Drupal\hostlib;

require_once __DIR__ . '/Controller/blendedphp/vendor/autoload.php';

use Blended\hostlib\TransformImage;

/**
 * Class DefaultService.
 *
 * @package Drupal\MyTwigModule
 */
class BlendedTwigExtension extends \Twig_Extension {

  /**
   * {@inheritdoc}
   * This function must return the name of the extension. It must be unique.
   */
  public function getName() {
    return 'hostlib.BlendedTwigExtension';
  }

  /**
   * In this function we can declare the extension function
   */
  public function getFunctions() {
    return array(
      new \Twig_SimpleFunction('get_articles', "blended_articles"),
      new \Twig_SimpleFunction('get_article', "blended_article"),
      new \Twig_SimpleFunction('get_nav_menu', "blended_nav_menu"),
      new \Twig_SimpleFunction('home', "blended_home_url"),
      new \Twig_SimpleFunction('css_links', "blended_css_links", array('needs_environment' => true))
    );
  }
}



