<?php
/**
 * @file
 * Contains \Drupal\hostlib\Controller\BlendedAPI.
 */

namespace Drupal\hostlib\Controller;

use Blended\hostlib\ItineraryRoute;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Drupal\user\Entity\User;
use Drupal\hostlib\BlendedTwigExtension;

/**
 * Controller routines for hostlib routes.
 */
class BlendedAPI extends ControllerBase {


 public function content() {
 
    return [
      '#theme' => 'my_template',
      '#test_var' => $this->t('Test Value'),
    ];
 
  }

  /**
   * Callback for blended/v0/blendedapps`API method.
   */
  public function Blended_apps() {

    $element = array(
      '#markup' => '<div class="blendedapps region region-content">
  <div id="block-seven-content" class="block block-system block-system-main-block">
  <div class="clearfix">
    <div class="layout-container">                          
       <div class="panel">
          <h5 style="text-transform: none;" >Blended Designs</h5>
            <div class="panel__content">  
             <ul class="admin-list">
              <li><a href="'.blended_home_url().'/admin/blendedlibrary"><span class="label">All Packages</span><div class="description">Manage blended package here.</div></a></li>
              <li><a href="'.blended_home_url().'/admin/blendedsetting"><span class="label">Settings</span><div class="description">Configure blended settings.</div></a></li>
            </ul>
           </div>
       </div>                          
    </div>     
  </div>
  </div>
</div>',
    );
    return $element;
  }

  /**
   * Callback for blended/v0/blendedlibrary`API method.
   */
  public function Library_head() {

    $element = array(
      '#markup' => '<div class="blendedux-page" id="blendedux"></div>',
    );
    return $element;
  }

  /**
   * Callback for blended/v0/blendedlibrary`API method.
   */
  public function Setting_head() {

    $element = array(
      '#markup' => '<div class="blendedux-page" id="blendedux"></div>',
    );
    return $element;
  }

  /**
   * Callback for blended/v0/blendedlibrary`API method.
   */
  public function Popup_head() {

    $element = array(
      '#markup' => '<div class="blendedux-page onboarding-page" id="blendedux"></div>',
    );
    return $element;
  }

  /**
   * Callback for blended/v0/blendedlibrary`API method.
   */
  public function Onboard_head() {

    $element = array(
      '#markup' => '<div class="blendedux-page onboarding-page" id="blendedux"></div>',
    );
    return $element;
  }

  /**
   * Callback for blended/v0/blendedlibrary`API method.
   */
  public function Sourcecode_head() {

    $element = array(
      '#markup' => '<div class="blendedux-page" id="blendedux"></div>',
    );
    return $element;
  }

  /* --- Blended library page Url --- */
  function blendedAppUrl( Request $request, $endPointName ) {
   
    if($endPointName == "Library") {
      $url = blended_home_url() . '/admin/blendedlibrary';
    } elseif($endPointName == "SourceCode") {
      $url = blended_home_url() . '/admin/sourcecode';
    } elseif($endPointName == "Onboard") {
      $url = blended_home_url() . '/admin/blendedonboard';
    } elseif($endPointName == "Settings") {
      $url = blended_home_url() . '/admin/blendedsetting';
    }

    return new JsonResponse( $url );
  }

  /* --- Blended pop up page Url --- */
  function blendedPopupUrl() {
    return blended_home_url() . '/admin/blendedpopup';
  }

  /* --- Blended Souce code page Url --- */
  function blendedOnboardUrl() {
    return blended_home_url() . '/admin/blendedonboard';
  }

  /* --- Blended library page Url --- */
  function blendedSourceUrl() {
    return blended_home_url() . '/admin/sourcecode';
  }

  /**
   * Callback for POST:blended/v0/login`API method.
   */
  public function post_login( Request $request ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $session        = $ItineraryRoute->post_login($body, $cookie);
     $response       = $session;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

     return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/reset`API method.
   */
  public function post_resetPassword( Request $request ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $session        = $ItineraryRoute->post_resetPassword($body, $cookie);
     $response       = $session;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

     return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/menus`API method.
   */
  public function get_get_nav_list( Request $request ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $session        = $ItineraryRoute->get_get_nav_list($cookie);
     $response       = $session;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

     return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/menus/{id}`API method.
   */
  public function get_get_nav_menu( Request $request, $id ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $session        = $ItineraryRoute->get_get_nav_menu($id);
     $response       = $session;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

     return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{slug}/media`API method.
   */
  public function post_uploadMedia( Request $request, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $settings       = $ItineraryRoute->post_uploadMedia($slug, $body['hash_value'], $body['name'], $body['token'], $body['image'], $cookie);
     $response       = $settings;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/settings/updates`API method.
   */
  public function get_get_hub_settings( Request $request ) {

   try {
     $ItineraryRoute = new ItineraryRoute();
     $settings       = $ItineraryRoute->get_get_hub_settings();
     $response       = $settings;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/settings/updates`API method.
   */
  public function put_save_hub_settings( Request $request ) {

   try {
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $settings       = $ItineraryRoute->put_save_hub_settings($body);
     $response       = $settings;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages`API method.
   */
  public function get_sync_client_account( Request $request ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $share          = $request->get('share');
     $transfer_to_me = $request->get('transfer_to_me');
     $transfer_by_me = $request->get('transfer_by_me');
     $snapshot       = $request->get('snapshot');
     $purchased      = $request->get('purchased');
     $dependency     = $request->get('dependency');
     $share          = isset($share) ? $share : "";
     $transfer_to_me = isset($transfer_to_me) ? $transfer_to_me : "";
     $transfer_by_me = isset($transfer_by_me) ? $transfer_by_me : "";
     $snapshot       = isset($snapshot) ? $snapshot : "";
     $purchased      = isset($purchased) ? $purchased : "";
     $dependency     = isset($dependency) ? $dependency : "";
     $ItineraryRoute = new ItineraryRoute();
     $packages       = $ItineraryRoute->get_sync_client_account($cookie, $share, $transfer_by_me, $transfer_to_me, $purchased, $snapshot, $dependency);
     $response       = $packages;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/active`API method.
   */
  public function get_active( Request $request ) {

  try {
    $ItineraryRoute = new ItineraryRoute();
    $activeTheme    = $ItineraryRoute->get_active();
    $response       = $activeTheme;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/active`API method.
   */
  public function put_active( Request $request ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $data           = json_decode( $request->getContent(), TRUE );
    $slug           = $data['slug'];
    $ItineraryRoute = new ItineraryRoute();
    $activeTheme    = $ItineraryRoute->put_active($slug, $cookie);
    drupal_flush_all_caches();
    $response       = $activeTheme;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/accounts API method.
   */
  public function get_localaccountDetails( Request $request ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $accountDetails = $ItineraryRoute->get_localaccountDetails($cookie);
    $response       = $accountDetails;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/accounts API method.
   */
  public function post_createAccount( Request $request ) {

  try {
    if ( 0 === strpos( $request->headers->get( 'Content-Type' ), 'application/json' ) ) {
      $body              = json_decode( $request->getContent(), TRUE );
      $verbose           = true;
    }
    $ItineraryRoute = new ItineraryRoute();
    $userDetail     = $ItineraryRoute->post_createAccount($body, $verbose);
    $response       = $userDetail;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug}/{slug}/local/documents/ API method.
   */
  public function post_localCreate( Request $request, $accountSlug, $slug ) {

  try {
    if ( 0 === strpos( $request->headers->get( 'Content-Type' ), 'application/json' ) ) {
      $body = json_decode( $request->getContent(), TRUE );
    }
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->post_localCreate($accountSlug, $slug, $body, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/local/documents/ API method.
   */
  public function put_localUpdate( Request $request, $accountSlug, $slug ) {

  try {
    if ( 0 === strpos( $request->headers->get( 'Content-Type' ), 'application/json' ) ) {
      $body = json_decode( $request->getContent(), TRUE );
    }
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->put_localUpdate($accountSlug, $slug, $body, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for DELETE:blended/v0/packages/{accountSlug}/{slug}/local/ API method.
   */
  public function delete_localDelete( Request $request, $accountSlug, $slug ) {

  try {
    if ( 0 === strpos( $request->headers->get( 'Content-Type' ), 'application/json' ) ) {
      $body = json_decode( $request->getContent(), TRUE );
    }
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->delete_localDelete($accountSlug, $slug, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/local/documents/{name} API method.
   */
  public function get_localDownloadFile( Request $request, $accountSlug, $slug, $name ) {

  try {
    if ( 0 === strpos( $request->headers->get( 'Content-Type' ), 'application/json' ) ) {
      $body = json_decode( $request->getContent(), TRUE );
    }
    $cookie         = $request->headers->get( 'Cookie' );
    $filePath       = $name;
    $filePath       = urldecode(urldecode($filePath));
    $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_localDownloadFile($accountSlug, $slug, $filePath, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/ API method.
   */
  public function get_compareWithLocal( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_compareWithLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/ API method.
   */
  public function post_localClone( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $body           = json_decode( $request->getContent(), TRUE );
    $packageTitle   = null;
    if(isset($body['title'])) {
       $packageTitle = $body['title'];
    }
    $packageJptf    = $ItineraryRoute->post_localClone($accountSlug1, $slug1, $accountSlug2, $slug2, $packageTitle, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    if (isset($exception['status_code']) && trim($exception['status_code']) == "5059") {
        $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $cookie);
        return new JsonResponse(array("status_code" => $exception['status_code'], "message" => "Package name already in use."), 500);
    } else if (isset($exception['code']) && trim($exception['code']) == "4035") {
        $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $cookie);
        return new JsonResponse($exception, 500);
    }else if (isset($exception['message']) && trim($exception['message']) == "Draft has been changed. Please pull it first.") {
        $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $cookie);
        return new JsonResponse(array("status_code" => $exception['status_code'], "message" => "Package name already in use."), 500);
    } else if (isset($exception['message']) && trim($exception['message']) == "Package does not have draft") {
        $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $cookie);
        return new JsonResponse(array("status_code" => $exception['status_code'], "message" => "Package name already in use."), 500);
    } else if (isset($exception['status_code']) && isset($exception['message']) && isset($exception['data'])){
        if($exception['message'] === "Invalid File!") {
           $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $cookie);
        }
    }
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/ API method.
   */
  public function put_updateFromLocal( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $files           = json_decode( $request->getContent(), TRUE );
    $packageJptf    = $ItineraryRoute->put_updateFromLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $files, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/{name}/ API method.
   */
  public function get_compareFileWithLocal( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2, $name ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $filePath       = $name;
    $filePath       = urldecode(urldecode($filePath));
    $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_compareFileWithLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/ API method.
   */
  public function get_compare_draft( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_compare_draft($accountSlug1, $slug1, $accountSlug2, $slug2, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/ API method.
   */
  public function post_draftClone( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->post_draftClone($accountSlug1, $slug1, $accountSlug2, $slug2, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/ API method.
   */
  public function put_updateFromDraft( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->put_updateFromDraft($accountSlug1, $slug1, $accountSlug2, $slug2, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/{name} API method.
   */
  public function get_compareFileWithDraft( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2, $name ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $filePath       = $name;
    $filePath       = urldecode(urldecode($filePath));
    $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
    $ItineraryRoute = new ItineraryRoute();
    $fileComparison = $ItineraryRoute->get_compareFileWithDraft($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $cookie);
    $response       = $fileComparison;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/versions/{label}/ API method.
   */
  public function get_getVersionDetails( Request $request, $accountSlug, $slug, $label ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_getVersionDetails($accountSlug, $slug, $label, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/versions/{label}/documents/ API method.
   */
  public function get_versionDownload( Request $request, $accountSlug, $slug, $label ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_versionDownload($accountSlug, $slug, $label, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/versions/{label}/documents/{name}/ API method.
   */
  public function get_versionDownloadFile( Request $request, $accountSlug, $slug, $label, $name ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $filePath       = $name;
    $filePath       = urldecode(urldecode($filePath));
    $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_versionDownloadFile($accountSlug, $slug, $label, $filePath, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/ API method.
   */
  public function get_compare_version( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2, $label ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_compare_version($accountSlug1, $slug1, $accountSlug2, $slug2, $label, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/ API method.
   */
  public function post_versionClone( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2, $label ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $body           = json_decode( $request->getContent(), TRUE );
    $packageHash    = $body['previousPackageHash'];
    $packageTitle   = null;
    if(isset($body['title'])) {
       $packageTitle = $body['title'];
    }
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->post_versionClone($accountSlug1, $slug1, $accountSlug2, $slug2, $label, $packageHash, $packageTitle, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/ API method.
   */
  public function put_updateFromVersion( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2, $label ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $files          = json_decode( $request->getContent(), TRUE );
    $packageJptf    = $ItineraryRoute->put_updateFromVersion($accountSlug1, $slug1, $accountSlug2, $slug2, $label, $files, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/{name}/ API method.
   */
  public function get_compare_labeledversion_file( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2, $label, $name ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $filePath       = $name;
    $filePath       = urldecode(urldecode($filePath));
    $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->get_compare_labeledversion_file($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $label, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug}/{slug}/draft/documents/ API method.
   */
  public function post_createHubPackage( Request $request, $accountSlug, $slug ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->post_createHubPackage($accountSlug, $slug, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    if (!isset($exception['status_code']) && !isset($exception['message'])) {
        return new JsonResponse(array("message" => "Invalid media type."), 500);
    } elseif (isset($exception['status_code']) && trim($exception['status_code']) == "5059") {
        $ItineraryRoute->delete_localDelete($accountSlug, $slug, $cookie);
        return new JsonResponse(array("status_code" => $exception['status_code'], "message" => "Package name already in use."), 500);
    } elseif (isset($exception['status_code']) && trim($exception['status_code']) == "5064") {
        $ItineraryRoute->delete_localDelete($accountSlug, $slug, $cookie);
    } elseif (isset($exception['status_code']) && trim($exception['status_code']) == "500") {
        $ItineraryRoute->delete_localDelete($accountSlug, $slug, $cookie);
    } elseif (isset($exception['message']) && trim($exception['message']) == "Draft has been changed. Please pull it first") {
        $ItineraryRoute->delete_localDelete($accountSlug, $slug, $cookie);
        return new JsonResponse(array("status_code" => $exception['status_code'], "message" => "Package name already in use."), 500);
    }
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/draft/documents/ API method.
   */
  public function put_push_package( Request $request, $accountSlug, $slug ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $body           = json_decode( $request->getContent(), TRUE );
    $pushToHub      = $body['pushToHub'];
    $force          = $body['force'];
    $ItineraryRoute = new ItineraryRoute();
    $packageJptf    = $ItineraryRoute->put_push_package($accountSlug, $slug, $force, $pushToHub, $body, $cookie);
    $response       = $packageJptf;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    try {
        $ItineraryRoute = new ItineraryRoute();
        $packageJptf    = $ItineraryRoute->put_push_package_helper($accountSlug, $slug, $cookie, $e->getMessage());
        $response       = $packageJptf;
    } catch(\Exception $e) {
        $error = json_decode($e->getMessage(), true);
        if (isset($error['changemessage']) && $error['changemessage'] == true && isset($error['status_code']) && isset($error['message'])) {
            $error['message'] = "You need to sync.";
            return new JsonResponse($error, 500);
        }
        if (isset($error['changemessage']) && $error['changemessage'] == true) {
            return new JsonResponse(array("message" => "Invalid Package. Something wrong with your package either the file _package.json not found or you are trying to push some invalid files."), 500);
        }
        if (isset($error['code']) && trim($error['code']) == "4035") {
            return new JsonResponse(array("status_code" =>"4035", "message" => $error['message'], "data" => $error['data']), 500);
        }
        if (isset($error['data']) && !isset($error['status_code']) && !isset($error['message'])) {
            $dataValue = "Upload a valid image. The file you uploaded was either not an image or a corrupted image.";
            if(is_array($error['data']) && !empty($error['data']))
                $error['data'] = array_fill_keys(array_keys($error['data']), $dataValue);
            return new WP_Error("4035", "Invalid media type.", $error['data']);
        }
        if (isset($error['errors'])) {
            return new JsonResponse($error, 500);
        } else if (isset($error['status_code']) && isset($error['message']) && isset($error['data'])) {
            return new JsonResponse($error, "500");
        } else if (isset($error['status_code']) && isset($error['message'])) {
            return new JsonResponse($error, "500");
        } else {
            return new JsonResponse(array("message" => 'Package Does not Exist.'), "500");
        }
    }    
  }

    $exception = $this->changeFormat($exception);
    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/accounts/{slug}/draft/documents API method.
   */
  public function put_pull_package( Request $request, $slug ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $verbose        = true;
    $ItineraryRoute = new ItineraryRoute();
    $accountDetails = $ItineraryRoute->put_pull_package($slug, $cookie);
    $response       = $accountDetails;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/accounts/{slug} API method.
   */
  public function get_getAccountDetails( Request $request, $slug ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $verbose        = true;
    $ItineraryRoute = new ItineraryRoute();
    $accountDetails = $ItineraryRoute->get_getAccountDetails($slug, $verbose, $cookie);
    $response       = $accountDetails;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/accounts/{slug} API method.
   */
  public function put_updateAccount( Request $request, $slug ) {

  try {
    $cookie                      = $request->headers->get( 'Cookie' );
    $body                        = json_decode( $request->getContent(), TRUE );
    $body['activation_solution'] = $body['activationSolution'];
    unset($body['activationSolution']);
    $ItineraryRoute              = new ItineraryRoute();
    $ItineraryRoute->put_updateAccount($slug, $body, $cookie);
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    // returning response to avoid Uncaught PHP Exception LogicException as The controller must return a response.
    return new Response( "null" );
  }

  /**
   * Callback for GET:blended/v0/settings/theme API method.
   */
  public function get_get_theme_settings( Request $request ) {

  try {
    $ItineraryRoute = new ItineraryRoute();
    $accountDetails = $ItineraryRoute->get_get_theme_settings();
    $response       = $accountDetails;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/settings/theme API method.
   */
  public function put_save_theme_settings( Request $request ) {

  try {
    $body           = json_decode( $request->getContent(), TRUE );
    $ItineraryRoute = new ItineraryRoute();
    $accountDetails = $ItineraryRoute->put_save_theme_settings($body);
    $response       = $accountDetails;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/settings/navigations API method.
   */
  public function get_get_navigation_settings( Request $request ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $ItineraryRoute = new ItineraryRoute();
    $accountDetails = $ItineraryRoute->get_get_navigation_settings($cookie);
    $response       = $accountDetails;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/settings/navigations API method.
   */
  public function put_get_navigation_settings( Request $request ) {

  try {
    $cookie         = $request->headers->get( 'Cookie' );
    $body           = json_decode( $request->getContent(), TRUE );
    $ItineraryRoute = new ItineraryRoute();
    $accountDetails = $ItineraryRoute->put_get_navigation_settings($body, $cookie);
    $response       = $accountDetails;
  } catch (\Exception $e) {
    $exception = json_decode($e->getMessage(), true);
    $exception = $this->changeFormat($exception);
    return new JsonResponse($exception, 500);
  }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/local API method.
   */
  public function get_localPackageGet( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $accountDetails = $ItineraryRoute->get_localPackageGet($accountSlug, $slug, $cookie);
     $response       = $accountDetails;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/accounts/{accountSlug}/accounts API method.
   */
  public function get_getAccountList( Request $request, $accountSlug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $verbose        = true;
     $ItineraryRoute = new ItineraryRoute();
     $accountDetails = $ItineraryRoute->get_getAccountList($accountSlug, $verbose, $cookie);
     $response       = $accountDetails;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/accounts/{accountSlug}/current API method.
   */
  public function get_getCurrentAccount( Request $request, $accountSlug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $verbose        = true;
     $ItineraryRoute = new ItineraryRoute();
     $accountDetails = $ItineraryRoute->get_getCurrentAccount($accountSlug, $verbose, $cookie);
     $response       = $accountDetails;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/logout API method.
   */
  public function post_logout( Request $request ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $accountDetails = $ItineraryRoute->post_logout($cookie);
     $response       = $accountDetails;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/accounts/{accountSlug}/pendings API method.
   */
  public function get_getPendingUsers( Request $request, $accountSlug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $verbose        = true;
     $ItineraryRoute = new ItineraryRoute();
     $pendingUsers   = $ItineraryRoute->get_getPendingUsers($accountSlug, $verbose, $cookie);
     $response       = $pendingUsers;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/accounts/{accountSlug}/pendings API method.
   */
  public function post_inviteUser( Request $request, $accountSlug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $pendingUsers   = $ItineraryRoute->post_inviteUser($accountSlug, $body, $cookie);
     $response       = $pendingUsers;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for DELETE:blended/v0/accounts/{accountSlug}/pendings/{email} API method.
   */
  public function delete_removePendingUser( Request $request, $accountSlug, $email ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $pendingUsers   = $ItineraryRoute->delete_removePendingUser($accountSlug, $email, $cookie);
     $response       = $pendingUsers;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug} API method.
   */
  public function get_getPackageDetails( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_getPackageDetails($accountSlug, $slug, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug} API method.
   */
  public function put_updatePackage( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->put_updatePackage($accountSlug, $slug, $body, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/draft API method.
   */
  public function get_getDraft( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_getDraft($accountSlug, $slug, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/currenthash API method.
   */
  public function get_currenthash( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_currenthash($accountSlug, $slug, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/draft API method.
   */
  public function put_updateDraft( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->put_updateDraft($accountSlug, $slug, $body, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/draft/documents API method.
   */
  public function get_pull_package( Request $request, $accountSlug, $slug ) {

   try {
     $cookie  = $request->headers->get( 'Cookie' );
     $force   = $request->query->get( 'force' );
     $asHash  = $request->query->get( 'as_hash' );
     $version = $request->query->get( 'version' );
     if(isset($version)) {
       $label = $version;
     } else {
       $label = null;
     }
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_pull_package($accountSlug, $slug, $force, $asHash, $label, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/draft/documents/{name} API method.
   */
  public function get_getFile( Request $request, $accountSlug, $slug, $name ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $filePath       = $name;
     $filePath       = urldecode(urldecode($filePath));
     $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
     $filePath       = str_replace(':', '.', $filePath);
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_getFile($accountSlug, $slug, $filePath, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/local/documents API method.
   */
  public function get_localDownload( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $as_hash = $request->get( 'as_hash' );
     if(isset($as_hash)) {
        $asHash = $request->get( 'as_hash' );
     } else {
        $asHash = false;
     }
     $packageJptf    = $ItineraryRoute->get_localDownload($accountSlug, $slug, $asHash, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/versions API method.
   */
  public function get_getVersions( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_getVersions($accountSlug, $slug, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug}/{slug}/versions API method.
   */
  public function post_versionCreateSnapshot( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->post_versionCreateSnapshot($accountSlug, $slug, $body, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/canonical API method.
   */
  public function get_canonicalDetails( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $verbose        = true;
     $packageJptf    = $ItineraryRoute->get_canonicalDetails($accountSlug, $slug, $cookie, $verbose);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/canonical API method.
   */
  public function put_canonicalSet( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $ItineraryRoute->put_canonicalSet($accountSlug, $slug, $body, $cookie);
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    // returning response to avoid Uncaught PHP Exception LogicException as The controller must return a response.
    return new Response( "null" );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/canonical/documents API method.
   */
  public function get_canonicalDownload( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_canonicalDownload($accountSlug, $slug, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents API method.
   */
  public function get_compare_canonical( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_compare_canonical($accountSlug1, $slug1, $accountSlug2, $slug2, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents API method.
   */
  public function post_canonicalClone( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $body           = json_decode( $request->getContent(), TRUE );
     $packageTitle   = null;
     if(isset($body['title'])) {
        $packageTitle = $body['title'];
     }
     $packageJptf    = $ItineraryRoute->post_canonicalClone($accountSlug1, $slug1, $accountSlug2, $slug2, $packageTitle, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents API method.
   */
  public function put_updateFromCanonical( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2 ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->put_updateFromCanonical($accountSlug1, $slug1, $accountSlug2, $slug2, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents/{name} API method.
   */
  public function get_compareFileWithCanonical( Request $request, $accountSlug1, $slug1, $accountSlug2, $slug2, $name ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $filePath       = $name;
     $filePath       = urldecode(urldecode($filePath));
     $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
     $ItineraryRoute = new ItineraryRoute();
     $packageJptf    = $ItineraryRoute->get_compareFileWithCanonical($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $cookie);
     $response       = $packageJptf;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/acquisitions API method.
   */
  public function get_getAcquiredPackageAccountList( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $share          = $request->query->get('share');
     $package        = $ItineraryRoute->get_getAcquiredPackageAccountList($accountSlug, $slug, $cookie, $share);
     $response       = $package;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug}/{slug}/acquisitions API method.
   */
  public function post_acquirePackage( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $package        = $ItineraryRoute->post_acquirePackage($accountSlug, $slug, $body, $cookie);
     $response       = $package;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/acquisitions API method.
   */
  public function put_acceptAcquisition( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $package        = $ItineraryRoute->put_acceptAcquisition($accountSlug, $slug, $body, $cookie);
     $response       = $package;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for DELETE:blended/v0/packages/{accountSlug}/{slug}/acquisitions API method.
   */
  public function delete_revokeAcquiredPackage( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $package        = $ItineraryRoute->delete_revokeAcquiredPackage($accountSlug, $slug, $body, $cookie);
     $response       = $package;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/accounts/resend/emailverification/ API method.
   */
  public function put_resendAccountVerificationEmail( Request $request ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $ItineraryRoute->put_resendAccountVerificationEmail($cookie, $body);
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    // returning response to avoid Uncaught PHP Exception LogicException as The controller must return a response.
    return new Response( "null" );
  }

  /**
   * Callback for PUT:blended/v0/accounts/search/{accountSlug}/ API method.
   */
  public function get_searchAccounts( Request $request, $accountSlug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->get_searchAccounts($accountSlug, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug}/{slug}/resend/invite API method.
   */
  public function post_resendInvite( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->post_resendInvite($accountSlug, $slug, $body, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/accounts/{accountSlug}/current/ API method.
   */
  public function put_setCurrentAccount( Request $request, $accountSlug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->put_setCurrentAccount($accountSlug, $body, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/accounts/{accountSlug}/admins/ API method.
   */
  public function post_addAccountAdmin( Request $request, $accountSlug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->post_addAccountAdmin($accountSlug, $body, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for POST:blended/v0/packages/{accountSlug}/ API method.
   */
  public function post_createPackage( Request $request, $accountSlug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $verbose        = true;
     $accountDetail  = $ItineraryRoute->post_createPackage($accountSlug, $cookie, $body, $verbose);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/local/documents/merge/ API method.
   */
  public function put_mergePackage( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->put_mergePackage($accountSlug, $slug, $body, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/dependencies/ API method.
   */
  public function get_getDependencies( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $verbose        = true;
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->get_getDependencies($accountSlug, $slug, $verbose, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/ratings/{ratingPk}/ API method.
   */
  public function get_getRatingDetails( Request $request, $accountSlug, $slug, $ratingPk ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $verbose        = true;
     $ratingPk       = (int)$ratingPk;
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->get_getRatingDetails($accountSlug, $slug, $ratingPk, $verbose, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/ratings/{ratingPk}/ API method.
   */
  public function put_updateRating( Request $request, $accountSlug, $slug, $ratingPk ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ratingPk       = (int)$ratingPk;
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->put_updateRating($accountSlug, $slug, $ratingPk, $body, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/versions/{label}/licenses/ API method.
   */
  public function get_getLicenses( Request $request, $accountSlug, $slug, $label ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $accountDetail  = $ItineraryRoute->get_getLicenses($accountSlug, $slug, $label, $cookie);
     $response       = $accountDetail;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/ API method.
   */
  public function put_updateLicense( Request $request, $accountSlug, $slug, $label, $name ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $licenseDetails = $ItineraryRoute->put_updateLicense($accountSlug, $slug, $label, $name, $body, $cookie);
     $response       = $licenseDetails;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for DELETE:blended/v0/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/ API method.
   */
  public function delete_removeLicense( Request $request, $accountSlug, $slug, $label, $name ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $licenseDetails = $ItineraryRoute->delete_removeLicense($accountSlug, $slug, $label, $name, $cookie);
     $response       = $licenseDetails;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /*********************************************************************************
   ********************* Publication endpoints *************************************
   ********************************************************************************/

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/publications/ API method.
   */
  public function get_publication( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $ItineraryRoute = new ItineraryRoute();
     $licenseDetails = $ItineraryRoute->get_publication($accountSlug, $slug, $cookie);
     $response       = $licenseDetails;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/versionbundles/ API method.
   */
  public function get_versionBundles( Request $request, $accountSlug, $slug ) {

   try {
     $cookie              = $request->headers->get( 'Cookie' );
     $ItineraryRoute      = new ItineraryRoute();
     $publicationVersions = $ItineraryRoute->get_versionBundles($accountSlug, $slug, $cookie);
     $response            = $publicationVersions;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for PUT:blended/v0/packages/{accountSlug}/{slug}/publications/ API method.
   */
  public function put_publications( Request $request, $accountSlug, $slug ) {

   try {
     $cookie = $request->headers->get( 'Cookie' );
     $body   = json_decode( $request->getContent(), TRUE );
     $commit = null;
     if(null !== $request->query->get( 'commit' )) {
       $commit = $request->query->get( 'commit' );
     }
     $ItineraryRoute  = new ItineraryRoute();
     $publicationInfo = $ItineraryRoute->put_publications($accountSlug, $slug, $commit, $body, $cookie);
     $response        = $publicationInfo;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception['data'] = $exception;
     $exception['code'] = $exception['data']['code'];
     $exception['message'] = "";
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/publicationvalidations/ API method.
   */
  public function post_validatePublication( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $response       = $ItineraryRoute->post_validatePublication($accountSlug, $slug, $cookie,$body);
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Callback for GET:blended/v0/packages/{accountSlug}/{slug}/publicationvalidations/ API method.
   */
  public function put_rejectAcquisitionInvite( Request $request, $accountSlug, $slug ) {

   try {
     $cookie         = $request->headers->get( 'Cookie' );
     $body           = json_decode( $request->getContent(), TRUE );
     $ItineraryRoute = new ItineraryRoute();
     $licenseDetails = $ItineraryRoute->put_rejectAcquisitionInvite($accountSlug, $slug, $body, $cookie);
     $response       = $licenseDetails;
   } catch (\Exception $e) {
     $exception = json_decode($e->getMessage(), true);
     $exception = $this->changeFormat($exception);
     return new JsonResponse($exception, 500);
   }

    return new JsonResponse( $response );
  }

  /**
   * Change exception format to match other hosts.
   */
  public function changeFormat($exception) {
     if(isset($exception['status_code'])) {
        $exception['code'] = (int)$exception['status_code'];
        unset($exception['status_code']);
     }

     return $exception;
  }

}
