<?php
namespace Drupal\hostlib\Access;

use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Session\AccountInterface;
use Symfony\Component\Routing\Route;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Access\CsrfTokenGenerator;
use Drupal\Core\Access\AccessResult;

/**
 * Determines access to routes based on login status of current user.
 */
class BlendedAccessCheck implements AccessInterface {

  /**
   * {@inheritdoc}
   */
  public function access(Route $route, Request $request, AccountInterface $account) {
    $userRoles = $account->getRoles();
    $status = true;
    if(!in_array("administrator", $userRoles)) {
        $status = false;
    }
    return AccessResult::allowedIfHasPermission($account, 'administer something');
  }

}
