<?php
/**
 * PackagesApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

use \Swagger\Client\Configuration;
use \Swagger\Client\ApiClient;
use \Swagger\Client\ApiException;
use \Swagger\Client\ObjectSerializer;

/**
 * PackagesApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PackagesApi
{

    /**
     * API Client
     *
     * @var \Swagger\Client\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Swagger\Client\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Swagger\Client\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://stgqahub.blended.co/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Swagger\Client\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Swagger\Client\ApiClient $apiClient set the API client
     *
     * @return PackagesApi
     */
    public function setApiClient(\Swagger\Client\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation acceptAcquisition
     *
     * API to accept package.
     *
     * @param string $account_slug account slug used to uniquely identify a package. (required)
     * @param string $slug package slug used to uniquely identify a package. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\Body $body request data used to acquire package. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function acceptAcquisition($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->acceptAcquisitionWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation acceptAcquisitionWithHttpInfo
     *
     * API to accept package.
     *
     * @param string $account_slug account slug used to uniquely identify a package. (required)
     * @param string $slug package slug used to uniquely identify a package. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\Body $body request data used to acquire package. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function acceptAcquisitionWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling acceptAcquisition');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling acceptAcquisition');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling acceptAcquisition');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling acceptAcquisition');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/acquisitions/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/acquisitions/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation acquirePackage
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\Acquisition $body request data used to acquire package. (required)
     * @return \Swagger\Client\Model\BlendedPackage
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function acquirePackage($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->acquirePackageWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation acquirePackageWithHttpInfo
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\Acquisition $body request data used to acquire package. (required)
     * @return Array of \Swagger\Client\Model\BlendedPackage, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function acquirePackageWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling acquirePackage');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling acquirePackage');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling acquirePackage');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling acquirePackage');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/acquisitions/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\BlendedPackage',
                '/packages/{accountSlug}/{slug}/acquisitions/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\BlendedPackage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\BlendedPackage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse401', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse409', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 412:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse412', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation addLicense
     *
     * Add a license to package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label label for the version (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddLicense $body request data used to add package license. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function addLicense($account_slug, $slug, $label, $sessionkey, $body)
    {
        list($response) = $this->addLicenseWithHttpInfo($account_slug, $slug, $label, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation addLicenseWithHttpInfo
     *
     * Add a license to package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label label for the version (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddLicense $body request data used to add package license. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function addLicenseWithHttpInfo($account_slug, $slug, $label, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling addLicense');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling addLicense');
        }
        // verify the required parameter 'label' is set
        if ($label === null) {
            throw new \InvalidArgumentException('Missing the required parameter $label when calling addLicense');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling addLicense');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling addLicense');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versions/{label}/licenses/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($label !== null) {
            $resourcePath = str_replace(
                "{" . "label" . "}",
                $this->apiClient->getSerializer()->toPathValue($label),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/versions/{label}/licenses/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation addRating
     *
     * Add a rating to a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddRating $body request data used to add package rating. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function addRating($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->addRatingWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation addRatingWithHttpInfo
     *
     * Add a rating to a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddRating $body request data used to add package rating. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function addRatingWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling addRating');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling addRating');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling addRating');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling addRating');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/ratings/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/ratings/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation canonicalSet
     *
     * Get package draft.
     *
     * @param string $account_slug accountSlug (required)
     * @param string $slug package slug used to uniquely identify a package. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\CreateCanonical $body request data used to update package. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function canonicalSet($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->canonicalSetWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation canonicalSetWithHttpInfo
     *
     * Get package draft.
     *
     * @param string $account_slug accountSlug (required)
     * @param string $slug package slug used to uniquely identify a package. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\CreateCanonical $body request data used to update package. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function canonicalSetWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling canonicalSet');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling canonicalSet');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling canonicalSet');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling canonicalSet');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/canonical/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/canonical/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createDraft
     *
     * Create package draft.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\UpdateDraft $body request data used to create package draft. (required)
     * @return \Swagger\Client\Model\NewDraft
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function createDraft($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->createDraftWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation createDraftWithHttpInfo
     *
     * Create package draft.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\UpdateDraft $body request data used to create package draft. (required)
     * @return Array of \Swagger\Client\Model\NewDraft, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function createDraftWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling createDraft');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling createDraft');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling createDraft');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createDraft');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/draft/documents/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\NewDraft',
                '/packages/{accountSlug}/{slug}/draft/documents/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\NewDraft', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\NewDraft', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createPackage
     *
     * Create Package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\CreatePackage $body request data used to create package. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\BlendedPackage
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function createPackage($account_slug, $sessionkey, $body, $verbose = null)
    {
        list($response) = $this->createPackageWithHttpInfo($account_slug, $sessionkey, $body, $verbose);
        return $response;
    }

    /**
     * Operation createPackageWithHttpInfo
     *
     * Create Package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\CreatePackage $body request data used to create package. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\BlendedPackage, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function createPackageWithHttpInfo($account_slug, $sessionkey, $body, $verbose = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling createPackage');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling createPackage');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createPackage');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\BlendedPackage',
                '/packages/{accountSlug}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\BlendedPackage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\BlendedPackage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation download
     *
     * get version documents
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label value used to uniquely identify version. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @param string $as_hashes value used to return only hashes (optional)
     * @return object[]
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function download($account_slug, $slug, $label, $sessionkey = null, $as_hashes = null)
    {
        list($response) = $this->downloadWithHttpInfo($account_slug, $slug, $label, $sessionkey, $as_hashes);
        return $response;
    }

    /**
     * Operation downloadWithHttpInfo
     *
     * get version documents
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label value used to uniquely identify version. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @param string $as_hashes value used to return only hashes (optional)
     * @return Array of object[], HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function downloadWithHttpInfo($account_slug, $slug, $label, $sessionkey = null, $as_hashes = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling download');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling download');
        }
        // verify the required parameter 'label' is set
        if ($label === null) {
            throw new \InvalidArgumentException('Missing the required parameter $label when calling download');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versions/{label}/documents/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($as_hashes !== null) {
            $queryParams['as_hashes'] = $this->apiClient->getSerializer()->toQueryValue($as_hashes);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($label !== null) {
            $resourcePath = str_replace(
                "{" . "label" . "}",
                $this->apiClient->getSerializer()->toPathValue($label),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                'object[]',
                '/packages/{accountSlug}/{slug}/versions/{label}/documents/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'object[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation downloadCanonical
     *
     * API used to Download a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @return object[]
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function downloadCanonical($account_slug, $slug, $sessionkey = null)
    {
        list($response) = $this->downloadCanonicalWithHttpInfo($account_slug, $slug, $sessionkey);
        return $response;
    }

    /**
     * Operation downloadCanonicalWithHttpInfo
     *
     * API used to Download a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @return Array of object[], HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function downloadCanonicalWithHttpInfo($account_slug, $slug, $sessionkey = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling downloadCanonical');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling downloadCanonical');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/canonical/documents/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                'object[]',
                '/packages/{accountSlug}/{slug}/canonical/documents/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'object[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation downloadDraft
     *
     * Download package draft.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $as_hashes value used to return only hashes (optional)
     * @return object[]
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function downloadDraft($account_slug, $slug, $sessionkey, $as_hashes = null)
    {
        list($response) = $this->downloadDraftWithHttpInfo($account_slug, $slug, $sessionkey, $as_hashes);
        return $response;
    }

    /**
     * Operation downloadDraftWithHttpInfo
     *
     * Download package draft.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $as_hashes value used to return only hashes (optional)
     * @return Array of object[], HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function downloadDraftWithHttpInfo($account_slug, $slug, $sessionkey, $as_hashes = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling downloadDraft');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling downloadDraft');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling downloadDraft');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/draft/documents/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($as_hashes !== null) {
            $queryParams['as_hashes'] = $this->apiClient->getSerializer()->toQueryValue($as_hashes);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                'object[]',
                '/packages/{accountSlug}/{slug}/draft/documents/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'object[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAcquiredPackageAccountList
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $share value used to pass query parameter &#39;share&#39; in the url. (optional)
     * @return \Swagger\Client\Model\SharedPackageAccountsList
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAcquiredPackageAccountList($account_slug, $slug, $sessionkey, $share = null)
    {
        list($response) = $this->getAcquiredPackageAccountListWithHttpInfo($account_slug, $slug, $sessionkey, $share);
        return $response;
    }

    /**
     * Operation getAcquiredPackageAccountListWithHttpInfo
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $share value used to pass query parameter &#39;share&#39; in the url. (optional)
     * @return Array of \Swagger\Client\Model\SharedPackageAccountsList, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAcquiredPackageAccountListWithHttpInfo($account_slug, $slug, $sessionkey, $share = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getAcquiredPackageAccountList');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getAcquiredPackageAccountList');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getAcquiredPackageAccountList');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/acquisitions/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($share !== null) {
            $queryParams['share'] = $this->apiClient->getSerializer()->toQueryValue($share);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\SharedPackageAccountsList',
                '/packages/{accountSlug}/{slug}/acquisitions/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\SharedPackageAccountsList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\SharedPackageAccountsList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCanonical
     *
     * Get detail view of canonical version of a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\CanonicalVersion
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getCanonical($account_slug, $slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getCanonicalWithHttpInfo($account_slug, $slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getCanonicalWithHttpInfo
     *
     * Get detail view of canonical version of a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\CanonicalVersion, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getCanonicalWithHttpInfo($account_slug, $slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getCanonical');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getCanonical');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getCanonical');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/canonical/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\CanonicalVersion',
                '/packages/{accountSlug}/{slug}/canonical/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\CanonicalVersion', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\CanonicalVersion', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDependencies
     *
     * Return package dependencies.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\DependenciesList
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getDependencies($account_slug, $slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getDependenciesWithHttpInfo($account_slug, $slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getDependenciesWithHttpInfo
     *
     * Return package dependencies.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\DependenciesList, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getDependenciesWithHttpInfo($account_slug, $slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getDependencies');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getDependencies');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getDependencies');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/dependencies/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\DependenciesList',
                '/packages/{accountSlug}/{slug}/dependencies/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\DependenciesList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\DependenciesList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDetailDocument
     *
     * Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $name path of the directory. Ex. - meta/config.css (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return object[]
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getDetailDocument($account_slug, $slug, $name, $sessionkey)
    {
        list($response) = $this->getDetailDocumentWithHttpInfo($account_slug, $slug, $name, $sessionkey);
        return $response;
    }

    /**
     * Operation getDetailDocumentWithHttpInfo
     *
     * Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $name path of the directory. Ex. - meta/config.css (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of object[], HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getDetailDocumentWithHttpInfo($account_slug, $slug, $name, $sessionkey)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getDetailDocument');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getDetailDocument');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling getDetailDocument');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getDetailDocument');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/draft/documents/{name}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                "{" . "name" . "}",
                $this->apiClient->getSerializer()->toPathValue($name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                'object[]',
                '/packages/{accountSlug}/{slug}/draft/documents/{name}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'object[]', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object[]', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDraft
     *
     * Get package draft.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return \Swagger\Client\Model\HyperLinkDraft
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getDraft($account_slug, $slug, $sessionkey)
    {
        list($response) = $this->getDraftWithHttpInfo($account_slug, $slug, $sessionkey);
        return $response;
    }

    /**
     * Operation getDraftWithHttpInfo
     *
     * Get package draft.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of \Swagger\Client\Model\HyperLinkDraft, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getDraftWithHttpInfo($account_slug, $slug, $sessionkey)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getDraft');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getDraft');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getDraft');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/draft/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\HyperLinkDraft',
                '/packages/{accountSlug}/{slug}/draft/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\HyperLinkDraft', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\HyperLinkDraft', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLicenses
     *
     * Get list of licenses associated with package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label label for the version (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return \Swagger\Client\Model\HyperLinkLicenses
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getLicenses($account_slug, $slug, $label, $sessionkey)
    {
        list($response) = $this->getLicensesWithHttpInfo($account_slug, $slug, $label, $sessionkey);
        return $response;
    }

    /**
     * Operation getLicensesWithHttpInfo
     *
     * Get list of licenses associated with package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label label for the version (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of \Swagger\Client\Model\HyperLinkLicenses, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getLicensesWithHttpInfo($account_slug, $slug, $label, $sessionkey)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getLicenses');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getLicenses');
        }
        // verify the required parameter 'label' is set
        if ($label === null) {
            throw new \InvalidArgumentException('Missing the required parameter $label when calling getLicenses');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getLicenses');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versions/{label}/licenses/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($label !== null) {
            $resourcePath = str_replace(
                "{" . "label" . "}",
                $this->apiClient->getSerializer()->toPathValue($label),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\HyperLinkLicenses',
                '/packages/{accountSlug}/{slug}/versions/{label}/licenses/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\HyperLinkLicenses', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\HyperLinkLicenses', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPackageDetails
     *
     * Package Detail view.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\BlendedPackage
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPackageDetails($account_slug, $slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getPackageDetailsWithHttpInfo($account_slug, $slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getPackageDetailsWithHttpInfo
     *
     * Package Detail view.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\BlendedPackage, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPackageDetailsWithHttpInfo($account_slug, $slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getPackageDetails');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getPackageDetails');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getPackageDetails');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\BlendedPackage',
                '/packages/{accountSlug}/{slug}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\BlendedPackage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\BlendedPackage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPackageInitial
     *
     * Packages initial
     *
     * @return \Swagger\Client\Model\InitialPackages
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPackageInitial()
    {
        list($response) = $this->getPackageInitialWithHttpInfo();
        return $response;
    }

    /**
     * Operation getPackageInitialWithHttpInfo
     *
     * Packages initial
     *
     * @return Array of \Swagger\Client\Model\InitialPackages, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPackageInitialWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/packages/initial/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\InitialPackages',
                '/packages/initial/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\InitialPackages', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\InitialPackages', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPackages
     *
     * Packages.
     *
     * @param string $account_slug slug of account (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @param string $share parameter to provide list of packages that are shared with current account. (optional)
     * @param string $snapshot parameter to provide list of packages that have snapshots with current account. (optional)
     * @param string $dependency parameter to provide list of dependency packages of all packages of current account. (optional)
     * @param string $purchased parameter to provide list of packages that are purchased (free or paid) in current account. (optional)
     * @param string $transfer_by_me value used to pass query parameter &#39;transfer_by_me&#39; in the url. (optional)
     * @param string $transfer_to_me value used to pass query parameter &#39;transfer_to_me&#39; in the url. (optional)
     * @return \Swagger\Client\Model\Packages
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPackages($account_slug, $sessionkey, $verbose = null, $share = null, $snapshot = null, $dependency = null, $purchased = null, $transfer_by_me = null, $transfer_to_me = null)
    {
        list($response) = $this->getPackagesWithHttpInfo($account_slug, $sessionkey, $verbose, $share, $snapshot, $dependency, $purchased, $transfer_by_me, $transfer_to_me);
        return $response;
    }

    /**
     * Operation getPackagesWithHttpInfo
     *
     * Packages.
     *
     * @param string $account_slug slug of account (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @param string $share parameter to provide list of packages that are shared with current account. (optional)
     * @param string $snapshot parameter to provide list of packages that have snapshots with current account. (optional)
     * @param string $dependency parameter to provide list of dependency packages of all packages of current account. (optional)
     * @param string $purchased parameter to provide list of packages that are purchased (free or paid) in current account. (optional)
     * @param string $transfer_by_me value used to pass query parameter &#39;transfer_by_me&#39; in the url. (optional)
     * @param string $transfer_to_me value used to pass query parameter &#39;transfer_to_me&#39; in the url. (optional)
     * @return Array of \Swagger\Client\Model\Packages, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPackagesWithHttpInfo($account_slug, $sessionkey, $verbose = null, $share = null, $snapshot = null, $dependency = null, $purchased = null, $transfer_by_me = null, $transfer_to_me = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getPackages');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getPackages');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // query params
        if ($share !== null) {
            $queryParams['share'] = $this->apiClient->getSerializer()->toQueryValue($share);
        }
        // query params
        if ($snapshot !== null) {
            $queryParams['snapshot'] = $this->apiClient->getSerializer()->toQueryValue($snapshot);
        }
        // query params
        if ($dependency !== null) {
            $queryParams['dependency'] = $this->apiClient->getSerializer()->toQueryValue($dependency);
        }
        // query params
        if ($purchased !== null) {
            $queryParams['purchased'] = $this->apiClient->getSerializer()->toQueryValue($purchased);
        }
        // query params
        if ($transfer_by_me !== null) {
            $queryParams['transfer_by_me'] = $this->apiClient->getSerializer()->toQueryValue($transfer_by_me);
        }
        // query params
        if ($transfer_to_me !== null) {
            $queryParams['transfer_to_me'] = $this->apiClient->getSerializer()->toQueryValue($transfer_to_me);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Packages',
                '/packages/{accountSlug}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Packages', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Packages', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPublication
     *
     * API used to get a package publication.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @return \Swagger\Client\Model\Publications
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPublication($account_slug, $slug, $sessionkey = null)
    {
        list($response) = $this->getPublicationWithHttpInfo($account_slug, $slug, $sessionkey);
        return $response;
    }

    /**
     * Operation getPublicationWithHttpInfo
     *
     * API used to get a package publication.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @return Array of \Swagger\Client\Model\Publications, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPublicationWithHttpInfo($account_slug, $slug, $sessionkey = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getPublication');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getPublication');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/publications/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Publications',
                '/packages/{accountSlug}/{slug}/publications/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Publications', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Publications', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRatingDetails
     *
     * Get Details of package rating submitted by any user.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\Rating
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getRatingDetails($account_slug, $slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getRatingDetailsWithHttpInfo($account_slug, $slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getRatingDetailsWithHttpInfo
     *
     * Get Details of package rating submitted by any user.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\Rating, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getRatingDetailsWithHttpInfo($account_slug, $slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getRatingDetails');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getRatingDetails');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getRatingDetails');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/ratingdetails/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Rating',
                '/packages/{accountSlug}/{slug}/ratingdetails/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Rating', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Rating', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRatings
     *
     * Returns list of ratings submitted by users for a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\HyperLinkRatings
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getRatings($account_slug, $slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getRatingsWithHttpInfo($account_slug, $slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getRatingsWithHttpInfo
     *
     * Returns list of ratings submitted by users for a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\HyperLinkRatings, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getRatingsWithHttpInfo($account_slug, $slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getRatings');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getRatings');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getRatings');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/ratings/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\HyperLinkRatings',
                '/packages/{accountSlug}/{slug}/ratings/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\HyperLinkRatings', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\HyperLinkRatings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getVersionBundles
     *
     * API used to get a package publication.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @return \Swagger\Client\Model\PublicationVersions
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getVersionBundles($account_slug, $slug, $sessionkey = null)
    {
        list($response) = $this->getVersionBundlesWithHttpInfo($account_slug, $slug, $sessionkey);
        return $response;
    }

    /**
     * Operation getVersionBundlesWithHttpInfo
     *
     * API used to get a package publication.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @return Array of \Swagger\Client\Model\PublicationVersions, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getVersionBundlesWithHttpInfo($account_slug, $slug, $sessionkey = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getVersionBundles');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getVersionBundles');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versionbundles/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\PublicationVersions',
                '/packages/{accountSlug}/{slug}/versionbundles/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\PublicationVersions', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\PublicationVersions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getVersionDetails
     *
     * get version data of a package in details.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label value used to uniquely identify version. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return \Swagger\Client\Model\Version
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getVersionDetails($account_slug, $slug, $label, $sessionkey)
    {
        list($response) = $this->getVersionDetailsWithHttpInfo($account_slug, $slug, $label, $sessionkey);
        return $response;
    }

    /**
     * Operation getVersionDetailsWithHttpInfo
     *
     * get version data of a package in details.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label value used to uniquely identify version. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of \Swagger\Client\Model\Version, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getVersionDetailsWithHttpInfo($account_slug, $slug, $label, $sessionkey)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getVersionDetails');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getVersionDetails');
        }
        // verify the required parameter 'label' is set
        if ($label === null) {
            throw new \InvalidArgumentException('Missing the required parameter $label when calling getVersionDetails');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getVersionDetails');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versions/{label}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($label !== null) {
            $resourcePath = str_replace(
                "{" . "label" . "}",
                $this->apiClient->getSerializer()->toPathValue($label),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Version',
                '/packages/{accountSlug}/{slug}/versions/{label}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Version', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Version', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getVersions
     *
     * return the list of package version
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return \Swagger\Client\Model\Versions
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getVersions($account_slug, $slug, $sessionkey)
    {
        list($response) = $this->getVersionsWithHttpInfo($account_slug, $slug, $sessionkey);
        return $response;
    }

    /**
     * Operation getVersionsWithHttpInfo
     *
     * return the list of package version
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of \Swagger\Client\Model\Versions, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getVersionsWithHttpInfo($account_slug, $slug, $sessionkey)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling getVersions');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getVersions');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getVersions');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versions/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Versions',
                '/packages/{accountSlug}/{slug}/versions/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Versions', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Versions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation packageAccountList
     *
     * Returns list of users.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return \Swagger\Client\Model\Users
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function packageAccountList($account_slug, $slug, $sessionkey)
    {
        list($response) = $this->packageAccountListWithHttpInfo($account_slug, $slug, $sessionkey);
        return $response;
    }

    /**
     * Operation packageAccountListWithHttpInfo
     *
     * Returns list of users.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of \Swagger\Client\Model\Users, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function packageAccountListWithHttpInfo($account_slug, $slug, $sessionkey)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling packageAccountList');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling packageAccountList');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling packageAccountList');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/accounts/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Users',
                '/packages/{accountSlug}/{slug}/accounts/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Users', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Users', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation rejectAcquisitionInvite
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\RejectAcquisitionPackage $body request data used to acquire package. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function rejectAcquisitionInvite($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->rejectAcquisitionInviteWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation rejectAcquisitionInviteWithHttpInfo
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\RejectAcquisitionPackage $body request data used to acquire package. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function rejectAcquisitionInviteWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling rejectAcquisitionInvite');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling rejectAcquisitionInvite');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling rejectAcquisitionInvite');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling rejectAcquisitionInvite');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/reject/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/reject/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation removeLicense
     *
     * delete a package license.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label label for the version (required)
     * @param string $name name of the license (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removeLicense($account_slug, $slug, $label, $name, $sessionkey)
    {
        list($response) = $this->removeLicenseWithHttpInfo($account_slug, $slug, $label, $name, $sessionkey);
        return $response;
    }

    /**
     * Operation removeLicenseWithHttpInfo
     *
     * delete a package license.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label label for the version (required)
     * @param string $name name of the license (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removeLicenseWithHttpInfo($account_slug, $slug, $label, $name, $sessionkey)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling removeLicense');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling removeLicense');
        }
        // verify the required parameter 'label' is set
        if ($label === null) {
            throw new \InvalidArgumentException('Missing the required parameter $label when calling removeLicense');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling removeLicense');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling removeLicense');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($label !== null) {
            $resourcePath = str_replace(
                "{" . "label" . "}",
                $this->apiClient->getSerializer()->toPathValue($label),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                "{" . "name" . "}",
                $this->apiClient->getSerializer()->toPathValue($name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation resendInvite
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\ResendInvite $body request data used to acquire package. (required)
     * @return \Swagger\Client\Model\BlendedPackage
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function resendInvite($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->resendInviteWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation resendInviteWithHttpInfo
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\ResendInvite $body request data used to acquire package. (required)
     * @return Array of \Swagger\Client\Model\BlendedPackage, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function resendInviteWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling resendInvite');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling resendInvite');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling resendInvite');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling resendInvite');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/resend/invite/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\BlendedPackage',
                '/packages/{accountSlug}/{slug}/resend/invite/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\BlendedPackage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\BlendedPackage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation revokeAcquiredPackage
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\Acquisition $body request data used to acquire package. (required)
     * @return \Swagger\Client\Model\BlendedPackage
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function revokeAcquiredPackage($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->revokeAcquiredPackageWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation revokeAcquiredPackageWithHttpInfo
     *
     * API to acquire package between accounts.
     *
     * @param string $account_slug accounts slug (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\Acquisition $body request data used to acquire package. (required)
     * @return Array of \Swagger\Client\Model\BlendedPackage, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function revokeAcquiredPackageWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling revokeAcquiredPackage');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling revokeAcquiredPackage');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling revokeAcquiredPackage');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling revokeAcquiredPackage');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/acquisitions/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\BlendedPackage',
                '/packages/{accountSlug}/{slug}/acquisitions/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\BlendedPackage', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\BlendedPackage', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation search
     *
     * Search Packages.
     *
     * @param string $filter_by filter by parameters. (optional)
     * @param string $order_by to order package display. (optional)
     * @return \Swagger\Client\Model\SearchResults
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function search($filter_by = null, $order_by = null)
    {
        list($response) = $this->searchWithHttpInfo($filter_by, $order_by);
        return $response;
    }

    /**
     * Operation searchWithHttpInfo
     *
     * Search Packages.
     *
     * @param string $filter_by filter by parameters. (optional)
     * @param string $order_by to order package display. (optional)
     * @return Array of \Swagger\Client\Model\SearchResults, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function searchWithHttpInfo($filter_by = null, $order_by = null)
    {
        // parse inputs
        $resourcePath = "/search/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($filter_by !== null) {
            $queryParams['filter_by'] = $this->apiClient->getSerializer()->toQueryValue($filter_by);
        }
        // query params
        if ($order_by !== null) {
            $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($order_by);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\SearchResults',
                '/search/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\SearchResults', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\SearchResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation snapshot
     *
     * Create a snapshot of a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\CreateVersion $body request data used to snapshot package. (required)
     * @return \Swagger\Client\Model\Version
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function snapshot($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->snapshotWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation snapshotWithHttpInfo
     *
     * Create a snapshot of a package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\CreateVersion $body request data used to snapshot package. (required)
     * @return Array of \Swagger\Client\Model\Version, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function snapshotWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling snapshot');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling snapshot');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling snapshot');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling snapshot');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versions/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Version',
                '/packages/{accountSlug}/{slug}/versions/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Version', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Version', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDraft
     *
     * Update package draft.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\UpdateDraft $body request data used to update package draft. (required)
     * @return \Swagger\Client\Model\NewDraft
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updateDraft($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->updateDraftWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation updateDraftWithHttpInfo
     *
     * Update package draft.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\UpdateDraft $body request data used to update package draft. (required)
     * @return Array of \Swagger\Client\Model\NewDraft, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updateDraftWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling updateDraft');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling updateDraft');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling updateDraft');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updateDraft');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/draft/documents/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\NewDraft',
                '/packages/{accountSlug}/{slug}/draft/documents/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\NewDraft', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\NewDraft', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateLicense
     *
     * Update price of package license.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label label for the version (required)
     * @param string $name name of the license (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\UpdateLicense $body request data used to update license price. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updateLicense($account_slug, $slug, $label, $name, $sessionkey, $body)
    {
        list($response) = $this->updateLicenseWithHttpInfo($account_slug, $slug, $label, $name, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation updateLicenseWithHttpInfo
     *
     * Update price of package license.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $label label for the version (required)
     * @param string $name name of the license (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\UpdateLicense $body request data used to update license price. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updateLicenseWithHttpInfo($account_slug, $slug, $label, $name, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling updateLicense');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling updateLicense');
        }
        // verify the required parameter 'label' is set
        if ($label === null) {
            throw new \InvalidArgumentException('Missing the required parameter $label when calling updateLicense');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling updateLicense');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling updateLicense');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updateLicense');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($label !== null) {
            $resourcePath = str_replace(
                "{" . "label" . "}",
                $this->apiClient->getSerializer()->toPathValue($label),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                "{" . "name" . "}",
                $this->apiClient->getSerializer()->toPathValue($name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePackage
     *
     * Update Package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\UpdatePackage $body request data used to update package. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updatePackage($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->updatePackageWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation updatePackageWithHttpInfo
     *
     * Update Package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\UpdatePackage $body request data used to update package. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updatePackageWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling updatePackage');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling updatePackage');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling updatePackage');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updatePackage');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePublication
     *
     * API used to update package publication.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param \Swagger\Client\Model\UpdatePublication $body request data used to update package. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @param string $commit passing &#39;0&#39; will just validated not update the publication while &#39;1&#39; will update the data too. (optional)
     * @return object
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updatePublication($account_slug, $slug, $body, $sessionkey = null, $commit = null)
    {
        list($response) = $this->updatePublicationWithHttpInfo($account_slug, $slug, $body, $sessionkey, $commit);
        return $response;
    }

    /**
     * Operation updatePublicationWithHttpInfo
     *
     * API used to update package publication.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param \Swagger\Client\Model\UpdatePublication $body request data used to update package. (required)
     * @param string $sessionkey value used to manage user session. (optional)
     * @param string $commit passing &#39;0&#39; will just validated not update the publication while &#39;1&#39; will update the data too. (optional)
     * @return Array of object, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updatePublicationWithHttpInfo($account_slug, $slug, $body, $sessionkey = null, $commit = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling updatePublication');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling updatePublication');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updatePublication');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/publications/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($commit !== null) {
            $queryParams['commit'] = $this->apiClient->getSerializer()->toQueryValue($commit);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                'object',
                '/packages/{accountSlug}/{slug}/publications/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'object', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\PublicationsError', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRating
     *
     * Update rating of package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddRating $body request data used to update rating. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updateRating($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->updateRatingWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation updateRatingWithHttpInfo
     *
     * Update rating of package.
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddRating $body request data used to update rating. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updateRatingWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling updateRating');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling updateRating');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling updateRating');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updateRating');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/ratingdetails/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/ratingdetails/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation uploadMedia
     *
     * Upload a media file to package's draft
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $hash_value  (required)
     * @param string $name  (optional)
     * @param string $token  (optional)
     * @param \SplFileObject $image media file (optional)
     * @return \Swagger\Client\Model\InlineResponse200
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function uploadMedia($account_slug, $slug, $sessionkey, $hash_value, $name = null, $token = null, $image = null)
    {
        list($response) = $this->uploadMediaWithHttpInfo($account_slug, $slug, $sessionkey, $hash_value, $name, $token, $image);
        return $response;
    }

    /**
     * Operation uploadMediaWithHttpInfo
     *
     * Upload a media file to package's draft
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $hash_value  (required)
     * @param string $name  (optional)
     * @param string $token  (optional)
     * @param \SplFileObject $image media file (optional)
     * @return Array of \Swagger\Client\Model\InlineResponse200, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function uploadMediaWithHttpInfo($account_slug, $slug, $sessionkey, $hash_value, $name = null, $token = null, $image = null)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling uploadMedia');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling uploadMedia');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling uploadMedia');
        }
        // verify the required parameter 'hash_value' is set
        if ($hash_value === null) {
            throw new \InvalidArgumentException('Missing the required parameter $hash_value when calling uploadMedia');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/media/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('multipart/form-data'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($hash_value !== null) {
            $formParams['hash_value'] = $this->apiClient->getSerializer()->toFormValue($hash_value);
        }
        // form params
        if ($name !== null) {
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
        }
        // form params
        if ($token !== null) {
            $formParams['token'] = $this->apiClient->getSerializer()->toFormValue($token);
        }
        // form params
        if ($image !== null) {
            // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
            // See: https://wiki.php.net/rfc/curl-file-upload
            if (function_exists('curl_file_create')) {
                $formParams['image'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($image));
            } else {
                $formParams['image'] = '@' . $this->apiClient->getSerializer()->toFormValue($image);
            }
        }
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\InlineResponse200',
                '/packages/{accountSlug}/{slug}/media/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\InlineResponse200', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\InlineResponse200', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation validatePublication
     *
     * Validate publication object
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\Body1 $body request data used to add package rating. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function validatePublication($account_slug, $slug, $sessionkey, $body)
    {
        list($response) = $this->validatePublicationWithHttpInfo($account_slug, $slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation validatePublicationWithHttpInfo
     *
     * Validate publication object
     *
     * @param string $account_slug slug of account (required)
     * @param string $slug slug of package to return. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\Body1 $body request data used to add package rating. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function validatePublicationWithHttpInfo($account_slug, $slug, $sessionkey, $body)
    {
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling validatePublication');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling validatePublication');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling validatePublication');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling validatePublication');
        }
        // parse inputs
        $resourcePath = "/packages/{accountSlug}/{slug}/publicationvalidations/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "accountSlug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/packages/{accountSlug}/{slug}/publicationvalidations/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
