<?php

//namespace Drupal\hostlib\Controller\inc;

use Blended\hostlib\Blended_ini_Parser;
use Drupal\system\Entity\Menu;

class hostAuthenticator
{

    /**
     * Authenticating wordpress user session on every request and sets user session.
     * 
     * @param  string $hubSession is the current Hub logged-in user ID
     * @param  string $wpSession  is the current wordpress logged-in user ID
     * @return string wordpress user sessionKey.
     */
    function blended_authenticate($hubSession, $cookie)
    {
	$cookie = explode('=', $cookie);
        $userCookie = $cookie[0];
        $this->set_session_key($hubSession, $userCookie);

        return $hubSession;
    }

    /**
     * Validate wordpress user session on every request.
     * 
     * @param  string $hub_session is the current Hub logged-in user ID
     * @param  string $wp_session  is the current wordpress logged-in user ID
     * @return string|false Hub user sessionKey else offline if user not loged-in to Hub.
     */
    function blended_session_setter($cookie)
    {       
	$cookie = explode('=', $cookie);
        $cookie = $cookie[0];
        if ($cookie != false) {
            $sessions = $this->get_session_key();
            if (isset($sessions[$cookie])) {
                return $sessions[$cookie];
            } else {
                return "offline";
            }
        } else {
            return false;
        }
    }

    /**
     * Get Hub session_key required to communicate to Network.
     * 
     * @param  string $user_id is the current wordpress logged-in user ID
     * @return string saved Hub settings.
     */
    function get_session_key($cookie = null)
    {
        /**
         * user settings.
         *
         * @access global
         * @var    string
         */
        global $blendedConfig;
        
        $sessions = null;
        $blendedConfig = new Blended_ini_Parser(drupal_get_path('module', 'hostlib') . "/" . "src/Controller/hostlib/src/config.ini");
        $sessions = $blendedConfig->get("setup_configuration", "SESSION_KEY");
        $sessions = json_decode($sessions, true);
        
        return $sessions;
    }

    /**
     * Set Hub session_key required to communicate to Network on to current configuration.
     * 
     * @param  string $sessionKey is the current Hub logged-in user ID
     * @param  string $userId     is the current wordpress logged-in user ID
     * @return string saved sessionKey.
     */
    function set_session_key($sessionKey, $cookie = null)
    {
        /**
         * user settings.
         *
         * @access global
         * @var    string
         */
        global $blendedConfig;
        
        $sessions = $this->get_session_key();
        if (is_null($sessionKey)) {
            unset($sessions[$cookie]);
        } else {
            $sessions = array($cookie => $sessionKey);
        }        
        $sessions = json_encode($sessions);
        $blendedConfig->setValue("setup_configuration", "SESSION_KEY", $sessions);
        $blendedConfig->save(drupal_get_path('module', 'hostlib') . "/" . "src/Controller/hostlib/src/config.ini");
        $session = $this->get_session_key($cookie);

        return $session;
    }

    /**
     * Get nav default settings for admin
     *
     * @return array default navigations for admin nav settings
     */
    function get_nav_list() {
        /**
         * Blended API namespace.
         * Defined within network.
         *
         * @access global
         * @var    string
         */
        global $NAMESPACE;

        //Get Host/WordPress menu
        $menus = Menu::loadMultiple();
        $settings = array();
        $hostMenus = array();
        if (!empty($menus)) {
            foreach ($menus as $key => $value) {
                $hostMenus["types"] = "host";
                $hostMenus["label"] = t("Drupal - ". $value->get('label'));
                $hostMenus["id"] = $value->get('id');
                $hostMenus["href"] = blended_home_url() . "/" . $NAMESPACE . "/menus/" . $value->get('id');
                $settings[] = $hostMenus;
            }
        }

        //JSON Web Service
        $settings[] = array(
            "types" => "url",
            "label" => t("JSON Web Service"),
            "id" => "nav_jws",
            "data" => "#"
        );
        //Custom Static JSON
        $settings[] = array(
            "types" => "custom",
            "label" => t("Custom Static JSON"),
            "id" => "nav_csj",
            "data" => "#"
        );

        return array("items" => $settings);
    }
}
