# SwaggerClient-php
A collection of Swagger documentation for the Blended Hub APIs.

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Build date: 2019-07-30T13:50:05.216+05:30
- Build package: class io.swagger.codegen.languages.PhpClientCodegen
For more information, please visit [http://blended.co](http://blended.co)

## Requirements

PHP 5.4.0 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/GIT_USER_ID/GIT_REPO_ID.git"
    }
  ],
  "require": {
    "GIT_USER_ID/GIT_REPO_ID": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/SwaggerClient-php/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit lib/Tests
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddAdmin(); // \Swagger\Client\Model\AddAdmin | the content of the request used to add admin into account.

try {
    $api_instance->addAccountAdmin($slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->addAccountAdmin: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://stgqahub.blended.co/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**addAccountAdmin**](docs/Api/AccountsApi.md#addaccountadmin) | **POST** /accounts/{slug}/admins/ | Add a admin user into account.
*AccountsApi* | [**addAccountUser**](docs/Api/AccountsApi.md#addaccountuser) | **POST** /accounts/{slug}/users/ | Add a regular user into account.
*AccountsApi* | [**changeAccountUserPrivilege**](docs/Api/AccountsApi.md#changeaccountuserprivilege) | **PUT** /accounts/{slug}/users/{user_slug}/ | account Regular user.
*AccountsApi* | [**createAccount**](docs/Api/AccountsApi.md#createaccount) | **POST** /accounts/ | Create a new user account.
*AccountsApi* | [**getAccountAdmin**](docs/Api/AccountsApi.md#getaccountadmin) | **GET** /accounts/{slug}/admins/{admin_slug}/ | Get account Admin.
*AccountsApi* | [**getAccountAdmins**](docs/Api/AccountsApi.md#getaccountadmins) | **GET** /accounts/{slug}/admins/ | get admin users of account.
*AccountsApi* | [**getAccountDetails**](docs/Api/AccountsApi.md#getaccountdetails) | **GET** /accounts/{slug}/ | Detail View of user account.
*AccountsApi* | [**getAccountInvitesPendingList**](docs/Api/AccountsApi.md#getaccountinvitespendinglist) | **GET** /accounts/{slug}/accountpendings/ | To get the List of all accounts who invite the user and request is pending to accept or reject.
*AccountsApi* | [**getAccountList**](docs/Api/AccountsApi.md#getaccountlist) | **GET** /accounts/{slug}/accounts/ | Returns all accounts from the system that the user has access to.
*AccountsApi* | [**getAccountUser**](docs/Api/AccountsApi.md#getaccountuser) | **GET** /accounts/{slug}/users/{user_slug}/ | account Regular user.
*AccountsApi* | [**getAccountUsers**](docs/Api/AccountsApi.md#getaccountusers) | **GET** /accounts/{slug}/users/ | get Regular Users of account.
*AccountsApi* | [**getCurrentAccount**](docs/Api/AccountsApi.md#getcurrentaccount) | **GET** /accounts/{slug}/current/ | Get current user account.
*AccountsApi* | [**getPendingUsers**](docs/Api/AccountsApi.md#getpendingusers) | **GET** /accounts/{slug}/pendings/ | Get list of user&#39;s account pending users.
*AccountsApi* | [**inviteUser**](docs/Api/AccountsApi.md#inviteuser) | **POST** /accounts/{slug}/pendings/ | Invite user to join account.
*AccountsApi* | [**leaveAccount**](docs/Api/AccountsApi.md#leaveaccount) | **DELETE** /accounts/{slug}/accounts/ | Returns all accounts from the system that the user has access to.
*AccountsApi* | [**login**](docs/Api/AccountsApi.md#login) | **POST** /login/ | Logs user account into the system.
*AccountsApi* | [**logout**](docs/Api/AccountsApi.md#logout) | **POST** /logout/ | Logs out current logged in user account session.
*AccountsApi* | [**rejectUserInvite**](docs/Api/AccountsApi.md#rejectuserinvite) | **DELETE** /accounts/{slug}/users/ | Reject User invitation of account.
*AccountsApi* | [**removeAccount**](docs/Api/AccountsApi.md#removeaccount) | **DELETE** /accounts/{slug}/accounts/{account_slug}/ | Remove user Account.
*AccountsApi* | [**removeAccountAdmin**](docs/Api/AccountsApi.md#removeaccountadmin) | **DELETE** /accounts/{slug}/admins/{admin_slug}/ | deletes a admin user from account.
*AccountsApi* | [**removeAccountUser**](docs/Api/AccountsApi.md#removeaccountuser) | **DELETE** /accounts/{slug}/users/{user_slug}/ | Delete a regular user from account.
*AccountsApi* | [**removePendingInvitedUser**](docs/Api/AccountsApi.md#removependinginviteduser) | **DELETE** /accounts/{slug}/pendings/ | Invite user to join account.
*AccountsApi* | [**resendAccountVerificationEmail**](docs/Api/AccountsApi.md#resendaccountverificationemail) | **PUT** /accounts/resend/emailverification/ | Resend Email Verification link to verifiy account if already not verified.
*AccountsApi* | [**resetPassword**](docs/Api/AccountsApi.md#resetpassword) | **POST** /reset/ | Reset password of user account.
*AccountsApi* | [**searchAccounts**](docs/Api/AccountsApi.md#searchaccounts) | **GET** /accounts/search/{pattern}/ | Search accounts by starting keywords of account name .
*AccountsApi* | [**setCurrentAccount**](docs/Api/AccountsApi.md#setcurrentaccount) | **PUT** /accounts/{slug}/current/ | Set user current account.
*AccountsApi* | [**updateAccount**](docs/Api/AccountsApi.md#updateaccount) | **PUT** /accounts/{slug}/ | Update User Account.
*PackagesApi* | [**acceptAcquisition**](docs/Api/PackagesApi.md#acceptacquisition) | **PUT** /packages/{accountSlug}/{slug}/acquisitions/ | API to accept package.
*PackagesApi* | [**acquirePackage**](docs/Api/PackagesApi.md#acquirepackage) | **POST** /packages/{accountSlug}/{slug}/acquisitions/ | API to acquire package between accounts.
*PackagesApi* | [**addLicense**](docs/Api/PackagesApi.md#addlicense) | **POST** /packages/{accountSlug}/{slug}/versions/{label}/licenses/ | Add a license to package.
*PackagesApi* | [**addLike**](docs/Api/PackagesApi.md#addlike) | **POST** /packages/{accountSlug}/{slug}/likes/ | Add a like to a package.
*PackagesApi* | [**addRating**](docs/Api/PackagesApi.md#addrating) | **POST** /packages/{accountSlug}/{slug}/ratings/ | Add a rating to a package.
*PackagesApi* | [**canonicalSet**](docs/Api/PackagesApi.md#canonicalset) | **PUT** /packages/{accountSlug}/{slug}/canonical/ | Get package draft.
*PackagesApi* | [**createDraft**](docs/Api/PackagesApi.md#createdraft) | **POST** /packages/{accountSlug}/{slug}/draft/documents/ | Create package draft.
*PackagesApi* | [**createPackage**](docs/Api/PackagesApi.md#createpackage) | **POST** /packages/{accountSlug}/ | Create Package.
*PackagesApi* | [**download**](docs/Api/PackagesApi.md#download) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/documents/ | get version documents
*PackagesApi* | [**downloadCanonical**](docs/Api/PackagesApi.md#downloadcanonical) | **GET** /packages/{accountSlug}/{slug}/canonical/documents/ | API used to Download a package.
*PackagesApi* | [**downloadDraft**](docs/Api/PackagesApi.md#downloaddraft) | **GET** /packages/{accountSlug}/{slug}/draft/documents/ | Download package draft.
*PackagesApi* | [**getAcquiredPackageAccountList**](docs/Api/PackagesApi.md#getacquiredpackageaccountlist) | **GET** /packages/{accountSlug}/{slug}/acquisitions/ | API to acquire package between accounts.
*PackagesApi* | [**getCanonical**](docs/Api/PackagesApi.md#getcanonical) | **GET** /packages/{accountSlug}/{slug}/canonical/ | Get detail view of canonical version of a package.
*PackagesApi* | [**getDependencies**](docs/Api/PackagesApi.md#getdependencies) | **GET** /packages/{accountSlug}/{slug}/dependencies/ | Return package dependencies.
*PackagesApi* | [**getDetailDocument**](docs/Api/PackagesApi.md#getdetaildocument) | **GET** /packages/{accountSlug}/{slug}/draft/documents/{name}/ | Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)
*PackagesApi* | [**getDraft**](docs/Api/PackagesApi.md#getdraft) | **GET** /packages/{accountSlug}/{slug}/draft/ | Get package draft.
*PackagesApi* | [**getLicenses**](docs/Api/PackagesApi.md#getlicenses) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/licenses/ | Get list of licenses associated with package.
*PackagesApi* | [**getPackageDetails**](docs/Api/PackagesApi.md#getpackagedetails) | **GET** /packages/{accountSlug}/{slug}/ | Package Detail view.
*PackagesApi* | [**getPackageInitial**](docs/Api/PackagesApi.md#getpackageinitial) | **GET** /packages/initial/ | Packages initial
*PackagesApi* | [**getPackages**](docs/Api/PackagesApi.md#getpackages) | **GET** /packages/{accountSlug}/ | Packages.
*PackagesApi* | [**getPublication**](docs/Api/PackagesApi.md#getpublication) | **GET** /packages/{accountSlug}/{slug}/publications/ | API used to get a package publication.
*PackagesApi* | [**getRatingDetails**](docs/Api/PackagesApi.md#getratingdetails) | **GET** /packages/{accountSlug}/{slug}/ratingdetails/ | Get Details of package rating submitted by any user.
*PackagesApi* | [**getRatings**](docs/Api/PackagesApi.md#getratings) | **GET** /packages/{accountSlug}/{slug}/ratings/ | Returns list of ratings submitted by users for a package.
*PackagesApi* | [**getVersionBundles**](docs/Api/PackagesApi.md#getversionbundles) | **GET** /packages/{accountSlug}/{slug}/versionbundles/ | API used to get a package publication.
*PackagesApi* | [**getVersionDetails**](docs/Api/PackagesApi.md#getversiondetails) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/ | get version data of a package in details.
*PackagesApi* | [**getVersions**](docs/Api/PackagesApi.md#getversions) | **GET** /packages/{accountSlug}/{slug}/versions/ | return the list of package version
*PackagesApi* | [**getlike**](docs/Api/PackagesApi.md#getlike) | **GET** /packages/{accountSlug}/{slug}/likes/ | Returns like submitted by users for a package.
*PackagesApi* | [**packageAccountList**](docs/Api/PackagesApi.md#packageaccountlist) | **GET** /packages/{accountSlug}/{slug}/accounts/ | Returns list of users.
*PackagesApi* | [**rejectAcquisitionInvite**](docs/Api/PackagesApi.md#rejectacquisitioninvite) | **PUT** /packages/{accountSlug}/{slug}/reject/ | API to acquire package between accounts.
*PackagesApi* | [**removeLicense**](docs/Api/PackagesApi.md#removelicense) | **DELETE** /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/ | delete a package license.
*PackagesApi* | [**removeLike**](docs/Api/PackagesApi.md#removelike) | **DELETE** /packages/{accountSlug}/{slug}/likes/ | delete a package like.
*PackagesApi* | [**resendInvite**](docs/Api/PackagesApi.md#resendinvite) | **POST** /packages/{accountSlug}/{slug}/resend/invite/ | API to acquire package between accounts.
*PackagesApi* | [**revokeAcquiredPackage**](docs/Api/PackagesApi.md#revokeacquiredpackage) | **DELETE** /packages/{accountSlug}/{slug}/acquisitions/ | API to acquire package between accounts.
*PackagesApi* | [**search**](docs/Api/PackagesApi.md#search) | **GET** /search/ | Search Packages.
*PackagesApi* | [**snapshot**](docs/Api/PackagesApi.md#snapshot) | **POST** /packages/{accountSlug}/{slug}/versions/ | Create a snapshot of a package.
*PackagesApi* | [**updateDraft**](docs/Api/PackagesApi.md#updatedraft) | **PUT** /packages/{accountSlug}/{slug}/draft/documents/ | Update package draft.
*PackagesApi* | [**updateLicense**](docs/Api/PackagesApi.md#updatelicense) | **PUT** /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/ | Update price of package license.
*PackagesApi* | [**updatePackage**](docs/Api/PackagesApi.md#updatepackage) | **PUT** /packages/{accountSlug}/{slug}/ | Update Package.
*PackagesApi* | [**updatePublication**](docs/Api/PackagesApi.md#updatepublication) | **PUT** /packages/{accountSlug}/{slug}/publications/ | API used to update package publication.
*PackagesApi* | [**updateRating**](docs/Api/PackagesApi.md#updaterating) | **PUT** /packages/{accountSlug}/{slug}/ratingdetails/ | Update rating of package.
*PackagesApi* | [**uploadMedia**](docs/Api/PackagesApi.md#uploadmedia) | **POST** /packages/{accountSlug}/{slug}/media/ | Upload a media file to package&#39;s draft
*PackagesApi* | [**validatePublication**](docs/Api/PackagesApi.md#validatepublication) | **POST** /packages/{accountSlug}/{slug}/publicationvalidations/ | Validate publication object


## Documentation For Models

 - [Account](docs/Model/Account.md)
 - [AccountInvitePending](docs/Model/AccountInvitePending.md)
 - [AccountInvitesPendingList](docs/Model/AccountInvitesPendingList.md)
 - [Accounts](docs/Model/Accounts.md)
 - [Acquisition](docs/Model/Acquisition.md)
 - [Activationchallenge](docs/Model/Activationchallenge.md)
 - [ActiveAccount](docs/Model/ActiveAccount.md)
 - [AddAccount](docs/Model/AddAccount.md)
 - [AddAdmin](docs/Model/AddAdmin.md)
 - [AddLicense](docs/Model/AddLicense.md)
 - [AddPending](docs/Model/AddPending.md)
 - [AddRating](docs/Model/AddRating.md)
 - [AllLicensePrice](docs/Model/AllLicensePrice.md)
 - [BlendedPackage](docs/Model/BlendedPackage.md)
 - [Body](docs/Model/Body.md)
 - [Body1](docs/Model/Body1.md)
 - [BundledPackages](docs/Model/BundledPackages.md)
 - [BundledPackagesError](docs/Model/BundledPackagesError.md)
 - [CanonicalVersion](docs/Model/CanonicalVersion.md)
 - [ChangeCurrentAccount](docs/Model/ChangeCurrentAccount.md)
 - [ChangePrivilege](docs/Model/ChangePrivilege.md)
 - [CreateAccount](docs/Model/CreateAccount.md)
 - [CreateCanonical](docs/Model/CreateCanonical.md)
 - [CreatePackage](docs/Model/CreatePackage.md)
 - [CreateVersion](docs/Model/CreateVersion.md)
 - [Dependencies](docs/Model/Dependencies.md)
 - [DependenciesList](docs/Model/DependenciesList.md)
 - [DependencyPackageDetail](docs/Model/DependencyPackageDetail.md)
 - [Documents](docs/Model/Documents.md)
 - [Error](docs/Model/Error.md)
 - [ErrorResponse400](docs/Model/ErrorResponse400.md)
 - [ErrorResponse401](docs/Model/ErrorResponse401.md)
 - [ErrorResponse409](docs/Model/ErrorResponse409.md)
 - [ErrorResponse412](docs/Model/ErrorResponse412.md)
 - [ErrorResponse500](docs/Model/ErrorResponse500.md)
 - [FailedDependencyError](docs/Model/FailedDependencyError.md)
 - [HyperLinkAccount](docs/Model/HyperLinkAccount.md)
 - [HyperLinkCanonicalVersion](docs/Model/HyperLinkCanonicalVersion.md)
 - [HyperLinkCurrentAccount](docs/Model/HyperLinkCurrentAccount.md)
 - [HyperLinkDependencyPackages](docs/Model/HyperLinkDependencyPackages.md)
 - [HyperLinkDraft](docs/Model/HyperLinkDraft.md)
 - [HyperLinkLicenses](docs/Model/HyperLinkLicenses.md)
 - [HyperLinkPendingUser](docs/Model/HyperLinkPendingUser.md)
 - [HyperLinkRatings](docs/Model/HyperLinkRatings.md)
 - [HyperLinkUser](docs/Model/HyperLinkUser.md)
 - [HyperLinkValidators](docs/Model/HyperLinkValidators.md)
 - [InitialPackage](docs/Model/InitialPackage.md)
 - [InitialPackages](docs/Model/InitialPackages.md)
 - [InlineResponse200](docs/Model/InlineResponse200.md)
 - [License](docs/Model/License.md)
 - [Like](docs/Model/Like.md)
 - [Login](docs/Model/Login.md)
 - [Logout](docs/Model/Logout.md)
 - [NewDraft](docs/Model/NewDraft.md)
 - [Operands](docs/Model/Operands.md)
 - [PackageImages](docs/Model/PackageImages.md)
 - [Packages](docs/Model/Packages.md)
 - [PendingUser](docs/Model/PendingUser.md)
 - [PendingUsers](docs/Model/PendingUsers.md)
 - [Publication](docs/Model/Publication.md)
 - [PublicationError](docs/Model/PublicationError.md)
 - [PublicationValidationError](docs/Model/PublicationValidationError.md)
 - [PublicationVersion](docs/Model/PublicationVersion.md)
 - [PublicationVersionError](docs/Model/PublicationVersionError.md)
 - [PublicationVersions](docs/Model/PublicationVersions.md)
 - [PublicationVersionsError](docs/Model/PublicationVersionsError.md)
 - [Publications](docs/Model/Publications.md)
 - [PublicationsError](docs/Model/PublicationsError.md)
 - [Rating](docs/Model/Rating.md)
 - [RejectAcquisitionPackage](docs/Model/RejectAcquisitionPackage.md)
 - [RemovePending](docs/Model/RemovePending.md)
 - [ResendAccountVerificationLink](docs/Model/ResendAccountVerificationLink.md)
 - [ResendInvite](docs/Model/ResendInvite.md)
 - [ResetPassword](docs/Model/ResetPassword.md)
 - [SearchResult](docs/Model/SearchResult.md)
 - [SearchResults](docs/Model/SearchResults.md)
 - [SessionData](docs/Model/SessionData.md)
 - [ShareApprovalListError](docs/Model/ShareApprovalListError.md)
 - [SharedPackageAccount](docs/Model/SharedPackageAccount.md)
 - [SharedPackageAccountsList](docs/Model/SharedPackageAccountsList.md)
 - [UpdateAccount](docs/Model/UpdateAccount.md)
 - [UpdateDraft](docs/Model/UpdateDraft.md)
 - [UpdateLicense](docs/Model/UpdateLicense.md)
 - [UpdatePackage](docs/Model/UpdatePackage.md)
 - [UpdatePublication](docs/Model/UpdatePublication.md)
 - [UpdateVersion](docs/Model/UpdateVersion.md)
 - [UploadMedia](docs/Model/UploadMedia.md)
 - [User](docs/Model/User.md)
 - [Users](docs/Model/Users.md)
 - [Validator](docs/Model/Validator.md)
 - [ValidatorPlan](docs/Model/ValidatorPlan.md)
 - [Version](docs/Model/Version.md)
 - [Versions](docs/Model/Versions.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

api@blended.co


