<?php
/**
 * Publication
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * Publication Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Publication implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Publication';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'license_name' => 'string',
        'license_type' => 'string',
        'license_type_value' => 'string',
        'price' => 'float',
        'total_price' => 'float',
        'allow_listed' => 'bool',
        'allow_bundled' => 'bool',
        'allow_auto_add' => 'bool',
        'upgrades' => 'string',
        'versions' => '\Swagger\Client\Model\PublicationVersion[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'license_name' => 'license_name',
        'license_type' => 'license_type',
        'license_type_value' => 'license_type_value',
        'price' => 'price',
        'total_price' => 'total_price',
        'allow_listed' => 'allow_listed',
        'allow_bundled' => 'allow_bundled',
        'allow_auto_add' => 'allow_auto_add',
        'upgrades' => 'upgrades',
        'versions' => 'versions'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'license_name' => 'setLicenseName',
        'license_type' => 'setLicenseType',
        'license_type_value' => 'setLicenseTypeValue',
        'price' => 'setPrice',
        'total_price' => 'setTotalPrice',
        'allow_listed' => 'setAllowListed',
        'allow_bundled' => 'setAllowBundled',
        'allow_auto_add' => 'setAllowAutoAdd',
        'upgrades' => 'setUpgrades',
        'versions' => 'setVersions'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'license_name' => 'getLicenseName',
        'license_type' => 'getLicenseType',
        'license_type_value' => 'getLicenseTypeValue',
        'price' => 'getPrice',
        'total_price' => 'getTotalPrice',
        'allow_listed' => 'getAllowListed',
        'allow_bundled' => 'getAllowBundled',
        'allow_auto_add' => 'getAllowAutoAdd',
        'upgrades' => 'getUpgrades',
        'versions' => 'getVersions'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['license_name'] = isset($data['license_name']) ? $data['license_name'] : null;
        $this->container['license_type'] = isset($data['license_type']) ? $data['license_type'] : null;
        $this->container['license_type_value'] = isset($data['license_type_value']) ? $data['license_type_value'] : null;
        $this->container['price'] = isset($data['price']) ? $data['price'] : null;
        $this->container['total_price'] = isset($data['total_price']) ? $data['total_price'] : null;
        $this->container['allow_listed'] = isset($data['allow_listed']) ? $data['allow_listed'] : null;
        $this->container['allow_bundled'] = isset($data['allow_bundled']) ? $data['allow_bundled'] : null;
        $this->container['allow_auto_add'] = isset($data['allow_auto_add']) ? $data['allow_auto_add'] : null;
        $this->container['upgrades'] = isset($data['upgrades']) ? $data['upgrades'] : null;
        $this->container['versions'] = isset($data['versions']) ? $data['versions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['license_name'] === null) {
            $invalid_properties[] = "'license_name' can't be null";
        }
        if ($this->container['license_type'] === null) {
            $invalid_properties[] = "'license_type' can't be null";
        }
        if ($this->container['price'] === null) {
            $invalid_properties[] = "'price' can't be null";
        }
        if ($this->container['allow_listed'] === null) {
            $invalid_properties[] = "'allow_listed' can't be null";
        }
        if ($this->container['allow_bundled'] === null) {
            $invalid_properties[] = "'allow_bundled' can't be null";
        }
        if ($this->container['allow_auto_add'] === null) {
            $invalid_properties[] = "'allow_auto_add' can't be null";
        }
        if ($this->container['upgrades'] === null) {
            $invalid_properties[] = "'upgrades' can't be null";
        }
        if ($this->container['versions'] === null) {
            $invalid_properties[] = "'versions' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['license_name'] === null) {
            return false;
        }
        if ($this->container['license_type'] === null) {
            return false;
        }
        if ($this->container['price'] === null) {
            return false;
        }
        if ($this->container['allow_listed'] === null) {
            return false;
        }
        if ($this->container['allow_bundled'] === null) {
            return false;
        }
        if ($this->container['allow_auto_add'] === null) {
            return false;
        }
        if ($this->container['upgrades'] === null) {
            return false;
        }
        if ($this->container['versions'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets license_name
     * @return string
     */
    public function getLicenseName()
    {
        return $this->container['license_name'];
    }

    /**
     * Sets license_name
     * @param string $license_name Name of User License
     * @return $this
     */
    public function setLicenseName($license_name)
    {
        $this->container['license_name'] = $license_name;

        return $this;
    }

    /**
     * Gets license_type
     * @return string
     */
    public function getLicenseType()
    {
        return $this->container['license_type'];
    }

    /**
     * Sets license_type
     * @param string $license_type type of license used in publication license
     * @return $this
     */
    public function setLicenseType($license_type)
    {
        $this->container['license_type'] = $license_type;

        return $this;
    }

    /**
     * Gets license_type_value
     * @return string
     */
    public function getLicenseTypeValue()
    {
        return $this->container['license_type_value'];
    }

    /**
     * Sets license_type_value
     * @param string $license_type_value Actual type of license used in publication license. ex. MIT/BSD, BCL or GPL.
     * @return $this
     */
    public function setLicenseTypeValue($license_type_value)
    {
        $this->container['license_type_value'] = $license_type_value;

        return $this;
    }

    /**
     * Gets price
     * @return float
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     * @param float $price price of license
     * @return $this
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets total_price
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->container['total_price'];
    }

    /**
     * Sets total_price
     * @param float $total_price total price of license
     * @return $this
     */
    public function setTotalPrice($total_price)
    {
        $this->container['total_price'] = $total_price;

        return $this;
    }

    /**
     * Gets allow_listed
     * @return bool
     */
    public function getAllowListed()
    {
        return $this->container['allow_listed'];
    }

    /**
     * Sets allow_listed
     * @param bool $allow_listed to make license listed.
     * @return $this
     */
    public function setAllowListed($allow_listed)
    {
        $this->container['allow_listed'] = $allow_listed;

        return $this;
    }

    /**
     * Gets allow_bundled
     * @return bool
     */
    public function getAllowBundled()
    {
        return $this->container['allow_bundled'];
    }

    /**
     * Sets allow_bundled
     * @param bool $allow_bundled to make license allowed to bundled with other license.
     * @return $this
     */
    public function setAllowBundled($allow_bundled)
    {
        $this->container['allow_bundled'] = $allow_bundled;

        return $this;
    }

    /**
     * Gets allow_auto_add
     * @return bool
     */
    public function getAllowAutoAdd()
    {
        return $this->container['allow_auto_add'];
    }

    /**
     * Sets allow_auto_add
     * @param bool $allow_auto_add to add new snapshot version automatically in license with this settings true.
     * @return $this
     */
    public function setAllowAutoAdd($allow_auto_add)
    {
        $this->container['allow_auto_add'] = $allow_auto_add;

        return $this;
    }

    /**
     * Gets upgrades
     * @return string
     */
    public function getUpgrades()
    {
        return $this->container['upgrades'];
    }

    /**
     * Sets upgrades
     * @param string $upgrades implementing license policy for upgrades.
     * @return $this
     */
    public function setUpgrades($upgrades)
    {
        $this->container['upgrades'] = $upgrades;

        return $this;
    }

    /**
     * Gets versions
     * @return \Swagger\Client\Model\PublicationVersion[]
     */
    public function getVersions()
    {
        return $this->container['versions'];
    }

    /**
     * Sets versions
     * @param \Swagger\Client\Model\PublicationVersion[] $versions version that will be published under this licenses.
     * @return $this
     */
    public function setVersions($versions)
    {
        $this->container['versions'] = $versions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


