<?php
/**
 * @file
 * Contains \Drupal\hostlib\Routing\BlendedRoutes.
 */

namespace Drupal\hostlib\Routing;

use Blended\hostlib\Controller;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;
use Drupal\Core\Access;
use Drupal\rest\Plugin\ResourceBase;
use Drupal\rest\ResourceResponse;

/**
 * Defines dynamic routes.
 * Request Blended API responses.
 */
class BlendedRoutes {

  /**
   * Defined route collections.
   */
  public function routes() {

    /**
     * Blended API namespace.
     * Defined within network.
     *
     * @access global
     * @var    string
     */
    global $NAMESPACE;

    /**
     * user settings.
     *
     * @access global
     * @var    string
     */
    global $blendedConfig;

    $basePath2 = $blendedConfig->get('swagger', 'BASE_PATH_2');
    $basePath1 = $blendedConfig->get('swagger', 'BASE_PATH_1');
    $NAMESPACE = $basePath1 . '/' . $basePath2;

    /**
     * Collect route collections.
     */
    $routes = array();

    /**
     * Login user to account.
     * API : POST /login/
     */
    $routes['hostlib.post_login'] = new Route($NAMESPACE.'/login',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_login'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Reset password of user account.
     * API : POST /reset/
     */
    $routes['hostlib.post_resetPassword'] = new Route($NAMESPACE.'/reset',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_resetPassword'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Get nav default settings for admin
     * API : GET /menus/
     */
    $routes['hostlib.get_get_nav_list'] = new Route($NAMESPACE.'/menus',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_get_nav_list'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get navigation items
     * API : GET /menus/{id}/
     */
    $routes['hostlib.get_get_nav_menu'] = new Route($NAMESPACE.'/menus/{id}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_get_nav_menu'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * push image to hub.
     * API : POST /packages/{slug}/media/
     */
    $routes['hostlib.post_uploadMedia'] = new Route($NAMESPACE.'/packages/{slug}/media',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_uploadMedia'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Get Hub Specific setting for getting and putting updates to user.
     * API : GET /settings/updates/
     */
    $routes['hostlib.get_get_hub_settings'] = new Route($NAMESPACE.'/settings/updates',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_get_hub_settings'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get Hub Specific setting for getting and putting updates to user.
     * API : PUT /settings/updates/
     */
    $routes['hostlib.put_save_hub_settings'] = new Route($NAMESPACE.'/settings/updates',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_save_hub_settings'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

   /**
    * Merge Hub and local stored packages details of logged-in user account.
    * API : GET /packages/
    */
    $routes['hostlib.get_sync_client_account'] = new Route($NAMESPACE.'/packages',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_sync_client_account'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Retrieve current active theme from Host.
     * API : GET /active
     */
    $routes['hostlib.get_active'] = new Route($NAMESPACE.'/active',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_active'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Set as current active theme to Host.
     * API : PUT /active
     */
    $routes['hostlib.put_active'] = new Route($NAMESPACE.'/active',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_active'
      ),

      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

   /**
    * Get package details either from Hub or local filesystem.
    * API : GET /packages/{accountSlug}/{slug}/local/
    */
    $routes['hostlib.get_localPackageGet'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/local',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_localPackageGet'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

   /**
    * Get current user.
    * API : GET /accounts/
    */
    $routes['hostlib.get_localaccountDetails'] = new Route($NAMESPACE.'/accounts',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_localaccountDetails'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Create a new user account.
     * API : POST /accounts/
     */
    $routes['hostlib.post_createAccount'] = new Route($NAMESPACE.'/accounts',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_createAccount'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Detail View of user account.
     * API : PUT /packages/{accountSlug}/{slug}/
     */
    $routes['hostlib.get_getAccountDetails'] = new Route($NAMESPACE.'/accounts/{slug}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getAccountDetails'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Update User Account.
     * API : PUT /accounts/{slug}/
     */
    $routes['hostlib.put_updateAccount'] = new Route($NAMESPACE.'/accounts/{slug}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updateAccount'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get theme setting required to render theme.
     * API : GET /settings/theme/
     */
    $routes['hostlib.get_get_theme_settings'] = new Route($NAMESPACE.'/settings/theme',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_get_theme_settings'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Save theme settings onto current configuration.
     * API : PUT /settings/theme/
     */
    $routes['hostlib.put_save_theme_settings'] = new Route($NAMESPACE.'/settings/theme',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_save_theme_settings'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get navigation specific setting required to render theme.
     * API : GET /settings/navigations/
     */
    $routes['hostlib.get_get_navigation_settings'] = new Route($NAMESPACE.'/settings/navigations',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_get_navigation_settings'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Save navigation settings onto current configuration.
     * API : PUT /settings/navigations/
     */
    $routes['hostlib.put_get_navigation_settings'] = new Route($NAMESPACE.'/settings/navigations',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_get_navigation_settings'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Retrieve all accounts from the system that the user has access to.
     * API : GET /accounts/{slug}/members/
     */
    $routes['hostlib.get_getAccountList'] = new Route($NAMESPACE.'/accounts/{accountSlug}/accounts',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getAccountList'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Set Hub current account from Hub settings on to current stored configuration.
     * API : GET /accounts/{slug}/current
     */
    $routes['hostlib.get_getCurrentAccount'] = new Route($NAMESPACE.'/accounts/{accountSlug}/current',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getCurrentAccount'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Set Hub current account from Hub settings on to current stored configuration.
     * API : PUT /accounts/{slug}/current
     */
    $routes['hostlib.put_setCurrentAccount'] = new Route($NAMESPACE.'/accounts/{accountSlug}/current',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_setCurrentAccount'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Logout user and discard sessionKey.
     * API : POST /logout/
     */
    $routes['hostlib.post_logout'] = new Route($NAMESPACE.'/logout',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_logout'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Get list of user's account pending users.
     * API : GET /packages/{accountSlug}/{slug}/pendings/
     */
    $routes['hostlib.get_getPendingUsers'] = new Route($NAMESPACE.'/accounts/{accountSlug}/pendings',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getPendingUsers'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Invite user to join account.
     * API : POST /packages/{accountSlug}/{slug}/pendings/
     */
    $routes['hostlib.post_inviteUser'] = new Route($NAMESPACE.'/accounts/{accountSlug}/pendings',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_inviteUser'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Delete a pending user from user account.
     * API : DELETE /accounts/{slug}/pendings/{email}/
     */
    $routes['hostlib.delete_removePendingUser'] = new Route($NAMESPACE.'/accounts/{accountSlug}/pendings/{email}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::delete_removePendingUser'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'DELETE'
      )
    );

    /**
     * Get package draft details.
     * API : GET /packages/{accountSlug}/{slug}/draft/
     */
    $routes['hostlib.get_getPackageDetails'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getPackageDetails'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Update Package.
     * API : PUT /packages/{accountSlug}/{slug}/
     */
    $routes['hostlib.put_updatePackage'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updatePackage'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get package draft.
     * API : GET /packages/{accountSlug}/{slug}/draft/
     */
    $routes['hostlib.get_getDraft'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/draft',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getDraft'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Update user draft package.
     * API : PUT /packages/{accountSlug}/{slug}/draft/
     */
    $routes['hostlib.put_updateDraft'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/draft',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updateDraft'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get package object from Hub and save it to locally by calling controller get_package method.
     * API : GET /packages/{accountSlug}/{slug}/draft/documents/
     */
    $routes['hostlib.get_pull_package'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/draft/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_pull_package'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Push package clone to Hub.
     * API : POST /packages/{accountSlug}/{slug}/draft/documents/
     */
    $routes['hostlib.post_createHubPackage'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/draft/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_createHubPackage'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Push package object to Hub.
     * API : PUT /packages/{accountSlug}/{slug}/draft/documents/
     */
    $routes['hostlib.put_push_package'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/draft/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_push_package'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get package object from Hub and save it to locally by calling controller get_package method.
     * API : PUT /packages/{slug}/draft/documents/
     */
    $routes['hostlib.put_pull_package'] = new Route($NAMESPACE.'/packages/{slug}/draft/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_pull_package'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get file jptf package representation.
     * API : GET /packages/{accountSlug}/{slug}/draft/documents/{name}/
     */
    $routes['hostlib.get_getFile'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/draft/documents/{name}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getFile'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         'name' => '.+',
         '_blended_access_check' => 'TRUE'
      ),
      array(
         'name' => '.+'
      ),
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get package JPTF from filesystem or Hub.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/{name}/
     */
    $routes['hostlib.get_localDownload'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/local/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_localDownload'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Create empty package.
     * API : GET /packages/{accountSlug}/{slug}/local/documents/
     */
    $routes['hostlib.post_localCreate'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/local/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_localCreate'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Update local package.
     * API : PUT /packages/{accountSlug}/{slug}/local/documents/
     */
    $routes['hostlib.put_localUpdate'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/local/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_localUpdate'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Delete package from local filesystem.
     * API : DELETE /packages/{accountSlug}/{slug}/local/
     */
    $routes['hostlib.delete_localDelete'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/local',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::delete_localDelete'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'DELETE'
      )
    );

    /**
     * Get file jptf package object.
     * API : GET /packages/{accountSlug}/{slug}/local/documents/{name}/
     */
    $routes['hostlib.get_localDownloadFile'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/local/documents/{name}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_localDownloadFile'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Compare version document.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/
     */
    $routes['hostlib.get_compareWithLocal'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_compareWithLocal'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Clone package on local file system .
     * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/
     */
    $routes['hostlib.post_localClone'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_localClone'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Update local draft.
     * API : PUT /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/
     */
    $routes['hostlib.put_updateFromLocal'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updateFromLocal'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Compare draft document.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/
     */
    $routes['hostlib.get_compareFileWithLocal'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/{name}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_compareFileWithLocal'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Compare draft package.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
     */
    $routes['hostlib.get_compare_draft'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_compare_draft'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Clone draft on local file system .
     * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
     */
    $routes['hostlib.post_draftClone'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_draftClone'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Compare draft document.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
     */
    $routes['hostlib.get_compareFileWithDraft'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/{name}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_compareFileWithDraft'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Retrieve list of package version.
     * API : GET /packages/{accountSlug}/{slug}/versions/
     */
    $routes['hostlib.get_getVersions'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versions',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getVersions'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Create a snapshot of a package.
     * API : GET /packages/{accountSlug}/{slug}/versions/
     */
    $routes['hostlib.post_versionCreateSnapshot'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versions',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_versionCreateSnapshot'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Clone draft on local file system .
     * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
     */
    $routes['hostlib.post_draftClone'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_draftClone'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Update draft.
     * API : PUT /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
     */
    $routes['hostlib.put_updateFromDraft'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updateFromDraft'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get version data of a package in details.
     * API : GET /packages/{accountSlug}/{slug}/versions/
     */
    $routes['hostlib.get_getVersionDetails'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versions/{label}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getVersionDetails'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get version documents of a package.
     * API : GET /packages/{accountSlug}/{slug}/versions/
     */
    $routes['hostlib.get_versionDownload'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versions/{label}/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_versionDownload'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get version documents of a package in details.
     * API : GET /packages/{accountSlug}/{slug}/versions/
     */
    $routes['hostlib.get_versionDownloadFile'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versions/{label}/documents/{name}/',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_versionDownloadFile'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Compare canonical package version.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/
     */
    $routes['hostlib.get_compare_version'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_compare_version'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Clone version of a package on local file system .
     * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/
     */
    $routes['hostlib.post_versionClone'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_versionClone'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Update draft from version document.
     * API : PUT /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/
     */
    $routes['hostlib.put_updateFromVersion'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updateFromVersion'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Retrieve file data in comparison of packages.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/{name}/
     */
    $routes['hostlib.get_compare_labeledversion_file'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/{name}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_compare_labeledversion_file'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Compare canonical package version.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents/
     */
    $routes['hostlib.get_compare_canonical'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_compare_canonical'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Clone version of a package on local file system .
     * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents/
     */
    $routes['hostlib.post_canonicalClone'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_canonicalClone'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Update draft from version document.
     * API : PUT /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents/
     */
    $routes['hostlib.put_updateFromCanonical'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updateFromCanonical'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Compare Canonical version of a document.
     * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/cannonical/documents/{document}/
     */
    $routes['hostlib.get_compareFileWithCanonical'] = new Route($NAMESPACE.'/packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents/{name}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_compareFileWithCanonical'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get detail view of canonical version of a package.
     * API : GET /packages/{accountSlug}/{slug}/canonical/
     */
    $routes['hostlib.get_canonicalDetails'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/canonical',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_canonicalDetails'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Update package version as canonical version.
     * API : PUT /packages/{accountSlug}/{slug}/canonical/
     */
    $routes['hostlib.put_canonicalSet'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/canonical',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_canonicalSet'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get canonical version of a package and store it in local filesystem.
     * API : GET /packages/{accountSlug}/{slug}/canonical/documents/
     */
    $routes['hostlib.get_canonicalDownload'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/canonical/documents',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_canonicalDownload'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get acquire package list
     * API : GET /packages/{accountSlug}/{slug}/acquisitions/
     */
    $routes['hostlib.get_getAcquiredPackageAccountList'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/acquisitions',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getAcquiredPackageAccountList'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * API to acquire package between accounts.
     * API : POST /packages/{accountSlug}/{slug}/acquisitions/
     */
    $routes['hostlib.post_acquirePackage'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/acquisitions',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_acquirePackage'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * API to accept acquisitions.
     * API : PUT /packages/{accountSlug}/{slug}/acquisitions/
     */
    $routes['hostlib.put_acceptAcquisition'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/acquisitions',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_acceptAcquisition'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * API to delete acquisitions.
     * API : DELETE /packages/{accountSlug}/{slug}/acquisitions/
     */
    $routes['hostlib.delete_revokeAcquiredPackage'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/acquisitions',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::delete_revokeAcquiredPackage'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'DELETE'
      )
    );

    /**
     * API to resend account verification.
     * API : PUT /accounts/resend/emailverification/
     */
    $routes['hostlib.put_resendAccountVerificationEmail'] = new Route($NAMESPACE.'/accounts/resend/emailverification',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_resendAccountVerificationEmail'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * API to search for account.
     * API : GET /accounts/search/{accountSlug}/
     */
    $routes['hostlib.get_searchAccounts'] = new Route($NAMESPACE.'/accounts/search/{accountSlug}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_searchAccounts'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Resend the inivite of shared package.
     * API : POST packages/{accountSlug}/{slug}/resend/invite/
     */
    $routes['hostlib.post_resendInvite'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/resend/invite',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_resendInvite'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Add a admin user into account.
     * API : POST /accounts/{slug}/admins/
     */
    $routes['hostlib.post_addAccountAdmin'] = new Route($NAMESPACE.'/accounts/{accountSlug}/admins',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_addAccountAdmin'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Create package draft.
     * API : POST /packages/{accountSlug}/
     */
    $routes['hostlib.post_createPackage'] = new Route($NAMESPACE.'/packages/{accountSlug}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_createPackage'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * Update local package.
     * API : PUT /packages/{accountSlug}/{slug}/local/local/documents/merge/
     */
    $routes['hostlib.put_mergePackage'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/local/documents/merge',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_mergePackage'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get package dependencies.
     * API : GET /packages/{accountSlug}/{slug}/dependencies/
     */
    $routes['hostlib.get_getDependencies'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/dependencies',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getDependencies'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get Details of package rating submitted by any user.
     * API : GET /packages/{accountSlug}/{slug}/ratings/{ratingpk}/
     */
    $routes['hostlib.get_getRatingDetails'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/ratings/{ratingPk}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getRatingDetails'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Update rating of package.
     * API : PUT /packages/{accountSlug}/{slug}/ratings/{ratingpk}/
     */
    $routes['hostlib.put_updateRating'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/ratings/{ratingPk}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updateRating'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get list of licenses associated with package.
     * API : GET /packages/{accountSlug}/{slug}/versions/{label}/licenses/
     */
    $routes['hostlib.get_getLicenses'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versions/{label}/licenses',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_getLicenses'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Update price of package license.
     * API : PUT /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/
     */
    $routes['hostlib.put_updateLicense'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_updateLicense'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * delete a package license.
     * API : DELETE /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/
     */
    $routes['hostlib.delete_removeLicense'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::delete_removeLicense'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'DELETE'
      )
    );

    /**
     * Get current package hash of local package.
     * API : GET /packages/{accountSlug}/{slug}/currenthash/
     */
    $routes['hostlib.get_currenthash'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/currenthash',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_currenthash'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Blended app url's.
     * API : GET /host/endpoints/{endPointName}/
     */
    $routes['hostlib.blendedAppUrl'] = new Route($NAMESPACE.'/host/endpoints/{endPointName}',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::blendedAppUrl'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

/********************************************************************************
 ********************* Publication endpoints *************************************
 ********************************************************************************/

    /**
     * Get package publication.
     * API : GET /packages/{accountSlug}/{slug}/publications/
     */
    $routes['hostlib.get_publication'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/publications',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_publication'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get package version bundles.
     * API : GET /packages/{accountSlug}/{slug}/versionbundles/
     */
    $routes['hostlib.get_versionBundles'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/versionbundles',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::get_versionBundles'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'GET'
      )
    );

    /**
     * Get package version bundles.
     * API : GET /packages/{accountSlug}/{slug}/publications/
     */
    $routes['hostlib.put_publications'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/publications',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_publications'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    /**
     * Get package version bundles.
     * API : GET /packages/{accountSlug}/{slug}/publicationvalidations/
     */
    $routes['hostlib.post_validatePublication'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/publicationvalidations',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::post_validatePublication'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'POST'
      )
    );

    /**
     * API to reject shared package.
     * API : PUT /packages/{accountSlug}/{slug}/reject/
     */
    $routes['put_rejectAcquisitionInvite'] = new Route($NAMESPACE.'/packages/{accountSlug}/{slug}/reject',
      // Route defaults:
      array(
        '_controller' => '\Drupal\hostlib\Controller\BlendedAPI::put_rejectAcquisitionInvite'
      ),
      // Route requirements:
      array(
         '_access' => 'TRUE',
         '_blended_access_check' => 'TRUE'
      ),
      array(), 
      '', 
      array(),
      array(
         '_method' => 'PUT'
      )
    );

    return $routes;
  }
}
