<?php
/**
 * FailedDependencyError
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * FailedDependencyError Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FailedDependencyError implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FailedDependencyError';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'package' => 'string',
        'third_party' => 'bool',
        'get_or_purchased' => 'bool',
        'to_do' => 'string',
        'dependency_of_package' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'package' => 'package',
        'third_party' => 'third_party',
        'get_or_purchased' => 'get_or_purchased',
        'to_do' => 'to_do',
        'dependency_of_package' => 'dependency_of_package'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'package' => 'setPackage',
        'third_party' => 'setThirdParty',
        'get_or_purchased' => 'setGetOrPurchased',
        'to_do' => 'setToDo',
        'dependency_of_package' => 'setDependencyOfPackage'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'package' => 'getPackage',
        'third_party' => 'getThirdParty',
        'get_or_purchased' => 'getGetOrPurchased',
        'to_do' => 'getToDo',
        'dependency_of_package' => 'getDependencyOfPackage'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['package'] = isset($data['package']) ? $data['package'] : null;
        $this->container['third_party'] = isset($data['third_party']) ? $data['third_party'] : null;
        $this->container['get_or_purchased'] = isset($data['get_or_purchased']) ? $data['get_or_purchased'] : null;
        $this->container['to_do'] = isset($data['to_do']) ? $data['to_do'] : null;
        $this->container['dependency_of_package'] = isset($data['dependency_of_package']) ? $data['dependency_of_package'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets package
     * @return string
     */
    public function getPackage()
    {
        return $this->container['package'];
    }

    /**
     * Sets package
     * @param string $package fully qualified package name
     * @return $this
     */
    public function setPackage($package)
    {
        $this->container['package'] = $package;

        return $this;
    }

    /**
     * Gets third_party
     * @return bool
     */
    public function getThirdParty()
    {
        return $this->container['third_party'];
    }

    /**
     * Sets third_party
     * @param bool $third_party boolean field to identify third party package.
     * @return $this
     */
    public function setThirdParty($third_party)
    {
        $this->container['third_party'] = $third_party;

        return $this;
    }

    /**
     * Gets get_or_purchased
     * @return bool
     */
    public function getGetOrPurchased()
    {
        return $this->container['get_or_purchased'];
    }

    /**
     * Sets get_or_purchased
     * @param bool $get_or_purchased boolean field to identify purchased packages.
     * @return $this
     */
    public function setGetOrPurchased($get_or_purchased)
    {
        $this->container['get_or_purchased'] = $get_or_purchased;

        return $this;
    }

    /**
     * Gets to_do
     * @return string
     */
    public function getToDo()
    {
        return $this->container['to_do'];
    }

    /**
     * Sets to_do
     * @param string $to_do message for end user.
     * @return $this
     */
    public function setToDo($to_do)
    {
        $this->container['to_do'] = $to_do;

        return $this;
    }

    /**
     * Gets dependency_of_package
     * @return string
     */
    public function getDependencyOfPackage()
    {
        return $this->container['dependency_of_package'];
    }

    /**
     * Sets dependency_of_package
     * @param string $dependency_of_package package for which the package is dependency of.
     * @return $this
     */
    public function setDependencyOfPackage($dependency_of_package)
    {
        $this->container['dependency_of_package'] = $dependency_of_package;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


