<?php
/**
 * UpdateAccount
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * UpdateAccount Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UpdateAccount implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'updateAccount';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'old_password' => 'string',
        'new_password' => 'string',
        'email' => 'string',
        'password' => 'string',
        'reset_token' => 'string',
        'activation_token' => 'string',
        'activation_solution' => 'string',
        'deactivate' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'old_password' => 'old_password',
        'new_password' => 'new_password',
        'email' => 'email',
        'password' => 'password',
        'reset_token' => 'reset_token',
        'activation_token' => 'activation_token',
        'activation_solution' => 'activation_solution',
        'deactivate' => 'deactivate'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'old_password' => 'setOldPassword',
        'new_password' => 'setNewPassword',
        'email' => 'setEmail',
        'password' => 'setPassword',
        'reset_token' => 'setResetToken',
        'activation_token' => 'setActivationToken',
        'activation_solution' => 'setActivationSolution',
        'deactivate' => 'setDeactivate'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'old_password' => 'getOldPassword',
        'new_password' => 'getNewPassword',
        'email' => 'getEmail',
        'password' => 'getPassword',
        'reset_token' => 'getResetToken',
        'activation_token' => 'getActivationToken',
        'activation_solution' => 'getActivationSolution',
        'deactivate' => 'getDeactivate'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['old_password'] = isset($data['old_password']) ? $data['old_password'] : null;
        $this->container['new_password'] = isset($data['new_password']) ? $data['new_password'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['password'] = isset($data['password']) ? $data['password'] : null;
        $this->container['reset_token'] = isset($data['reset_token']) ? $data['reset_token'] : null;
        $this->container['activation_token'] = isset($data['activation_token']) ? $data['activation_token'] : null;
        $this->container['activation_solution'] = isset($data['activation_solution']) ? $data['activation_solution'] : null;
        $this->container['deactivate'] = isset($data['deactivate']) ? $data['deactivate'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets old_password
     * @return string
     */
    public function getOldPassword()
    {
        return $this->container['old_password'];
    }

    /**
     * Sets old_password
     * @param string $old_password user current password for change password.
     * @return $this
     */
    public function setOldPassword($old_password)
    {
        $this->container['old_password'] = $old_password;

        return $this;
    }

    /**
     * Gets new_password
     * @return string
     */
    public function getNewPassword()
    {
        return $this->container['new_password'];
    }

    /**
     * Sets new_password
     * @param string $new_password user account new password for change password.
     * @return $this
     */
    public function setNewPassword($new_password)
    {
        $this->container['new_password'] = $new_password;

        return $this;
    }

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     * @param string $email user Email ID.
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets password
     * @return string
     */
    public function getPassword()
    {
        return $this->container['password'];
    }

    /**
     * Sets password
     * @param string $password new password of user for reset password.
     * @return $this
     */
    public function setPassword($password)
    {
        $this->container['password'] = $password;

        return $this;
    }

    /**
     * Gets reset_token
     * @return string
     */
    public function getResetToken()
    {
        return $this->container['reset_token'];
    }

    /**
     * Sets reset_token
     * @param string $reset_token token used to reset user password.
     * @return $this
     */
    public function setResetToken($reset_token)
    {
        $this->container['reset_token'] = $reset_token;

        return $this;
    }

    /**
     * Gets activation_token
     * @return string
     */
    public function getActivationToken()
    {
        return $this->container['activation_token'];
    }

    /**
     * Sets activation_token
     * @param string $activation_token token used to activate user account.
     * @return $this
     */
    public function setActivationToken($activation_token)
    {
        $this->container['activation_token'] = $activation_token;

        return $this;
    }

    /**
     * Gets activation_solution
     * @return string
     */
    public function getActivationSolution()
    {
        return $this->container['activation_solution'];
    }

    /**
     * Sets activation_solution
     * @param string $activation_solution activation proof of work solution
     * @return $this
     */
    public function setActivationSolution($activation_solution)
    {
        $this->container['activation_solution'] = $activation_solution;

        return $this;
    }

    /**
     * Gets deactivate
     * @return bool
     */
    public function getDeactivate()
    {
        return $this->container['deactivate'];
    }

    /**
     * Sets deactivate
     * @param bool $deactivate boolean value to deactivate user account.
     * @return $this
     */
    public function setDeactivate($deactivate)
    {
        $this->container['deactivate'] = $deactivate;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


