<?php

/**
 * Blended Admin Scripts/Styles
 *
 * @class    Blended_Admin_Scripts
 * @author   Blended
 * @category Admin
 * @package  blended_fw/inc/admin
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Blended_Admin_Menus class.
 */
class Blended_Admin_Scripts {

    /**
     * Scripts Hooks.
     */
    public function __construct() {
        add_action('admin_enqueue_scripts', array($this, 'admin_styles'));
        add_action('admin_enqueue_scripts', array($this, 'admin_scripts'));
        add_action('admin_print_scripts', array($this, 'header_scripts'));
        add_action('admin_footer', array($this, 'footer_scripts'));
    }

    /**
     * Admin styles
     */
    public function admin_styles() {

        $screen = get_current_screen();
        $screen_id = $screen ? $screen->id : '';
        $blended_screen_id = "blended-designs";

        //Signup/Login
        wp_register_style('react_onboard_popup_normalize', REACT_URI . '/App/Onboard-popup/css/normalize.css', array(), null);
        wp_register_style('react_font_awesome', REACT_CDN . '/font-awesome/4.7.0/css/font-awesome.min.css', array(), null);
        wp_register_style('react_onboard_popup_style', REACT_URI . '/App/Onboard-popup/css/style.css', array(), null);

        if (bd_show_signup_popup() && ('dashboard' === $screen_id || 'themes' === $screen_id)):
            wp_enqueue_style('react_onboard_popup_normalize');
            wp_enqueue_style('react_font_awesome');
            wp_enqueue_style('react_onboard_popup_style');
        endif;


        //Library
        wp_register_style('react_library_normalize', REACT_URI . '/App/Library/css/normalize.css', array(), null);
        wp_register_style('react_Library_grid', REACT_URI . '/App/Library/css/grid.css', array(), null);
        wp_register_style('react_Library_style', REACT_URI . '/App/Library/css/style.css', array(), null);
        if ("toplevel_page_Library" === $screen_id):
            wp_enqueue_style('react_library_normalize');
            wp_enqueue_style('react_font_awesome');
            wp_enqueue_style('react_Library_grid');
            wp_enqueue_style('react_Library_style');
        endif;



        //Settings
        wp_register_style('react_settings_normalize', REACT_URI . '/App/Settings/css/normalize.css', array(), null);
        wp_register_style('react_settings_grid', REACT_URI . '/App/Settings/css/grid.css', array(), null);
        wp_register_style('react_settings_msgpop', REACT_URI . '/App/Settings/css/msgPop.css', array(), null);
        wp_register_style('react_settings_style', REACT_URI . '/App/Settings/css/style.css', array(), null);
        wp_register_style('react_settings_slider', REACT_URI . '/App/Settings/css/slider.css', array(), null);
        if ($blended_screen_id . '_page_Setting' === $screen_id):
            wp_enqueue_style('react_settings_normalize');
            wp_enqueue_style('react_font_awesome');
            wp_enqueue_style('react_settings_grid');
            wp_enqueue_style('react_settings_msgpop');
            wp_enqueue_style('react_settings_style');
            wp_enqueue_style('react_settings_slider');
        endif;


        //Onboard
        wp_register_style('react_onboard_app_normalize', REACT_URI . '/App/Onboard-app/css/normalize.css', array(), null);
        wp_register_style('react_onboard_app_style', REACT_URI . '/App/Onboard-app/css/style.css', array(), null);
        if ("admin_page_Onboard" === $screen_id):
            wp_enqueue_style('react_onboard_app_normalize');
            wp_enqueue_style('react_font_awesome');
            wp_enqueue_style('react_onboard_app_style');
        endif;


        //Source code
        wp_register_style('react_source_code_normalize', REACT_URI . '/App/SourceCode/css/normalize.css', array(), null);
        wp_register_style('react_source_code_style', REACT_URI . '/App/SourceCode/css/style.css', array(), null);
        wp_register_style('react_source_code_grid', REACT_URI . '/App/SourceCode/css/grid.css', array(), null);
        if ('admin_page_Source Code' === $screen_id):
            wp_enqueue_style('react_source_code_normalize');
            wp_enqueue_style('react_font_awesome');
            wp_enqueue_style('react_source_code_style');
            wp_enqueue_style('react_source_code_grid');
        endif;
    }

    /**
     * Admin enqueue scripts
     */
    public function admin_scripts() {

        $screen = get_current_screen();
        $screen_id = $screen ? $screen->id : '';
        $blended_screen_id = "blended-designs";


        //Signup/Login
        if (bd_show_signup_popup() && ('dashboard' === $screen_id || 'themes' === $screen_id)):
            print '<div class="blendedux-page onboarding-page" id="blendedux"></div>';
            wp_enqueue_script('react_jquery', REACT_URI . '/App/Onboard-popup/lib/jquery-1.11.2.min.js', array(), null);
            wp_enqueue_script('react_bundle', REACT_URI . '/App/Onboard-popup/bundle.js', array(), null);
        endif;

        //Library
        if ("toplevel_page_Library" === $screen_id):
            wp_enqueue_script('react_jquery', REACT_URI . '/App/Library/lib/jquery-1.11.2.min.js', array(), null);
            wp_enqueue_script('react_jquery_ui', REACT_URI . '/App/Library/lib/jquery-ui-1.7.2.js', array(), null);
            wp_enqueue_script('react_bundle', REACT_URI . '/App/Library/bundle.js', array(), null);
            wp_enqueue_script('object_assign', REACT_URI . '/App/Library/lib/object_assign.js', array(), null);
        endif;


        //Settings
        if ($blended_screen_id . '_page_Setting' === $screen_id):
            wp_enqueue_script('react_jquery', REACT_URI . '/App/Settings/js/jquery-1.11.2.min.js', array(), null);
            wp_enqueue_script('react_bundle', REACT_URI . '/App/Settings/bundle.js', array(), null);
            wp_enqueue_script('react_msgpop', REACT_URI . '/App/Settings/js/msgPop.js', array(), null);
            wp_enqueue_script('object_assign', REACT_URI . '/App/Settings/js/object_assign.js', array(), null);
        endif;


        //Onboard
        if ("admin_page_Onboard" === $screen_id):
            wp_enqueue_script('react_jquery', REACT_URI . '/App/Onboard-app/lib/jquery-1.11.2.min.js', array(), null);
            wp_enqueue_script('react_bundle', REACT_URI . '/App/Onboard-app/bundle.js', array(), null);
        endif;

        //Source code
        if ("admin_page_Source Code" === $screen_id):
            wp_enqueue_script('react_jquery', REACT_URI . '/App/SourceCode/js/jquery-1.11.2.min.js', array(), null);
            wp_enqueue_script('react_jquery', REACT_URI . '/App/SourceCode/js/custom-select.js', array(), null);
            wp_enqueue_script('react_jquery', REACT_URI . '/App/SourceCode/js/source-code.js', array(), null);
            wp_enqueue_script('react_jquery', REACT_JQUERY . '/ajax/libs/jquery/1.12.2/jquery.min.js', array(), null);
            wp_enqueue_script('react_bundle', REACT_URI . '/App/SourceCode/bundle.js', array(), null);
            wp_enqueue_script('object_assign', REACT_URI . '/App/SourceCode/js/object_assign.js', array(), null);
        endif;
    }

    /**
     * Admin footer scripts
     */
    public function footer_scripts() {
        if (!$screen = get_current_screen()) {
            return;
        }

        $blended_screens = blended_screen_ids();

        //Add dashboard screen to blended screen
        if (bd_show_signup_popup())
            $blended_screens = array_unique(array_merge($blended_screens, array('dashboard', 'themes')));

        // Only on Blended admin page.
        if (isset($screen->id) && in_array($screen->id, $blended_screens)):
            echo "<script>\n";
            echo "(function($){\n";
            echo "$(document).ready(function () { ";
            echo 'var blended  =  new BlendedAdmin ({
            "css" : {
                "marginTop": "32px"
            },
            "staticFile" :  "'.REACT_URI.'/App/",
            "hostUrl" : "' . site_url() . '/blended/v0"
                });';
            echo 'var divRef =  document.getElementById ("blendedux");';
            echo 'blended.start (divRef)';
            echo "});";
            echo "})(jQuery);";
            echo "\n</script>\n";
        endif;
    }

    public function header_scripts() {
        echo "<script>\n";
        echo 'var sessionKey = "' . $_COOKIE[LOGGED_IN_COOKIE] . '";';
        echo 'localStorage.setItem ("sessionKey" , sessionKey)';
        echo "\n</script>";
    }

}

return new Blended_Admin_Scripts();
