<?php

/**
 * Blended Admin
 *
 * @class    Blended_Admin
 * @author   Blended
 * @category Admin
 * @package  Blended/Admin
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Blended_Admin class.
 */
class Blended_Admin {

    /**
     * Constructor.
     */
    public function __construct() {
        add_action('init', array($this, 'includes'));
        add_action('init', array($this, 'permalink_structure'));
        add_action('current_screen', array($this, 'conditional_includes'));
        add_action('admin_head', array($this, 'admin_head'));
    }

    /**
     * Include admin instances.
     */
    public function includes() {
        include_once( dirname(__FILE__) . '/blended-admin-functions.php' );
        include_once( dirname(__FILE__) . '/class-bd-admin-menus.php' );
        include_once( dirname(__FILE__) . '/class-admin-meta-boxes.php' );
        include_once( dirname(__FILE__) . '/class-admin-post-types.php' );
        include_once( dirname(__FILE__) . '/class-bd-admin-scripts.php' );
    }

    /**
     * Include admin files conditionally.
     */
    public function conditional_includes() {
        if (!$screen = get_current_screen()) {
            return;
        }

        switch ($screen->id) {
            case 'dashboard' :
                break;
            case 'options-permalink' :
                break;
            case 'users' :
            case 'user' :
            case 'profile' :
            case 'user-edit' :
                break;
        }
    }

    /**
     * Handle permalink structure for Blended
     * @global type $wp_rewrite
     * @todo Add this method into specific API Classes
     */
    final public function permalink_structure() {

        global $wp_rewrite;
        $permalink_structure = get_option('permalink_structure');

        /**
         * Set permalink structure to postname
         * if default is set, to support Rest API         * 
         */
        if (!$permalink_structure):
            $wp_rewrite->set_permalink_structure('/%postname%/');
        endif;
        
        //Flush Now
        $wp_rewrite->flush_rules(true);
    }
    
    
    /**
     * Add meta tags to head 
     */
    public function admin_head() {
        if (!$screen = get_current_screen()) {
            return;
        }
        
        $blended_screens = blended_screen_ids();

        //Add dashboard screen to blended screen
        if (bd_show_signup_popup())
            $blended_screens = array_unique(array_merge($blended_screens, array('dashboard', 'themes')));

        // Only on Blended admin page.
        if (isset($screen->id) && in_array($screen->id, $blended_screens)):
             echo "<meta charset='utf-8'>\n";
             echo "<meta name='viewport' content='width=device-width, initial-scale=1'>\n";
        endif;
        
        
    }

}

new Blended_Admin();
