<?php

/**
 * WooCommerce Helper Functions
 *
 * @author   Blended
 * @category Core
 * @package  Blended/WooCommerce/Functions
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


/**
 * Set WooCommerce product in loop context
 * @global object $product
 * @global object $post
 * @param object $this_post
 */
function timber_set_product($this_post) {
    global $product;
    global $post;
    if (is_woocommerce()) {
        $product = wc_get_product($this_post->ID);
        $post = get_post($this_post->ID);
    }
}
