<?php
/**
 * RejectAcquisitionPackage
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * RejectAcquisitionPackage Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RejectAcquisitionPackage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RejectAcquisitionPackage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'action' => 'string',
        'unknown_person' => 'bool',
        'not_intended_for_me' => 'bool',
        'do_not_want_it' => 'bool',
        'derogatory_language' => 'bool',
        'sexual_explicit' => 'bool',
        'harassment' => 'bool',
        'hateful_content' => 'bool',
        'child_abuse' => 'bool',
        'unwanted_commercial_or_spam' => 'bool',
        'other' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'action' => 'action',
        'unknown_person' => 'unknown_person',
        'not_intended_for_me' => 'not_intended_for_me',
        'do_not_want_it' => 'do_not_want_it',
        'derogatory_language' => 'derogatory_language',
        'sexual_explicit' => 'sexual_explicit',
        'harassment' => 'harassment',
        'hateful_content' => 'hateful_content',
        'child_abuse' => 'child_abuse',
        'unwanted_commercial_or_spam' => 'unwanted_commercial_or_spam',
        'other' => 'other'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'action' => 'setAction',
        'unknown_person' => 'setUnknownPerson',
        'not_intended_for_me' => 'setNotIntendedForMe',
        'do_not_want_it' => 'setDoNotWantIt',
        'derogatory_language' => 'setDerogatoryLanguage',
        'sexual_explicit' => 'setSexualExplicit',
        'harassment' => 'setHarassment',
        'hateful_content' => 'setHatefulContent',
        'child_abuse' => 'setChildAbuse',
        'unwanted_commercial_or_spam' => 'setUnwantedCommercialOrSpam',
        'other' => 'setOther'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'action' => 'getAction',
        'unknown_person' => 'getUnknownPerson',
        'not_intended_for_me' => 'getNotIntendedForMe',
        'do_not_want_it' => 'getDoNotWantIt',
        'derogatory_language' => 'getDerogatoryLanguage',
        'sexual_explicit' => 'getSexualExplicit',
        'harassment' => 'getHarassment',
        'hateful_content' => 'getHatefulContent',
        'child_abuse' => 'getChildAbuse',
        'unwanted_commercial_or_spam' => 'getUnwantedCommercialOrSpam',
        'other' => 'getOther'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['action'] = isset($data['action']) ? $data['action'] : null;
        $this->container['unknown_person'] = isset($data['unknown_person']) ? $data['unknown_person'] : null;
        $this->container['not_intended_for_me'] = isset($data['not_intended_for_me']) ? $data['not_intended_for_me'] : null;
        $this->container['do_not_want_it'] = isset($data['do_not_want_it']) ? $data['do_not_want_it'] : null;
        $this->container['derogatory_language'] = isset($data['derogatory_language']) ? $data['derogatory_language'] : null;
        $this->container['sexual_explicit'] = isset($data['sexual_explicit']) ? $data['sexual_explicit'] : null;
        $this->container['harassment'] = isset($data['harassment']) ? $data['harassment'] : null;
        $this->container['hateful_content'] = isset($data['hateful_content']) ? $data['hateful_content'] : null;
        $this->container['child_abuse'] = isset($data['child_abuse']) ? $data['child_abuse'] : null;
        $this->container['unwanted_commercial_or_spam'] = isset($data['unwanted_commercial_or_spam']) ? $data['unwanted_commercial_or_spam'] : null;
        $this->container['other'] = isset($data['other']) ? $data['other'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets action
     * @return string
     */
    public function getAction()
    {
        return $this->container['action'];
    }

    /**
     * Sets action
     * @param string $action Type of acquisition user is going to reject.Example : share, get,buy,transfer,extend and clone.
     * @return $this
     */
    public function setAction($action)
    {
        $this->container['action'] = $action;

        return $this;
    }

    /**
     * Gets unknown_person
     * @return bool
     */
    public function getUnknownPerson()
    {
        return $this->container['unknown_person'];
    }

    /**
     * Sets unknown_person
     * @param bool $unknown_person When reason to reject is 'I do not know the person who shared this with me'.
     * @return $this
     */
    public function setUnknownPerson($unknown_person)
    {
        $this->container['unknown_person'] = $unknown_person;

        return $this;
    }

    /**
     * Gets not_intended_for_me
     * @return bool
     */
    public function getNotIntendedForMe()
    {
        return $this->container['not_intended_for_me'];
    }

    /**
     * Sets not_intended_for_me
     * @param bool $not_intended_for_me when the reason to reject is 'It was not intended for me'.
     * @return $this
     */
    public function setNotIntendedForMe($not_intended_for_me)
    {
        $this->container['not_intended_for_me'] = $not_intended_for_me;

        return $this;
    }

    /**
     * Gets do_not_want_it
     * @return bool
     */
    public function getDoNotWantIt()
    {
        return $this->container['do_not_want_it'];
    }

    /**
     * Sets do_not_want_it
     * @param bool $do_not_want_it when the reason to reject is 'I do not want it; it is clogging up my list'.
     * @return $this
     */
    public function setDoNotWantIt($do_not_want_it)
    {
        $this->container['do_not_want_it'] = $do_not_want_it;

        return $this;
    }

    /**
     * Gets derogatory_language
     * @return bool
     */
    public function getDerogatoryLanguage()
    {
        return $this->container['derogatory_language'];
    }

    /**
     * Sets derogatory_language
     * @param bool $derogatory_language when the reason to reject is 'Derogatory Language'.
     * @return $this
     */
    public function setDerogatoryLanguage($derogatory_language)
    {
        $this->container['derogatory_language'] = $derogatory_language;

        return $this;
    }

    /**
     * Gets sexual_explicit
     * @return bool
     */
    public function getSexualExplicit()
    {
        return $this->container['sexual_explicit'];
    }

    /**
     * Sets sexual_explicit
     * @param bool $sexual_explicit when the reason to reject is 'Sexual explicit or pornographic content'.
     * @return $this
     */
    public function setSexualExplicit($sexual_explicit)
    {
        $this->container['sexual_explicit'] = $sexual_explicit;

        return $this;
    }

    /**
     * Gets harassment
     * @return bool
     */
    public function getHarassment()
    {
        return $this->container['harassment'];
    }

    /**
     * Sets harassment
     * @param bool $harassment when the reason to reject is 'Harassment or bullying'.
     * @return $this
     */
    public function setHarassment($harassment)
    {
        $this->container['harassment'] = $harassment;

        return $this;
    }

    /**
     * Gets hateful_content
     * @return bool
     */
    public function getHatefulContent()
    {
        return $this->container['hateful_content'];
    }

    /**
     * Sets hateful_content
     * @param bool $hateful_content when the reason to reject is 'Hateful or violent content'.
     * @return $this
     */
    public function setHatefulContent($hateful_content)
    {
        $this->container['hateful_content'] = $hateful_content;

        return $this;
    }

    /**
     * Gets child_abuse
     * @return bool
     */
    public function getChildAbuse()
    {
        return $this->container['child_abuse'];
    }

    /**
     * Sets child_abuse
     * @param bool $child_abuse when the reason to reject is 'Child Abuse'.
     * @return $this
     */
    public function setChildAbuse($child_abuse)
    {
        $this->container['child_abuse'] = $child_abuse;

        return $this;
    }

    /**
     * Gets unwanted_commercial_or_spam
     * @return bool
     */
    public function getUnwantedCommercialOrSpam()
    {
        return $this->container['unwanted_commercial_or_spam'];
    }

    /**
     * Sets unwanted_commercial_or_spam
     * @param bool $unwanted_commercial_or_spam when the reason to reject is 'Unwanted Commercial content or spam'.
     * @return $this
     */
    public function setUnwantedCommercialOrSpam($unwanted_commercial_or_spam)
    {
        $this->container['unwanted_commercial_or_spam'] = $unwanted_commercial_or_spam;

        return $this;
    }

    /**
     * Gets other
     * @return string
     */
    public function getOther()
    {
        return $this->container['other'];
    }

    /**
     * Sets other
     * @param string $other When user is rejecting package with his/her own reason he/she will mention that message in other field.
     * @return $this
     */
    public function setOther($other)
    {
        $this->container['other'] = $other;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


