<?php

use Blended\hostlib\Backend;

/**
 * Blended Admin Functions
 *
 * @author   Blended
 * @category Admin
 * @package  Blended/Admin
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Blended screen ids.
 *
 * @return array
 */
function blended_screen_ids() {

    $blended_screen_id = "blended-designs";
    $screen_ids = array(
        'toplevel_page_Library',
        $blended_screen_id . '_page_Setting',
        'admin_page_Source Code',
        'admin_page_Onboard'

            /**
             * @todo Need to add more screen ids
             */
    );

    return apply_filters('blended_screen_ids', $screen_ids);
}

/**
 * Check whether to show the signup/login popup modal
 * @global type $THEME_SETTINGS
 * @return type boolean
 */
function bd_show_signup_popup() {
    global $THEME_SETTINGS;
    $blended_session = BD()->backend()->get_session_key(get_current_user_id());

    $display_popup = $THEME_SETTINGS->get('hub_settings', 'updates');
    $display_popup = json_decode($display_popup, true);

    if (!empty($blended_session)) {
        $display_popup = false;
    } else if (isset($display_popup['signInpopup'])) {
        $display_popup = $display_popup['signInpopup'];
    } else {
        $display_popup = true;
    }

    return apply_filters("blended_signup_popup", $display_popup);
}
