<?php

/**
 * Blended Admin Menus
 *
 * @class    Blended_Admin_Menus
 * @author   Blended
 * @category Admin
 * @package  blended_fw/inc/admin
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Blended_Admin_Menus class.
 */
class Blended_Admin_Menus {

    /**
     * Menu Hooks.
     */
    public function __construct() {
        add_action('admin_menu', array($this, 'admin_menu'));
        add_action('admin_menu', array($this, 'layouts_menu'));
        add_action('admin_menu', array($this, 'code_snippet_menu'));
        add_action('admin_menu', array($this, 'pending_transfer_menu'));
        add_action('admin_menu', array($this, 'library_packages_menu'));
        add_action('admin_menu', array($this, 'settings_menu'));

        /**
         * Disable these menu for now         
        add_action('admin_menu', array($this, 'layouts_menu'));
        add_action('admin_menu', array($this, 'code_snippet_menu'));
        add_action('admin_menu', array($this, 'shared_packages_menu'));
        add_action('admin_menu', array($this, 'pending_transfer_menu'));
        add_action('admin_menu', array($this, 'my_purchases_menu'));
        add_action('admin_menu', array($this, 'archived_packages_menu'));
         * 
         */
        add_action('admin_menu', array($this, 'onboard_menu'));
        add_action('admin_menu', array($this, 'source_code_menu'));
        add_action('admin_head', array($this, 'menu_order'));
    }

    /**
     * Blended Design Main menu
     */
    public function admin_menu() {
        if (current_user_can('manage_options')):
            add_menu_page(__('Blended Designs', 'blended'), __('Blended Designs', 'blended'), 'manage_options', 'Library', array($this, 'library_page'), 'dashicons-welcome-view-site', 2);
        endif;
    }


    /**
     * Blended layouts menu
     */
    public function layouts_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page('Library', __('Blended Layouts', 'blended'), __('Layouts', 'blended'), 'manage_options', 'Library&lib=Layouts', array($this, 'layouts_page'));
        endif;
    }

    /**
     * Blended code snippet menu
     */
    public function code_snippet_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page('Library', __('Blended Code Snippets', 'blended'), __('Code Snippets', 'blended'), 'manage_options', 'Library&lib=Code Snippets', array($this, 'code_snippet_page'));
        endif;
    }

    /**
     * Blended pending transfer menu
     */
    public function pending_transfer_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page('Library', __('Blended Pending Transfer', 'blended'), __('Pending Transfers', 'blended'), 'manage_options', 'Library&lib=Pending Transfers', array($this, 'pending_transfer_page'));
        endif;
    }

    /**
     * Blended Libary packages menu
     */
    public function library_packages_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page('Library', __('Blended Library Packages', 'blended'), __('Library Packages', 'blended'), 'manage_options', 'Library&lib=Library Packages', array($this, 'archived_packages_page'));
        endif;
    }

    /**
     * Blended settings menu
     */
    public function settings_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page('Library', __('Blended Settings', 'blended'), __('Blended Settings', 'blended'), 'manage_options', 'Setting', array($this, 'settings_page'));
        endif;
    }

    /**
     * Blended shared packages menu
     */
    public function shared_packages_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page('Library', __('Blended Shared Packages', 'blended'), __('Shared Packages', 'blended'), 'manage_options', 'Shared-with-me', array($this, 'shared_packages_page'));
        endif;
    }

    /**
     * Blended my purchase menu
     */
    public function my_purchases_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page('Library', __('Blended My Purchases', 'blended'), __('My Purchases', 'blended'), 'manage_options', 'My-Purchases', array($this, 'my_purchases_page'));
        endif;
    }

    /**
     * Blended archived packages menu
     */
    public function archived_packages_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page('Library', __('Blended Archived Packages', 'blended'), __('Archived Packages', 'blended'), 'manage_options', 'Archived-Packages', array($this, 'archived_packages_page'));
        endif;
    }

    /**
     * Blended onboard menu
     * This menu would not be locked to menu bar
     */
    public function onboard_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page(null, __('Blended Onboard', 'blended'), __('Blended Onboard', 'blended'), 'manage_options', 'Onboard', array($this, 'onboard_page'));
        endif;
    }

    /**
     * Blended source code menu
     * This menu would not be locked to menu bar
     */
    public function source_code_menu() {
        if (current_user_can('manage_options')):
            add_submenu_page(null, __('Blended Source Code', 'blended'), __('Source Code', 'blended'), 'manage_options', 'Source Code', array($this, 'source_code_page'));
        endif;
    }

    /**
     * Blended menu order
     * @global array $submenu
     */
    public function menu_order() {
        //Change first order
        global $submenu;
        $submenu['Library'][0][0] = __('Themes', 'blended');
        $submenu['Library'][0][2] = "admin.php?page=Library&lib=Themes";
    }

    /**
     * Blended library page
     * @see admin_menu()
     */
    public function library_page() {
        print '<div class="blendedux-page" id="blendedux"></div>';
    }

    /**
     * Blended settings page
     * @see settings_menu()
     */
    public function settings_page() {
        print '<div class="blendedux-page" id="blendedux"></div>';
    }

    /**
     * Blended themes page
     * @see themes_menu()
     */
    public function themes_page() {
        
    }

    /**
     * Blended layouts page
     * @see layouts_menu()
     */
    public function layouts_page() {
        
    }

    /**
     * Blended code snippet page
     * @see code_snippet_menu()
     */
    public function code_snippet_page() {
        
    }

    /**
     * Blended shared packages page
     * @see shared_packages_menu()
     */
    public function shared_packages_page() {
        
    }

    /**
     * Blended pending transfer page
     * @see pending_transfer_menu()
     */
    public function pending_transfer_page() {
        
    }

    /**
     * Blended my purchases page
     * @see my_purchases_menu()
     */
    public function my_purchases_page() {
        
    }

    /**
     * Blended archived packages page
     * @see archived_packages_menu()
     */
    public function archived_packages_page() {
        
    }

    /**
     * Blended onboard page
     * @see onboard_menu()
     */
    public function onboard_page() {
        print '<div class="blendedux-page onboarding-page" id="blendedux"></div>';
    }

    /**
     * Blended source code page
     * @see source_code_menu()
     */
    public function source_code_page() {
        print '<div class="blendedux-page" id="blendedux"></div>';
    }

}

return new Blended_Admin_Menus();
