<?php

/**
 * Blended Post Types and Taxonomies.
 *
 * @class    Blended_Post_types
 * @author   Blended
 * @package  Blended/Posts
 * @category Class
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Blended_Post_types Class.
 */
class Blended_Post_types {

    /**
     * Hook in methods.
     */
    public static function init() {
        add_action('init', array(__CLASS__, 'register_taxonomies'), 5);
        add_action('init', array(__CLASS__, 'register_post_types'), 5);
    }

    /**
     * Register post types.
     */
    public static function register_post_types() {
        if (!is_blog_installed() || post_type_exists('blended_gallery')) {
            return;
        }

        register_post_type('blended_gallery', apply_filters('blended_register_post_type_blended_gallery', array(
            'labels' => array(
                'name' => __('Gallery', 'blended'),
                'singular_name' => __('Gallery', 'blended'),
                'all_items' => __('All Gallery', 'blended'),
                'menu_name' => _x('Gallery', 'Admin menu name', 'blended'),
                'add_new' => __('Add New', 'blended'),
                'add_new_item' => __('Add new gallery', 'blended'),
                'edit' => __('Edit', 'blended'),
                'edit_item' => __('Edit gallery', 'blended'),
                'new_item' => __('New gallery', 'blended'),
                'view' => __('View gallery', 'blended'),
                'view_item' => __('View gallery', 'blended'),
                'search_items' => __('Search gallery', 'blended'),
                'not_found' => __('No gallery found', 'blended'),
                'not_found_in_trash' => __('No gallery found in trash', 'blended'),
                'insert_into_item' => __('Insert into gallery', 'blended'),
                'uploaded_to_this_item' => __('Uploaded to this gallery', 'blended'),
                'filter_items_list' => __('Filter gallery', 'blended'),
                'items_list_navigation' => __('Gallery navigation', 'blended'),
                'items_list' => __('Gallery list', 'blended'),
            ),
            'description' => __('Add new gallery to your theme.', 'blended'),
            'menu_icon' => 'dashicons-format-gallery',
            'public' => true,
            'show_ui' => true,
            'capability_type' => 'post',
            'map_meta_cap' => true,
            'publicly_queryable' => true,
            'exclude_from_search' => false,
            'hierarchical' => false,
            'rewrite' => array('slug' => 'gallery'),
            'query_var' => true,
            'supports' => array('title', 'author', 'excerpt', 'editor', 'thumbnail'),
            'has_archive' => true,
            'show_in_nav_menus' => true,
            'show_in_rest' => true,
                        )
                )
        );

        //Testimonial
        if (post_type_exists('blended_testimonial')) {
            return;
        }

        register_post_type('blended_testimonial', apply_filters('blended_register_post_type_blended_testimonial', array(
            'labels' => array(
                'name' => __('Testimonial', 'blended'),
                'singular_name' => __('Testimonial', 'blended'),
                'all_items' => __('All Testimonials', 'blended'),
                'menu_name' => _x('Testimonial', 'Admin menu name', 'blended'),
                'add_new' => __('Add New', 'blended'),
                'add_new_item' => __('Add new testimonial', 'blended'),
                'edit' => __('Edit', 'blended'),
                'edit_item' => __('Edit testimonial', 'blended'),
                'new_item' => __('New testimonial', 'blended'),
                'view' => __('View testimonial', 'blended'),
                'view_item' => __('View testimonial', 'blended'),
                'search_items' => __('Search testimonials', 'blended'),
                'not_found' => __('No testimonials found', 'blended'),
                'not_found_in_trash' => __('No testimonials found in trash', 'blended'),
                'insert_into_item' => __('Insert into testimonial', 'blended'),
                'uploaded_to_this_item' => __('Uploaded to this testimonial', 'blended'),
                'filter_items_list' => __('Filter testimonial', 'blended'),
            ),
            'description' => __('Add new testimonial.', 'blended'),
            'menu_icon' => 'dashicons-edit',
            'public' => true,
            'show_ui' => true,
            'capability_type' => 'post',
            'map_meta_cap' => true,
            'publicly_queryable' => true,
            'exclude_from_search' => false,
            'hierarchical' => false,
            'rewrite' => array('slug' => 'testimonial'),
            'query_var' => true,
            'supports' => array('title', 'editor', 'author', 'thumbnail', 'excerpt'),
            'has_archive' => true,
            'show_in_nav_menus' => true,
            'show_in_rest' => true,
                        )
                )
        );
    }

    /**
     * Register taxonomies.
     */
    public static function register_taxonomies() {

        if (taxonomy_exists('blended_gallery_cat')) {
            return;
        }

        //Category
        register_taxonomy('blended_gallery_cat', array('blended_gallery'), apply_filters('blended_taxonomy_args_blended_gallery_cat', array(
            'hierarchical' => true,
            'label' => __('Gallery Categories', 'blended'),
            'labels' => array(
                'name' => __('Gallery categories', 'blended'),
                'singular_name' => __('Category', 'blended'),
                'menu_name' => _x('Categories', 'Admin menu name', 'blended'),
                'search_items' => __('Search categories', 'blended'),
                'all_items' => __('All categories', 'blended'),
                'parent_item' => __('Parent category', 'blended'),
                'parent_item_colon' => __('Parent category:', 'blended'),
                'edit_item' => __('Edit category', 'blended'),
                'update_item' => __('Update category', 'blended'),
                'add_new_item' => __('Add new category', 'blended'),
                'new_item_name' => __('New category name', 'blended'),
                'not_found' => __('No categories found', 'blended'),
            ),
            'show_ui' => true,
            'query_var' => true,
            'capabilities' => array(),
            'rewrite' => array("slug" => "gallery/category"),
                ))
        );


        if (taxonomy_exists('blended_gallery_tag')) {
            return;
        }

        //Tag
        register_taxonomy('blended_gallery_tag', array('blended_gallery'), apply_filters('blended_taxonomy_args_blended_gallery_tag', array(
            'hierarchical' => false,
            'label' => __('Gallery tags', 'blended'),
            'labels' => array(
                'name' => __('Gallery tags', 'blended'),
                'singular_name' => __('Tag', 'blended'),
                'menu_name' => _x('Tags', 'Admin menu name', 'blended'),
                'search_items' => __('Search tags', 'blended'),
                'all_items' => __('All tags', 'blended'),
                'edit_item' => __('Edit tag', 'blended'),
                'update_item' => __('Update tag', 'blended'),
                'add_new_item' => __('Add new tag', 'blended'),
                'new_item_name' => __('New tag name', 'blended'),
                'popular_items' => __('Popular tags', 'blended'),
                'separate_items_with_commas' => __('Separate tags with commas', 'blended'),
                'add_or_remove_items' => __('Add or remove tags', 'blended'),
                'choose_from_most_used' => __('Choose from the most used tags', 'blended'),
                'not_found' => __('No tags found', 'blended'),
            ),
            'show_ui' => true,
            'query_var' => true,
            'capabilities' => array(),
            'rewrite' => array("slug" => "gallery/tag"),
                ))
        );
    }

}

Blended_Post_types::init();
