<?php

/**
 * Blended VC Support
 * @since 1.0
 */
// don't load directly
if (!defined('ABSPATH'))
    die('-1');

/**
 *  Blended_VC Class
 */
class Blended_VC {

    /**
     * Blended Shortcodes for VC
     * @var array 
     */
    private $shortcodes;

    public function __construct() {
        // We safely integrate with VC with this hook
        if (!$this->is_vc_active())
            return;

        add_action('vc_before_init', array($this, 'init_vc'));
    }

    /**
     * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
     */
    public function init_vc() {

        $this->shortcodes = include_once BLENDED_VC . "/shortcodes.php";

        foreach ((array) $this->shortcodes as $vc_shortcode):
            include_once BLENDED_VC_SHORTCODES . "/" . $vc_shortcode . ".php";
            include_once BLENDED_VC_TEMPLATES . "/" . $vc_shortcode . ".php";
        endforeach;

        //Disable design options ans custom css tab
        //vc_set_as_theme();
        // Set elements directory
        if (function_exists('vc_set_shortcodes_templates_dir'))
            vc_set_shortcodes_templates_dir(get_template_directory() . '/vc/shortcodes');
    }

    /**
     * Check Visual Composer is activated
     */
    public function is_vc_active() {
        // Check if Visual Composer is installed
        if (!defined('WPB_VC_VERSION')) {
            // Display notice that Visual Compser is required
            add_action('admin_notices', array($this, 'show_vc_notice'));
            return false;
        }

        return true;
    }

    /**
     * Show notice if your theme is activated but Visual Composer is not
     */
    public function show_vc_notice() {

        echo '
        <div class="updated">
          <p>' . sprintf(__('<strong>%s</strong> requires <strong><a href="http://bit.ly/vcomposer" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site.', 'blended'), __("Blended Theme", "blended")) . '</p>
        </div>';
    }

}

//Instantiate Blended_VC
new Blended_VC();
