<?php
 /*
 * -------------------------------------------------------------------------
 * URI ROUTING
 * -------------------------------------------------------------------------
 * This file lets you re-map URI requests to specific controller functions.
 * using wp rest api version 2 ships with wordpress core after wordpress 5.6.
 * Typically there is a one-to-one relationship between a URL string
 * and its corresponding controller class/method. The segments in a
 * URL normally follow this pattern:
 *
 *	example.com/blended/v0
 *
 * In some instances, however, you may want to remap this relationship
 * so that a different class/function is called than the one
 * corresponding to the URL.
 *
 * @package	blended
 * @author	Blended Team
 * @since	Version 1.0.0
 * @filesource
 */

 //Blended API namespace.
 $NAMESPACE = $blendedConfig->get('swagger', 'BASE_PATH_2');

// require dirname(__FILE__) . '/ItineraryRoute.php';
 use Blended\hostlib\ItineraryRoute;

 /**
 * Add a admin user into account.
 * API : POST /accounts/{slug}/admins/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)/admins', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $slug        = $body['slug'];
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->post_addAccountAdmin($slug, $body, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Retrieve current active theme from Host.
 * API : GET /active
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/active', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $ItineraryRoute = new ItineraryRoute();
                    $activeTheme    = $ItineraryRoute->get_active();
                    return $activeTheme;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Set as current active theme to Host.
 * API : PUT /active
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/active', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $slug        = $body['slug'];
                    $ItineraryRoute = new ItineraryRoute();
                    $activeTheme    = $ItineraryRoute->put_active($slug, $sessionKey);
                    return $activeTheme;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['data'])) {
                        return new WP_Error($error['status_code'], $error['message'], $error['data']);
                    } else {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Create package draft.
 * API : POST /packages/{accountSlug}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $verbose     = true;
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->post_createPackage($body, $sessionKey, $verbose);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update local package.
 * API : PUT /packages/{accountSlug}/{slug}/local/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/local/documents', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body           = $request->get_body();
                    $body           = json_decode($body, true);
                    $slug           = strtolower($request['slug']);
                    $accountSlug    = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_localUpdate($accountSlug, $slug, $body, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    $data = (isset($error['data']) && !empty($error['data']) ? $error['data']: "");
                    return new WP_Error($error['status_code'], $error['message'], $data);
                }
            }
            )
        );
     }
 );

 /**
 * Update local package.
 * API : PUT /packages/{accountSlug}/{slug}/local/local/documents/merge/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/local/documents/merge', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_mergePackage($accountSlug, $slug, $body, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get detail view of canonical version of a package.
 * API : GET /packages/{accountSlug}/{slug}/canonical/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/canonical', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $verbose     = true;
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_canonicalDetails($accountSlug, $slug, $sessionKey, $verbose);
                    return $packageJptf;
                }
                catch (\Exception $e) {
//return $e->getMessage();
//  return new WP_Error("500", "", $e->getMessage());
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Compare draft package.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/draft/documents', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $ItineraryRoute = new ItineraryRoute();
                    $comparison     = $ItineraryRoute->get_compare_draft($accountSlug1, $slug1, $accountSlug2, $slug2, $sessionKey);
                    return $comparison;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Compare canonical package version.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/canonical/documents', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $ItineraryRoute = new ItineraryRoute();
                    $comparison     = $ItineraryRoute->get_compare_canonical($accountSlug1, $slug1, $accountSlug2, $slug2, $sessionKey);
                    return $comparison;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Compare canonical package version.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/documents', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $label        = $request['label'];
                    $ItineraryRoute = new ItineraryRoute();
                    
                    $comparison     = $ItineraryRoute->get_compare_version($accountSlug1, $slug1, $accountSlug2, $slug2, $label, $sessionKey);
                    return $comparison;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Retrieve file data in comparison of packages.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/{name}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/version/(?P<label>[a-z0-9._\-]+)/documents/(?P<name>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $label        = $request['label'];
                    $filePath     = $request['name'];
                    $filePath     = urldecode(urldecode($filePath));
                    $filePath     = ltrim(str_replace('*', '/', $filePath), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $comparison     = $ItineraryRoute->get_compare_labeledversion_file($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $label, $sessionKey);
                    return $comparison;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get package JPTF from filesystem or Hub.
 * API : GET /packages/{accountSlug}/{slug}/local/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/local/documents', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $asHash         = $request['as_hash'];
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf     = $ItineraryRoute->get_localDownload($accountSlug, $slug, $asHash, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['data'])) {
                        return new WP_Error($error['status_code'], $error['message'], $error['data']);
                    } 
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Create empty package.
 * API : POST /packages/{accountSlug}/{slug}/local/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/local/documents', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->post_localCreate($accountSlug, $slug, $body, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Create a snapshot of a package.
 * API : GET /packages/{accountSlug}/{slug}/versions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versions', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageDetails = $ItineraryRoute->post_versionCreateSnapshot($accountSlug, $slug, $body, $sessionKey);
                    return $packageDetails;
                }
                catch (\Exception $e) {
                    $code = $e->getCode();
                    $error = json_decode($e->getMessage(), true);
                    $message = (isset($error['message']) ? $error['message'] : "");
                    $status_code = (isset($error['status_code']) ? $error['status_code'] : "");
                    $draft_dependency = isset($error['draft_dependency'])&& !empty($error['draft_dependency']) ? array("draft_dependency" =>$error['draft_dependency']) : "";
                    if ( !empty($draft_dependency)) {
                        return new WP_Error($error['status_code'], $error['message'], $draft_dependency);
                    } else if($code === 500) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    }
                    $data = prepare_response_data($error, $code);
                    return new WP_Error($status_code, $message, $data);
                }
            }
            )
        );
     }
 );

 /**
 * Get version data of a package in details.
 * API : GET /packages/{accountSlug}/{slug}/versions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $label     = $request['label'];
                    $ItineraryRoute = new ItineraryRoute();
                    $packageDetails = $ItineraryRoute->get_getVersionDetails($accountSlug, $slug, $label, $sessionKey);
                    return $packageDetails;
                
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get version documents of a package.
 * API : GET /packages/{accountSlug}/{slug}/versions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/documents', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $label     = $request['label'];
                    $asHash     = $request['as_hash'];
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_versionDownload($accountSlug, $slug, $label, $asHash, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get version documents of a package in details.
 * API : GET /packages/{accountSlug}/{slug}/versions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/documents/(?P<name>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $label       = $request['label'];
                    $filePath    = $request['name'];
                    $filePath    = urldecode(urldecode($filePath));
                    $filePath    = ltrim(str_replace('*', '/', $filePath), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_versionDownloadFile($accountSlug, $slug, $label, $filePath, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get file jptf package object.
 * API : GET /packages/{accountSlug}/{slug}/local/documents/{name}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/local/documents/(?P<name>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $fileName    = $request['name'];
                    $fileName    = urldecode(urldecode($fileName));
                    $fileName    = ltrim(str_replace('*', '/', $fileName), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_localDownloadFile($accountSlug, $slug, $fileName, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get package details either from Hub or local filesystem.
 * API : GET /packages/{accountSlug}/{slug}/local/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/local', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageDetails = $ItineraryRoute->get_localPackageGet($accountSlug, $slug, $sessionKey);
                    return $packageDetails;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Delete package from local filesystem.
 * API : DELETE /packages/{accountSlug}/{slug}/local/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/local', array(
            'methods' => 'DELETE',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageDetails = $ItineraryRoute->delete_localDelete($accountSlug, $slug, $sessionKey);
                    return $packageDetails;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Clone package on local file system .
 * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/local/documents', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $body         = $request->get_body();
                    $body         = json_decode($body, true);
                    $packageTitle = null;
                    if(isset($body['title'])) {
                      $packageTitle = $body['title'];
                    }
                    $ItineraryRoute = new ItineraryRoute();
                    $status         = $ItineraryRoute->post_localClone($accountSlug1, $slug1, $accountSlug2, $slug2, $packageTitle, $sessionKey);
                    return $status;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && trim($error['status_code']) == "5059") {
                        $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $sessionKey);
                        return new WP_Error($error['status_code'], "Package name already in use.", "");
                    } else if (isset($error['code']) && trim($error['code']) == "4035") {
                        $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $sessionKey);
                        return new WP_Error($error['code'], $error['message'], $error['data']);
                    } else if (isset($error['message']) && trim($error['message']) == "Draft has been changed. Please pull it first.") {
                        $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $sessionKey);
                        return new WP_Error($error['status_code'], "Package name already in use.", "");
                    } else if (isset($error['message']) && trim($error['message']) == "Package does not have draft") {
                        $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $sessionKey);
                        return new WP_Error($error['status_code'], "Package name already in use.", "");
                    }  else if (isset($error['status_code']) && isset($error['message']) && isset($error['data'])) {
                        if($error['message'] === "Invalid File!") {
                           $ItineraryRoute->delete_localDelete($accountSlug2, $slug2, $sessionKey);
                        }
                        return new WP_Error($error['status_code'], $error['message'], $error['data']);
                    } else {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Get file jptf package representation.
 * API : GET /packages/{accountSlug}/{slug}/draft/documents/{name}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/draft/documents/(?P<name>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $filePath    = $request['name'];
                    $filePath    = urldecode(urldecode($filePath));
                    $filePath    = ltrim(str_replace('*', '/', $filePath), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_getFile($accountSlug, $slug, $filePath, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get package object from Hub and save it to locally by calling controller get_package method.
 * API : GET /packages/{accountSlug}/{slug}/draft/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/draft/documents', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug    = strtolower($request['accountSlug']);
                    $slug           = strtolower($request['slug']);
                    $force          = $request['force'];
                    $asHash         = $request['as_hash'];
                    if(isset($request['version'])) {
                        $label = $request['version'];
                    } else {
                        $label = null;
                    }
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_pull_package($accountSlug, $slug, $force, $asHash, $label, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    if ($e->getMessage() == "Invalid Package or package dependencies detected!") {
                        return new WP_Error('500', $e->getMessage(), "");
                    }
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Push package clone to Hub.
 * API : POST /packages/{accountSlug}/{slug}/draft/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/draft/documents', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->post_createHubPackage($accountSlug, $slug, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);  
                    if (!isset($error['status_code']) && !isset($error['message'])) {
                        return new WP_Error("4035", "Invalid media type.", $error['data']);
                    } elseif (isset($error['status_code']) && trim($error['status_code']) == "5059") {
                        $ItineraryRoute->delete_localDelete($accountSlug, $slug, $sessionKey);
                        return new WP_Error($error['status_code'], "Package name already in use.", "");
                    } elseif (isset($error['status_code']) && trim($error['status_code']) == "5064") {
                        $ItineraryRoute->delete_localDelete($accountSlug, $slug, $sessionKey);
                        return new WP_Error($error['status_code'],  $error['message'], "");
                    } elseif (isset($error['status_code']) && trim($error['status_code']) == "500") {
                        $ItineraryRoute->delete_localDelete($accountSlug, $slug, $sessionKey);
                        return new WP_Error($error['status_code'], $error['status_code'], "");
                    } elseif (isset($error['message']) && trim($error['message']) == "Draft has been changed. Please pull it first") {
                        $ItineraryRoute->delete_localDelete($accountSlug, $slug, $sessionKey);
                        return new WP_Error($error['status_code'], "Package name already in use.", "");
                    } else {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Push package object to Hub.
 * API : PUT /packages/{accountSlug}/{slug}/draft/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/draft/documents', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body    = $request->get_body();
                    $body    = json_decode($body, true);
                    $force = $request['force'];
                    if ($force == "true") {
                        $force = true;
                    } else {
                        $force = false;
                    }
                    $accountSlug    = strtolower($request['accountSlug']);
                    $slug           = strtolower($request['slug']);
                    $pushToHub      = $request['pushToHub'];
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_push_package($accountSlug, $slug, $force, $pushToHub, $body, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    try {
                        $ItineraryRoute = new ItineraryRoute();
                        $packageJptf    = $ItineraryRoute->put_push_package_helper($accountSlug, $slug, $sessionKey, $e->getMessage());
                        return $packageJptf;
                    } catch(Exception $e) {
                        $error = json_decode($e->getMessage(), true);
                        if (isset($error['changemessage']) && $error['changemessage'] == true && isset($error['status_code']) && isset($error['message'])) {
                            $error['message'] = "You need to sync.";
                            return new WP_Error($error['status_code'], $error['message'], "");
                        }
                        if (isset($error['changemessage']) && $error['changemessage'] == true) {
                            return new WP_Error('500', "Invalid Package. Something wrong with your package either the file _package.json not found or you are trying to push some invalid files.", "");
                        }
                        if (isset($error['code']) && trim($error['code']) == "4035") {
                        return new WP_Error($error['code'], $error['message'], $error['data']);
                        }
                        if (isset($error['data']) && !isset($error['status_code']) && !isset($error['message'])) {
                            $dataValue = "Upload a valid image. The file you uploaded was either not an image or a corrupted image.";
                            if(is_array($error['data']) && !empty($error['data']))
                                $error['data'] = array_fill_keys(array_keys($error['data']), $dataValue);
                            return new WP_Error("4035", "Invalid media type.", $error['data']);
                        }
                        if (isset($error['errors'])) {
                            return new WP_Error($error['status_code'], $error['errors'], "");
                        } else if (isset($error['status_code']) && isset($error['message']) && isset($error['data'])) {
                            return new WP_Error($error['status_code'], $error['message'], $error['data']);
                        } else if (isset($error['status_code']) && isset($error['message'])) {
                            return new WP_Error($error['status_code'], $error['message'], "");
                        } else {
                            return new WP_Error('500', 'Package Does not Exist.', "");
                        }
                    }                
                }
            }
            )
        );
     }
 );

 /**
 * Get package object from Hub and save it to locally by calling controller get_package method.
 * API : PUT /packages/{slug}/draft/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<slug>[a-z0-9_\-]+)/draft/documents', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_pull_package($slug, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get package dependencies.
 * API : GET /packages/{accountSlug}/{slug}/dependencies/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/dependencies', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug                = strtolower($request['slug']);
                    $accountSlug         = strtolower($request['accountSlug']);
                    $verbose             = true;
                    $ItineraryRoute      = new ItineraryRoute();
                    $packageDependencies = $ItineraryRoute->get_getDependencies($accountSlug, $slug, $verbose, $sessionKey);
                    return $packageDependencies;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            
            }
            )
        );
     }
 );

 /**
 * Access draft documents and directory.
 * API : GET /packages/{accountSlug}/{slug}/draft/documents/{name}/
 */
 /**
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/draft/documents/(?P<name>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug   = strtolower($request['accountSlug']);
                    $slug          = strtolower($request['slug']);
                    $filePath      = $request['name'];
                    $filePath      = ltrim(str_replace('*', '/', $filePath), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $packageDetail  = $ItineraryRoute->get_getDetailDocument($accountSlug, $slug, $filePath, $sessionKey);
                    return $packageDetail;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );
  * 
  */

 /**
 * Get package draft.
 * API : GET /packages/{accountSlug}/{slug}/draft/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/draft', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_getDraft($accountSlug, $slug, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get package draft details.
 * API : GET /packages/{accountSlug}/{slug}/draft/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug         = strtolower($request['slug']);
                    $accountSlug = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageDetail  = $ItineraryRoute->get_getPackageDetails($accountSlug, $slug, $sessionKey);
                    return $packagepackageDetailJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update package version as canonical version.
 * API : PUT /packages/{accountSlug}/{slug}/canonical/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/canonical', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->put_canonicalSet($accountSlug, $slug, $body, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update user draft package.
 * API : PUT /packages/{accountSlug}/{slug}/draft/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<slug>[a-z0-9_\-]+)/draft', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body           = $request->get_body();
                    $body           = json_decode($body, true);
                    $slug           = strtolower($request['slug']);
                    $accountSlug    = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_updateDraft($accountSlug, $slug, $body, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update Package.
 * API : PUT /packages/{accountSlug}/{slug}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $slug        = strtolower($request['slug']);
                    $accountSlug    = strtolower($request['accountSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_updatePackage($accountSlug, $slug, $body, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Detail View of user account.
 * API : GET /accounts/{slug}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header" }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug           = strtolower($request['slug']);
                    $verbose        = true;
                    $ItineraryRoute = new ItineraryRoute();
                    $accountDetail   = $ItineraryRoute->get_getAccountDetails($slug, $verbose, $sessionKey);
                    return $accountDetail;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && isset($error['message'])) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    } else {                
                        return new WP_Error("500", $e->getMessage(), "");
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Search accounts by starting keywords of account name .
 * API : GET /accounts/search/{search}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/search/(?P<accountSlug>[a-z0-9_\-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header" }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug     = strtolower($request['accountSlug']);
                    $ItineraryRoute  = new ItineraryRoute();
                    $accountDetail   = $ItineraryRoute->get_searchAccounts($accountSlug, $sessionKey);
                    return $accountDetail;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Resend the inivite of shared package.
 * API : POST packages/{accountSlug}/{slug}/resend/invite/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/resend/invite', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header" }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    
                    $body           = $request->get_body();
                    $body           = json_decode($body, true);
                    $accountSlug    = strtolower($request['accountSlug']);
                    $slug           = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $accountDetail  = $ItineraryRoute->post_resendInvite($accountSlug, $slug, $body, $sessionKey);
                    return $accountDetail;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && $error['message']) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    } else if(isset($error['errors'])) {
                        return new WP_Error($error['errors'], $error['errors'], "");
                    } else { 
                        return json_encode($e->getMessage());
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Resend Email Verification link to verifiy account if already not verified.
 * API : PUT accounts/resend/emailverification/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/resend/emailverification', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header" }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body           = $request->get_body();
                    $body           = json_decode($body, true);
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->put_resendAccountVerificationEmail($sessionKey, $body);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && $error['message']) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    } else if(isset($error['errors'])) {
                        return new WP_Error($error['errors'], $error['errors'], "");
                    } else { 
                        return json_encode($e->getMessage());
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Resend Email Verification link to verifiy account if already not verified.
 * API : PUT /accounts/resend/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/resend', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header" }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body           = $request->get_body();
                    $body           = json_decode($body, true);
                    $ItineraryRoute = new ItineraryRoute();
                    $accountDetail  = $ItineraryRoute->put_resendAccountVerificationEmail($sessionKey, $body);
                    return $accountDetail;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get list of user's account pending users.
 * API : GET /accounts/{slug}/pendings/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)/pendings', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug           = strtolower($request['slug']);
                    $verbose        = true;
                    $ItineraryRoute = new ItineraryRoute();
                    $pendingUser    = $ItineraryRoute->get_getPendingUsers($slug, $verbose, $sessionKey);
                    return $pendingUser;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Invite user to join account.
 * API : POST /packages/{slug}/pendings/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)/pendings', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body           = $request->get_body();
                    $body           = json_decode($body, true);
                    $slug           = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->post_inviteUser($slug, $body, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Delete a pending user from user account.
 * API : DELETE /accounts/{slug}/pendings/{email}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)/pendings/(?P<email>[a-z0-9.%#!$&/|*_-]+)', array(
            'methods' => 'DELETE',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug           = strtolower($request['slug']);
                    $email          = $request['email'];
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->delete_removePendingUser($slug, $email, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Create a new user account.
 * API : POST /accounts/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $body       = $request->get_body();
                    $body       = json_decode($body, true);                    
                    $verbose        = true;
                    $ItineraryRoute = new ItineraryRoute();
                    $userDetail     = $ItineraryRoute->post_createAccount($body, $verbose);
                    return $userDetail;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Retrieve all accounts from the system that the user has access to.
 * API : GET /accounts/{slug}/accounts/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)/accounts', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug           = strtolower($request['slug']);
                    $verbose        = true;
                    $ItineraryRoute = new ItineraryRoute();
                    $accountList    = $ItineraryRoute->get_getAccountList($slug, $verbose, $sessionKey);
                    return $accountList;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Set Hub current account from Hub settings on to current stored configuration.
 * API : PUT /accounts/{slug}/current
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<userSlug>[a-z0-9_\-]+)/current', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body         = $request->get_body();
                    $body         = json_decode($body, true);
                    $body         = json_decode($request->get_body(), true);
                    $slug         = strtolower($request['userSlug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->put_setCurrentAccount($slug, $body, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Set Hub current account from Hub settings on to current stored configuration.
 * API : GET /accounts/{slug}/current
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)/current', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $slug        = strtolower($request['slug']);
                    $verbose     = true;
                    $ItineraryRoute = new ItineraryRoute();
                    $account        = $ItineraryRoute->get_getCurrentAccount($slug, $verbose, $sessionKey);
                    return $account;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * push image to hub.
 * API : POST /packages/{slug}/media/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<slug>[a-z0-9_\-]+)/media', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                $network = BD()->network();
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageHash    = $ItineraryRoute->post_uploadMedia($slug, $hash_value, $name, $token, $image, $sessionKey);
                    return $packageHash;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Login user to account.
 * API : POST /login/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/login', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers    = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey    = $headers['sessionkey'];
                        $wpsessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $ItineraryRoute = new ItineraryRoute();
                    $session        = $ItineraryRoute->post_login($body, $wpsessionKey);
                    return $session;
                }
                catch (\Exception $e) {
                    $error      = json_decode($e->getMessage(), true);
                    if (isset($error['message']) && isset($error['status_code'])) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Get current user.
 * API : GET /accounts/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers    = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey    = $headers['sessionkey'];
                        $wpsessionKey = $sessionKey[0];
                    }
                    $ItineraryRoute = new ItineraryRoute();
                    $userDetails        = $ItineraryRoute->get_localaccountDetails($wpsessionKey);
                    return $userDetails;
                }
                catch (\Exception $e) {
                    if (isset($error['message'])) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Logout user and discard sessionKey.
 * API : POST /logout/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/logout', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers    = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey    = $headers['sessionkey'];
                        $wpsessionKey = $sessionKey[0];
                    }
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->post_logout($wpsessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Reset password of user account.
 * API : POST /reset/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/reset', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->post_resetPassword($body, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update User Account.
 * API : PUT /accounts/{slug}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $slug        = strtolower($request['slug']);
                    if(isset($body['activationSolution'])) {
                      $body['activation_solution'] = $body['activationSolution'];
                      unset($body['activationSolution']);
                    }
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->put_updateAccount($slug, $body, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * API to acquire package between accounts.
 * API : POST /packages/{slug}/acquisitions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<slug>[a-z0-9_\-]+)/acquisitions', array(
            'methods' => 'POST',
            'callback' => function ($request) {
            
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body         = $request->get_body();
                    $body         = json_decode($body, true);
                    $slug         = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $package        = $ItineraryRoute->post_acquirePackage($slug, $body, $sessionKey);
                    return $package;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && $error['message']) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    } else if(isset($error['errors'])) {
                        return new WP_Error($error['errors'], $error['errors'], "");
                    } else { 
                        return json_encode($e->getMessage());
                    }
                }
            }
            )
        );
     }
 );


 /**
 * API to accept acquisition.
 * API : PUT /packages/{accountSlug}/{slug}/acquisitions/
 */
add_action(
        'rest_api_init', function () {
    global $NAMESPACE;
    register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/acquisitions', array(
        'methods' => 'PUT',
        'callback' => function ($request) {

            try {
                $headers = $request->get_headers();
                if (!isset($headers['sessionkey'])) {
                    throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                } else {
                    $sessionKey = $headers['sessionkey'];
                    $sessionKey = $sessionKey[0];
                }
                $body = $request->get_body();
                $body = json_decode($body, true);
                $accountSlug = strtolower($request['accountSlug']);
                $slug = strtolower($request['slug']);
                $ItineraryRoute = new ItineraryRoute();
                $package = $ItineraryRoute->put_acceptAcquisition($accountSlug, $slug, $body, $sessionKey);
                return $package;
            } catch (\Exception $e) {
                $error = json_decode($e->getMessage(), true);
                if (isset($error['status_code']) && $error['message']) {
                    return new WP_Error($error['status_code'], $error['message'], "");
                } else if (isset($error['errors'])) {
                    return new WP_Error($error['errors'], $error['errors'], "");
                } else {
                    return json_encode($e->getMessage());
                }
            }
        }
            )
    );
}
);

 /**
 * API to acquire package between accounts.
 * API : POST /packages/{accountSlug}/{slug}/acquisitions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/acquisitions', array(
            'methods' => 'POST',
            'callback' => function ($request) {
            
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body           = $request->get_body();
                    $body           = json_decode($body, true);
                    $accountSlug    = strtolower($request['accountSlug']);
                    $slug           = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $acquireDetail  = $ItineraryRoute->post_acquirePackage($accountSlug, $slug, $body, $sessionKey);
                    if(empty($acquireDetail)) {
                       $acquireDetail = array();
                    }
                    return $acquireDetail;
                }
                catch (\Exception $e) {
                    $code = $e->getCode();
                    $error = json_decode($e->getMessage(), true);
                    $message = (isset($error['message']) ? $error['message'] : "");
                    $status_code = (isset($error['status_code']) ? $error['status_code'] : "");
                    $draft_dependency = isset($error['draft_dependency'])&& !empty($error['draft_dependency']) ? array("draft_dependency" =>$error['draft_dependency']) : "";
                    if ( !empty($draft_dependency)) {
                        return new WP_Error($error['status_code'], $error['message'], $draft_dependency);
                    } else if($code === 500) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    }
                    $data = prepare_response_data($error, $code);
                    return new WP_Error($status_code, $message, $data);

                }
            }
            )
        );
     }
 );

 /**
 * API to reject shared package.
 * API : PUT /packages/{accountSlug}/{slug}/reject/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/reject', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
            
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body         = $request->get_body();
                    $body         = json_decode($body, true);
                    $accountSlug  = strtolower($request['accountSlug']);
                    $slug         = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $package        = $ItineraryRoute->put_rejectAcquisitionInvite($accountSlug, $slug, $body, $sessionKey);
                    return $package;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && $error['message']) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    } else if(isset($error['errors'])) {
                        return new WP_Error($error['errors'], $error['errors'], "");
                    } else { 
                        return json_encode($e->getMessage());
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Detail list of those accounts the package is shared or invited for accept share package.
 * API : GET /packages/{accountSlug}/{slug}/acquisitions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/acquisitions', array(
            'methods' => 'GET',
            'callback' => function ($request) {
            
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body         = $request->get_body();
                    $body         = json_decode($body, true);
                    $accountSlug  = strtolower($request['accountSlug']);
                    $slug         = strtolower($request['slug']);
                    $share = $request['share'];
                    $ItineraryRoute = new ItineraryRoute();
                    $package        = $ItineraryRoute->get_getAcquiredPackageAccountList($accountSlug, $slug, $sessionKey, $share);
                    return $package;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && $error['message']) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    } else if(isset($error['errors'])) {
                        return new WP_Error($error['errors'], $error['errors'], "");
                    } else { 
                        return json_encode($e->getMessage());
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Revoke shared pakage from user.
 * API : DELETE /packages/{accountSlug}/{slug}/acquisitions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/acquisitions', array(
            'methods' => 'DELETE',
            'callback' => function ($request) {
            
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body         = $request->get_body();
                    $body         = json_decode($body, true);
                    $accountSlug  = strtolower($request['accountSlug']);
                    $slug         = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $package        = $ItineraryRoute->delete_revokeAcquiredPackage($accountSlug, $slug, $body, $sessionKey);
                    return $package;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && $error['message']) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    } else if(isset($error['errors'])) {
                        return new WP_Error($error['errors'], $error['errors'], "");
                    } else { 
                        return json_encode($e->getMessage());
                    }
                }
            }
            )
        );
     }
 );

 /**
 * Merge Hub and local stored packages details of logged-in user account.
 * API : GET /packages/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers     = $request->get_headers();
                    $sessionKey = null;
                    if (isset($headers['sessionkey'])) {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $share = isset($request['share']) ? $request['share'] : "";
                    $transfer_to_me = isset($request['transfer_to_me']) ? $request['transfer_to_me'] : "";
                    $transfer_by_me = isset($request['transfer_by_me']) ? $request['transfer_by_me'] : "";
                    $snapshot       = isset($request['snapshot']) ? $request['snapshot'] : "";
                    $purchased      = isset($request['purchased']) ? $request['purchased'] : "";
                    $dependency     = isset($request['dependency']) ? $request['dependency'] : "";
                    $published     = isset($request['published']) ? $request['published'] : "";
                    $ItineraryRoute = new ItineraryRoute();
                    $package        = $ItineraryRoute->get_sync_client_account($sessionKey, $share, $transfer_by_me, $transfer_to_me, $purchased, $snapshot, $dependency, $published);
                    return $package;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get theme setting required to render theme.
 * API : GET /settings/theme/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/settings/theme', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $ItineraryRoute = new ItineraryRoute();
                    $settingsTheme  = $ItineraryRoute->get_get_theme_settings();
                    return $settingsTheme;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Save theme settings onto current configuration.
 * API : PUT /settings/theme/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/settings/theme', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $newSettings  = json_decode($request->get_body(), true);
                    $ItineraryRoute = new ItineraryRoute();
                    $settingsTheme  = $ItineraryRoute->put_save_theme_settings($newSettings);
                    return $settingsTheme;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Save theme settings onto current configuration.
 * API : GET /settings/wordpress/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/settings/wordpress', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $ItineraryRoute    = new ItineraryRoute();
                    $settingsWordpress = $ItineraryRoute->get_get_wordpress_settings();
                    return $settingsWordpress;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Save WordPress settings onto current configuration.
 * API : PUT /settings/wordpress/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/settings/wordpress', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $newSettings       = json_decode($request->get_body(), true);
                    $ItineraryRoute    = new ItineraryRoute();
                    $settingsWordpress = $ItineraryRoute->put_save_wordpress_settings($newSettings);
                    return $settingsWordpress;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            
            }
            )
        );
     }
 );

 /**
 * Get nav default settings for admin
 * API : GET /menus/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/menus', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{"status_code":"400","message":"sessionkey not found"}');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $ItineraryRoute = new ItineraryRoute();
                    $menuWordpress  = $ItineraryRoute->get_get_nav_list($sessionKey);
                    return $menuWordpress;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get navigation items
 * API : GET /menus/{id}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/menus/(?P<id>\d+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $id             = $request['id'];
                    $ItineraryRoute = new ItineraryRoute();
                    $menuWordpress  = $ItineraryRoute->get_get_nav_menu($id);
                    return $menuWordpress;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get navigation specific setting required to render theme.
 * API : GET /settings/navigations/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/settings/navigations', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{"status_code":"400","message":"sessionkey not found"}');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $ItineraryRoute    = new ItineraryRoute();
                    $navigationSetting = $ItineraryRoute->get_get_navigation_settings($sessionKey);
                    return $navigationSetting;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            
                return $settings;            
            }
            )
        );
     }
 );

 /**
 * Save navigation settings onto current configuration.
 * API : PUT /settings/navigations/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/settings/navigations', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{"status_code":"400","message":"sessionkey not found"}');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);            
                    $ItineraryRoute    = new ItineraryRoute();
                    $navigationSetting = $ItineraryRoute->put_get_navigation_settings($body, $sessionKey);
                    return $navigationSetting;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }            
            }
            )
        );
     }
 );

 /**
 * Get Hub Specific setting for getting and putting updates to user.
 * API : GET /settings/updates/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/settings/updates', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $ItineraryRoute = new ItineraryRoute();
                    $updateSetting  = $ItineraryRoute->get_get_hub_settings();
                    return $updateSetting;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            
                return $settings;                        
            }
            )
        );
     }
 );

 /**
 * Get Hub Specific setting for getting and putting updates to user.
 * API : PUT /settings/updates/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/settings/updates', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $ItineraryRoute = new ItineraryRoute();
                    $updateSetting  = $ItineraryRoute->put_save_hub_settings($body);
                    return $updateSetting;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            
            }
            )
        );
     }
 );

 /**
 * Retrieve all accounts from the system that the user has access to.
 * API : GET /accounts/{slug}/members/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/accounts/(?P<slug>[a-z0-9_\-]+)/members', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{"status_code":"400","message":"sessionkey not found"}');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $verbose     = true;
                    $slug         = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $accountList    = $ItineraryRoute->get_getAccountList($slug, $verbose, $sessionKey);
                    return $accountList;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get Details of package rating submitted by any user.
 * API : GET /packages/{accountSlug}/{slug}/ratings/{ratingpk}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/ratings/(?P<ratingPk>\d+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ratingPk    = (int) $request['ratingPk'];
                    $verbose     = "true";
                    $ItineraryRoute = new ItineraryRoute();
                    $getRating      = $ItineraryRoute->get_getRatingDetails($accountSlug, $slug, $ratingPk, $verbose, $sessionKey);
                    return $getRating;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update rating of package.
 * API : PUT /packages/{accountSlug}/{slug}/ratings/{ratingpk}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/ratings/(?P<ratingPk>\d+)', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ratingPk    = (int) $request['ratingPk'];
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->put_updateRating($accountSlug, $slug, $ratingPk, $body, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Get list of licenses associated with package.
 * API : GET /packages/{accountSlug}/{slug}/versions/{label}/licenses/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/licenses', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug    = strtolower($request['accountSlug']);
                    $slug           = strtolower($request['slug']);
                    $label          = $request['label'];
                    $ItineraryRoute = new ItineraryRoute();
                    $licenseDetails = $ItineraryRoute->get_getLicenses($accountSlug, $slug, $label, $sessionKey);
                    return $licenseDetails;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update price of package license.
 * API : PUT /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/licenses/(?P<name>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $accountSlug    = strtolower($request['accountSlug']);
                    $slug           = strtolower($request['slug']);
                    $label          = $request['label'];
                    $name           = $request['name'];
                    $ItineraryRoute = new ItineraryRoute();
                    $licenseDetails = $ItineraryRoute->put_updateLicense($accountSlug, $slug, $label, $name, $body, $sessionKey);
                    return $licenseDetails;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * delete a package license.
 * API : DELETE /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/licenses/(?P<name>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'DELETE',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $label       = $request['label'];
                    $name        = $request['name'];
                    $ItineraryRoute = new ItineraryRoute();
                    $ItineraryRoute->delete_removeLicense($accountSlug, $slug, $label, $name, $sessionKey);
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Retrieve list of package version.
 * API : GET /packages/{accountSlug}/{slug}/versions/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versions', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $versionList    = $ItineraryRoute->get_getVersions($accountSlug, $slug, $sessionKey);
                    return $versionList;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Clone draft on local file system .
 * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/draft/documents', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->post_draftClone($accountSlug1, $slug1, $accountSlug2, $slug2, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Clone version of a package on local file system .
 * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/documents', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $version      = $request['label'];
                    $packageHash  = $body['previousPackageHash'];
                    $packageTitle = null;
                    if(isset($body['title'])) {
                      $packageTitle = $body['title'];
                    }
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->post_versionClone($accountSlug1, $slug1, $accountSlug2, $slug2, $version, $packageHash, $packageTitle, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Compare draft document.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/draft/documents/(?P<document>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1   = strtolower($request['accountSlug1']);
                    $slug1          = strtolower($request['slug1']);
                    $accountSlug2   = strtolower($request['accountSlug2']);
                    $slug2          = strtolower($request['slug2']);
                    $filePath       = $request['document'];
                    $filePath       = urldecode(urldecode($filePath));
                    $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $fileComparison = $ItineraryRoute->get_compareFileWithDraft($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $sessionKey);
                    return $fileComparison;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Compare draft document.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/local/documents/(?P<document>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1   = strtolower($request['accountSlug1']);
                    $slug1          = strtolower($request['slug1']);
                    $accountSlug2   = strtolower($request['accountSlug2']);
                    $slug2          = strtolower($request['slug2']);
                    $filePath       = $request['document'];
                    $filePath       = urldecode(urldecode($filePath));
                    $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $fileComparison = $ItineraryRoute->get_compareFileWithLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $sessionKey);
                    return $fileComparison;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Compare version document.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/{document}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/documents/(?P<document>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1   = strtolower($request['accountSlug1']);
                    $slug1          = strtolower($request['slug1']);
                    $accountSlug2   = strtolower($request['accountSlug2']);
                    $slug2          = strtolower($request['slug2']);
                    $version        = $request['label'];
                    $filePath       = $request['document'];
                    $filePath       = urldecode(urldecode($filePath));
                    $filePath       = ltrim(str_replace('*', '/', $filePath), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $fileComparison = $ItineraryRoute->get_compareFileWithVersion($accountSlug1, $slug1, $accountSlug2, $slug2, $version, $filePath, $sessionKey);
                    return $fileComparison;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Compare version document.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/local/documents', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1      = strtolower($request['accountSlug1']);
                    $slug1             = strtolower($request['slug1']);
                    $accountSlug2      = strtolower($request['accountSlug2']);
                    $slug2             = strtolower($request['slug2']);
                    $ItineraryRoute    = new ItineraryRoute();
                    $packageComparison = $ItineraryRoute->get_compareWithLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $sessionKey);
                    return $packageComparison;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update draft.
 * API : PUT /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/draft/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/draft/documents', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_updateFromDraft($accountSlug1, $slug1, $accountSlug2, $slug2, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update local draft.
 * API : PUT /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/local/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/local/documents', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $files           = $request->get_body();
                    $files           = json_decode($files, true);
                    $accountSlug1   = strtolower($request['accountSlug1']);
                    $slug1          = strtolower($request['slug1']);
                    $accountSlug2   = strtolower($request['accountSlug2']);
                    $slug2          = strtolower($request['slug2']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_updateFromLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $files, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update draft from version document.
 * API : PUT /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/versions/{label}/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/versions/(?P<label>[a-z0-9._\-]+)/documents', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }
                    $files           = $request->get_body();
                    $files           = json_decode($files, true);
                    $accountSlug1   = strtolower($request['accountSlug1']);
                    $slug1          = strtolower($request['slug1']);
                    $accountSlug2   = strtolower($request['accountSlug2']);
                    $slug2          = strtolower($request['slug2']);
                    $label          = $request['label'];
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_updateFromVersion($accountSlug1, $slug1, $accountSlug2, $slug2, $label, $files, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );


 /**
 * Get canonical version of a package and store it in local filesystem.
 * API : GET /packages/{accountSlug}/{slug}/canonical/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/canonical/documents', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_canonicalDownload($accountSlug, $slug, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Update draft from version document.
 * API : PUT /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/canonical/documents', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->put_updateFromCanonical($accountSlug1, $slug1, $accountSlug2, $slug2, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Clone version of a package on local file system .
 * API : POST /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/canonical/documents/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/canonical/documents', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $ItineraryRoute = new ItineraryRoute();
                    $body         = $request->get_body();
                    $body         = json_decode($body, true);
                    $packageTitle = null;
                    if(isset($body['title'])) {
                      $packageTitle = $body['title'];
                    }
                    $packageJptf    = $ItineraryRoute->post_canonicalClone($accountSlug1, $slug1, $accountSlug2, $slug2, $packageTitle, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );

 /**
 * Compare Canonical version of a document.
 * API : GET /packages/{accountSlug1}/{slug1}/update/{accountSlug2}/{slug2}/cannonical/documents/{document}/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)/canonical/documents/(?P<document>[a-z0-9.%/|*_-]+)', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new \Exception('{ "status_code":"500", "message":"No Session key defined in request header." }');
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug1 = strtolower($request['accountSlug1']);
                    $slug1        = strtolower($request['slug1']);
                    $accountSlug2 = strtolower($request['accountSlug2']);
                    $slug2        = strtolower($request['slug2']);
                    $filePath     = $request['document'];
                    $filePath     = urldecode(urldecode($filePath));
                    $filePath     = ltrim(str_replace('*', '/', $filePath), '/');
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_compareFileWithCanonical($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $sessionKey);
                    return $packageJptf;
                }
                catch (\Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 );


/********************************************************************************
 ********************* Publication endpoints *************************************
 ********************************************************************************/
 
/**
 * Get a package publication.
 * API : GET /packages/{accountSlug}/{slug}/publications/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/publications', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new Exception("No Session key defined in request header");
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_publication($accountSlug, $slug, $sessionKey);
                    return $packageJptf;
                }
                catch (Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 ); 
 
 
/**
 * Get package version bundles.
 * API : GET /packages/{accountSlug}/{slug}/versionbundles/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/versionbundles', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new Exception("No Session key defined in request header");
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }            
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->get_versionBundles($accountSlug, $slug, $sessionKey);
                    return $packageJptf;
                }
                catch (Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 ); 
 
/**
 * Update package publication.
 * API : PUT /packages/{accountSlug}/{slug}/publications/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/publications', array(
            'methods' => 'PUT',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new Exception("No Session key defined in request header");
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    } 
                    $body            = $request->get_body();
                    $body            = json_decode($body, true);
                    $commit = null;
                    if(null !== $request['commit']) {
                       $commit = $request['commit'];
                    }
                    $accountSlug     = strtolower($request['accountSlug']);
                    $slug            = strtolower($request['slug']);
                    $ItineraryRoute  = new ItineraryRoute();
                    $publicationInfo = $ItineraryRoute->put_publications($accountSlug, $slug, $commit, $body, $sessionKey);
                    return $publicationInfo;
                }
                catch (Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    if (isset($error['status_code']) && isset($error['message'])) {
                        return new WP_Error($error['status_code'], $error['message'], "");
                    } else if(isset($error['status_code']) && isset($error['publication'])) {
                        return new WP_Error($error['status_code'], "", $error);
                    } else if(isset($error['status_code']) && isset($error['error'])) {
                        return new WP_Error($error['status_code'], "", $error['error']);
                    }
                }
            }
            )
        );
     }
 ); 
  
 /**
 * Update package publication validations.
 * API : POST /packages/{accountSlug}/{slug}/publicationvalidations/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/publicationvalidations', array(
            'methods' => 'POST',
            'callback' => function ($request) {
                try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new Exception("No Session key defined in request header");
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    } 
                    $body        = $request->get_body();
                    $body        = json_decode($body, true);
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageJptf    = $ItineraryRoute->post_validatePublication($accountSlug, $slug, $sessionKey, $body);
                    return $packageJptf;
                }
                catch (Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['status_code'], $error['message'], "");
                }
            }
            )
        );
     }
 ); 

 /**
 * Get blended host menu pages
 * API : GET /host/endpoints/{endPointName}
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/host/endpoints/(?P<endPointName>[a-z0-9_\-]+)/', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                 try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new Exception(json_encode(array("code" => 500, "message" => 'No session key defined in request header')));
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    }           
                    $endPointName   = $request['endPointName'];
                    $url    = blendedAppUrl($endPointName);
                    return $url;
                }
                catch (Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['code'], $error['message'], "");
                }
            }
            )
        );
     }
 ); 

 /**
 * Get current package hash of local package.
 * API : GET /{accountSlug}/{slug}/currenthash/
 */
 add_action(
     'rest_api_init', function () {
        global $NAMESPACE;
        register_rest_route(
            $NAMESPACE, '/packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/currenthash/', array(
            'methods' => 'GET',
            'callback' => function ($request) {
                 try {
                    $headers = $request->get_headers();
                    if (!isset($headers['sessionkey'])) {
                        throw new Exception("No Session key defined in request header");
                    } else {
                        $sessionKey = $headers['sessionkey'];
                        $sessionKey = $sessionKey[0];
                    } 
                    $accountSlug = strtolower($request['accountSlug']);
                    $slug        = strtolower($request['slug']);
                    $ItineraryRoute = new ItineraryRoute();
                    $packageHash    = $ItineraryRoute->get_currenthash($accountSlug, $slug, $sessionKey);
                    return $packageHash;
                }
                catch (Exception $e) {
                    $error = json_decode($e->getMessage(), true);
                    return new WP_Error($error['code'], $error['message'], "");
                }
            }
            )
        );
     }
 );