<?php

/**
 * Blended Theme
 *
 * @author   Blended
 * @package  blended_fw
 * @version  1.0.0
 */

use Blended\Orm\Draft;
use Blended\Orm\Package;
use Blended\Orm\File;
use Blended\Orm\Version;
use Blended\Orm\Content;
use Doctrine\ORM\EntityManager;
use Doctrine\Common\Collections\ArrayCollection;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


# Header definition for React app.
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept');


//Define Theme Constants
define('REACT_URI', '//stgcdn.blended.co/app/blended_v0.3.2-rc010');
define('HUB_URI', 'https://stgqahub.blended.co');
define('REACT_CDN', '//maxcdn.bootstrapcdn.com');
define('REACT_JQUERY', '//ajax.googleapis.com');
define('BD_PATH', get_template_directory());

if (!(defined('DISALLOW_FILE_EDIT')))
    define('DISALLOW_FILE_EDIT', true);

//Load Blended Packages and Theme Framework
if (file_exists($hostlib_autoload = BD_PATH . '/hostlib/vendor/autoload.php') && file_exists($lang_autoload = BD_PATH . '/blended-php/vendor/autoload.php')
) {
    require_once $hostlib_autoload;
    require_once $lang_autoload;
    require_once( BD_PATH . '/inc/class-blended-fw.php' );
}

if (file_exists($hostlib_autoload = BD_PATH . '/orm/bootstrap.php')) {
    require_once( BD_PATH . '/orm/bootstrap.php' );
}

//Instantiate Blended Theme Framework
if (function_exists("BD"))
    BD();
