# Swagger\Client\PackagesApi

All URIs are relative to *https://stgqahub.blended.co/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**acceptAcquisition**](PackagesApi.md#acceptAcquisition) | **PUT** /packages/{accountSlug}/{slug}/acquisitions/ | API to accept package.
[**acquirePackage**](PackagesApi.md#acquirePackage) | **POST** /packages/{accountSlug}/{slug}/acquisitions/ | API to acquire package between accounts.
[**addLicense**](PackagesApi.md#addLicense) | **POST** /packages/{accountSlug}/{slug}/versions/{label}/licenses/ | Add a license to package.
[**addLike**](PackagesApi.md#addLike) | **POST** /packages/{accountSlug}/{slug}/likes/ | Add a like to a package.
[**addRating**](PackagesApi.md#addRating) | **POST** /packages/{accountSlug}/{slug}/ratings/ | Add a rating to a package.
[**canonicalSet**](PackagesApi.md#canonicalSet) | **PUT** /packages/{accountSlug}/{slug}/canonical/ | Get package draft.
[**createDraft**](PackagesApi.md#createDraft) | **POST** /packages/{accountSlug}/{slug}/draft/documents/ | Create package draft.
[**createPackage**](PackagesApi.md#createPackage) | **POST** /packages/{accountSlug}/ | Create Package.
[**download**](PackagesApi.md#download) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/documents/ | get version documents
[**downloadCanonical**](PackagesApi.md#downloadCanonical) | **GET** /packages/{accountSlug}/{slug}/canonical/documents/ | API used to Download a package.
[**downloadDraft**](PackagesApi.md#downloadDraft) | **GET** /packages/{accountSlug}/{slug}/draft/documents/ | Download package draft.
[**getAcquiredPackageAccountList**](PackagesApi.md#getAcquiredPackageAccountList) | **GET** /packages/{accountSlug}/{slug}/acquisitions/ | API to acquire package between accounts.
[**getCanonical**](PackagesApi.md#getCanonical) | **GET** /packages/{accountSlug}/{slug}/canonical/ | Get detail view of canonical version of a package.
[**getDependencies**](PackagesApi.md#getDependencies) | **GET** /packages/{accountSlug}/{slug}/dependencies/ | Return package dependencies.
[**getDetailDocument**](PackagesApi.md#getDetailDocument) | **GET** /packages/{accountSlug}/{slug}/draft/documents/{name}/ | Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)
[**getDraft**](PackagesApi.md#getDraft) | **GET** /packages/{accountSlug}/{slug}/draft/ | Get package draft.
[**getLicenses**](PackagesApi.md#getLicenses) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/licenses/ | Get list of licenses associated with package.
[**getPackageDetails**](PackagesApi.md#getPackageDetails) | **GET** /packages/{accountSlug}/{slug}/ | Package Detail view.
[**getPackageInitial**](PackagesApi.md#getPackageInitial) | **GET** /packages/initial/ | Packages initial
[**getPackages**](PackagesApi.md#getPackages) | **GET** /packages/{accountSlug}/ | Packages.
[**getPublication**](PackagesApi.md#getPublication) | **GET** /packages/{accountSlug}/{slug}/publications/ | API used to get a package publication.
[**getRatingDetails**](PackagesApi.md#getRatingDetails) | **GET** /packages/{accountSlug}/{slug}/ratingdetails/ | Get Details of package rating submitted by any user.
[**getRatings**](PackagesApi.md#getRatings) | **GET** /packages/{accountSlug}/{slug}/ratings/ | Returns list of ratings submitted by users for a package.
[**getVersionBundles**](PackagesApi.md#getVersionBundles) | **GET** /packages/{accountSlug}/{slug}/versionbundles/ | API used to get a package publication.
[**getVersionDetails**](PackagesApi.md#getVersionDetails) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/ | get version data of a package in details.
[**getVersions**](PackagesApi.md#getVersions) | **GET** /packages/{accountSlug}/{slug}/versions/ | return the list of package version
[**getlike**](PackagesApi.md#getlike) | **GET** /packages/{accountSlug}/{slug}/likes/ | Returns like submitted by users for a package.
[**packageAccountList**](PackagesApi.md#packageAccountList) | **GET** /packages/{accountSlug}/{slug}/accounts/ | Returns list of users.
[**rejectAcquisitionInvite**](PackagesApi.md#rejectAcquisitionInvite) | **PUT** /packages/{accountSlug}/{slug}/reject/ | API to acquire package between accounts.
[**removeLicense**](PackagesApi.md#removeLicense) | **DELETE** /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/ | delete a package license.
[**removeLike**](PackagesApi.md#removeLike) | **DELETE** /packages/{accountSlug}/{slug}/likes/ | delete a package like.
[**resendInvite**](PackagesApi.md#resendInvite) | **POST** /packages/{accountSlug}/{slug}/resend/invite/ | API to acquire package between accounts.
[**revokeAcquiredPackage**](PackagesApi.md#revokeAcquiredPackage) | **DELETE** /packages/{accountSlug}/{slug}/acquisitions/ | API to acquire package between accounts.
[**search**](PackagesApi.md#search) | **GET** /search/ | Search Packages.
[**snapshot**](PackagesApi.md#snapshot) | **POST** /packages/{accountSlug}/{slug}/versions/ | Create a snapshot of a package.
[**updateDraft**](PackagesApi.md#updateDraft) | **PUT** /packages/{accountSlug}/{slug}/draft/documents/ | Update package draft.
[**updateLicense**](PackagesApi.md#updateLicense) | **PUT** /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/ | Update price of package license.
[**updatePackage**](PackagesApi.md#updatePackage) | **PUT** /packages/{accountSlug}/{slug}/ | Update Package.
[**updatePublication**](PackagesApi.md#updatePublication) | **PUT** /packages/{accountSlug}/{slug}/publications/ | API used to update package publication.
[**updateRating**](PackagesApi.md#updateRating) | **PUT** /packages/{accountSlug}/{slug}/ratingdetails/ | Update rating of package.
[**uploadMedia**](PackagesApi.md#uploadMedia) | **POST** /packages/{accountSlug}/{slug}/media/ | Upload a media file to package&#39;s draft
[**validatePublication**](PackagesApi.md#validatePublication) | **POST** /packages/{accountSlug}/{slug}/publicationvalidations/ | Validate publication object


# **acceptAcquisition**
> acceptAcquisition($account_slug, $slug, $sessionkey, $body)

API to accept package.

To share,transfer, get, buy, extend and clone a package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | account slug used to uniquely identify a package.
$slug = "slug_example"; // string | package slug used to uniquely identify a package.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\Body(); // \Swagger\Client\Model\Body | request data used to acquire package.

try {
    $api_instance->acceptAcquisition($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->acceptAcquisition: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| account slug used to uniquely identify a package. |
 **slug** | **string**| package slug used to uniquely identify a package. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\Body**](../Model/\Swagger\Client\Model\Body.md)| request data used to acquire package. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **acquirePackage**
> \Swagger\Client\Model\BlendedPackage acquirePackage($account_slug, $slug, $sessionkey, $body)

API to acquire package between accounts.

To share,transfer, get, buy, extend and clone a package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | accounts slug
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\Acquisition(); // \Swagger\Client\Model\Acquisition | request data used to acquire package.

try {
    $result = $api_instance->acquirePackage($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->acquirePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accounts slug |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\Acquisition**](../Model/\Swagger\Client\Model\Acquisition.md)| request data used to acquire package. |

### Return type

[**\Swagger\Client\Model\BlendedPackage**](../Model/BlendedPackage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addLicense**
> addLicense($account_slug, $slug, $label, $sessionkey, $body)

Add a license to package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | label for the version
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddLicense(); // \Swagger\Client\Model\AddLicense | request data used to add package license.

try {
    $api_instance->addLicense($account_slug, $slug, $label, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->addLicense: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| label for the version |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\AddLicense**](../Model/\Swagger\Client\Model\AddLicense.md)| request data used to add package license. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addLike**
> addLike($account_slug, $slug, $sessionkey)

Add a like to a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $api_instance->addLike($account_slug, $slug, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->addLike: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addRating**
> addRating($account_slug, $slug, $sessionkey, $body)

Add a rating to a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddRating(); // \Swagger\Client\Model\AddRating | request data used to add package rating.

try {
    $api_instance->addRating($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->addRating: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\AddRating**](../Model/\Swagger\Client\Model\AddRating.md)| request data used to add package rating. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **canonicalSet**
> canonicalSet($account_slug, $slug, $sessionkey, $body)

Get package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | accountSlug
$slug = "slug_example"; // string | package slug used to uniquely identify a package.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\CreateCanonical(); // \Swagger\Client\Model\CreateCanonical | request data used to update package.

try {
    $api_instance->canonicalSet($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->canonicalSet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accountSlug |
 **slug** | **string**| package slug used to uniquely identify a package. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\CreateCanonical**](../Model/\Swagger\Client\Model\CreateCanonical.md)| request data used to update package. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createDraft**
> \Swagger\Client\Model\NewDraft createDraft($account_slug, $slug, $sessionkey, $body)

Create package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\UpdateDraft(); // \Swagger\Client\Model\UpdateDraft | request data used to create package draft.

try {
    $result = $api_instance->createDraft($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->createDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\UpdateDraft**](../Model/\Swagger\Client\Model\UpdateDraft.md)| request data used to create package draft. |

### Return type

[**\Swagger\Client\Model\NewDraft**](../Model/NewDraft.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createPackage**
> \Swagger\Client\Model\BlendedPackage createPackage($account_slug, $sessionkey, $body, $verbose)

Create Package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\CreatePackage(); // \Swagger\Client\Model\CreatePackage | request data used to create package.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->createPackage($account_slug, $sessionkey, $body, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->createPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\CreatePackage**](../Model/\Swagger\Client\Model\CreatePackage.md)| request data used to create package. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\BlendedPackage**](../Model/BlendedPackage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **download**
> object[] download($account_slug, $slug, $label, $sessionkey, $as_hashes)

get version documents



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | value used to uniquely identify version.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$as_hashes = "as_hashes_example"; // string | value used to return only hashes

try {
    $result = $api_instance->download($account_slug, $slug, $label, $sessionkey, $as_hashes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->download: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| value used to uniquely identify version. |
 **sessionkey** | **string**| value used to manage user session. | [optional]
 **as_hashes** | **string**| value used to return only hashes | [optional]

### Return type

**object[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **downloadCanonical**
> object[] downloadCanonical($account_slug, $slug, $sessionkey)

API used to Download a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->downloadCanonical($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->downloadCanonical: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. | [optional]

### Return type

**object[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **downloadDraft**
> object[] downloadDraft($account_slug, $slug, $sessionkey, $as_hashes)

Download package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$as_hashes = "as_hashes_example"; // string | value used to return only hashes

try {
    $result = $api_instance->downloadDraft($account_slug, $slug, $sessionkey, $as_hashes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->downloadDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **as_hashes** | **string**| value used to return only hashes | [optional]

### Return type

**object[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAcquiredPackageAccountList**
> \Swagger\Client\Model\SharedPackageAccountsList getAcquiredPackageAccountList($account_slug, $slug, $sessionkey, $share)

API to acquire package between accounts.

To get list of account with whom package is shared with.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | accounts slug
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$share = "share_example"; // string | value used to pass query parameter 'share' in the url.

try {
    $result = $api_instance->getAcquiredPackageAccountList($account_slug, $slug, $sessionkey, $share);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getAcquiredPackageAccountList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accounts slug |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **share** | **string**| value used to pass query parameter &#39;share&#39; in the url. | [optional]

### Return type

[**\Swagger\Client\Model\SharedPackageAccountsList**](../Model/SharedPackageAccountsList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCanonical**
> \Swagger\Client\Model\CanonicalVersion getCanonical($account_slug, $slug, $sessionkey, $verbose)

Get detail view of canonical version of a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getCanonical($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getCanonical: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\CanonicalVersion**](../Model/CanonicalVersion.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDependencies**
> \Swagger\Client\Model\DependenciesList getDependencies($account_slug, $slug, $sessionkey, $verbose)

Return package dependencies.

Returns package dependencies.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getDependencies($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getDependencies: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\DependenciesList**](../Model/DependenciesList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDetailDocument**
> object[] getDetailDocument($account_slug, $slug, $name, $sessionkey)

Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$name = "name_example"; // string | path of the directory. Ex. - meta/config.css
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getDetailDocument($account_slug, $slug, $name, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getDetailDocument: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **name** | **string**| path of the directory. Ex. - meta/config.css |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

**object[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDraft**
> \Swagger\Client\Model\HyperLinkDraft getDraft($account_slug, $slug, $sessionkey)

Get package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getDraft($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\HyperLinkDraft**](../Model/HyperLinkDraft.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLicenses**
> \Swagger\Client\Model\HyperLinkLicenses getLicenses($account_slug, $slug, $label, $sessionkey)

Get list of licenses associated with package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | label for the version
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getLicenses($account_slug, $slug, $label, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getLicenses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| label for the version |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\HyperLinkLicenses**](../Model/HyperLinkLicenses.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackageDetails**
> \Swagger\Client\Model\BlendedPackage getPackageDetails($account_slug, $slug, $sessionkey, $verbose)

Package Detail view.

Returns a single package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getPackageDetails($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getPackageDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\BlendedPackage**](../Model/BlendedPackage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackageInitial**
> \Swagger\Client\Model\InitialPackages getPackageInitial()

Packages initial

default packages for any user (public packages available at initial time)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();

try {
    $result = $api_instance->getPackageInitial();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getPackageInitial: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\Swagger\Client\Model\InitialPackages**](../Model/InitialPackages.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackages**
> \Swagger\Client\Model\Packages getPackages($account_slug, $sessionkey, $verbose, $share, $snapshot, $dependency, $purchased, $transfer_by_me, $transfer_to_me, $published, $owned_by_account)

Packages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.
$share = "share_example"; // string | parameter to provide list of packages that are shared with current account.
$snapshot = "snapshot_example"; // string | parameter to provide list of packages that have snapshots with current account.
$dependency = "dependency_example"; // string | parameter to provide list of dependency packages of all packages of current account.
$purchased = "purchased_example"; // string | parameter to provide list of packages that are purchased (free or paid) in current account.
$transfer_by_me = "transfer_by_me_example"; // string | value used to pass query parameter 'transfer_by_me' in the url.
$transfer_to_me = "transfer_to_me_example"; // string | value used to pass query parameter 'transfer_to_me' in the url.
$published = "published_example"; // string | value used to pass query parameter 'published' in the url.
$owned_by_account = "owned_by_account_example"; // string | owner of packages on which you too have acquisition.

try {
    $result = $api_instance->getPackages($account_slug, $sessionkey, $verbose, $share, $snapshot, $dependency, $purchased, $transfer_by_me, $transfer_to_me, $published, $owned_by_account);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getPackages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]
 **share** | **string**| parameter to provide list of packages that are shared with current account. | [optional]
 **snapshot** | **string**| parameter to provide list of packages that have snapshots with current account. | [optional]
 **dependency** | **string**| parameter to provide list of dependency packages of all packages of current account. | [optional]
 **purchased** | **string**| parameter to provide list of packages that are purchased (free or paid) in current account. | [optional]
 **transfer_by_me** | **string**| value used to pass query parameter &#39;transfer_by_me&#39; in the url. | [optional]
 **transfer_to_me** | **string**| value used to pass query parameter &#39;transfer_to_me&#39; in the url. | [optional]
 **published** | **string**| value used to pass query parameter &#39;published&#39; in the url. | [optional]
 **owned_by_account** | **string**| owner of packages on which you too have acquisition. | [optional]

### Return type

[**\Swagger\Client\Model\Packages**](../Model/Packages.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPublication**
> \Swagger\Client\Model\Publications getPublication($account_slug, $slug, $sessionkey)

API used to get a package publication.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getPublication($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getPublication: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. | [optional]

### Return type

[**\Swagger\Client\Model\Publications**](../Model/Publications.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRatingDetails**
> \Swagger\Client\Model\Rating getRatingDetails($account_slug, $slug, $sessionkey, $verbose)

Get Details of package rating submitted by any user.

Returns package rating details.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getRatingDetails($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getRatingDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Rating**](../Model/Rating.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRatings**
> \Swagger\Client\Model\HyperLinkRatings getRatings($account_slug, $slug, $sessionkey, $verbose)

Returns list of ratings submitted by users for a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getRatings($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getRatings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\HyperLinkRatings**](../Model/HyperLinkRatings.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVersionBundles**
> \Swagger\Client\Model\PublicationVersions getVersionBundles($account_slug, $slug, $sessionkey)

API used to get a package publication.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getVersionBundles($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getVersionBundles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. | [optional]

### Return type

[**\Swagger\Client\Model\PublicationVersions**](../Model/PublicationVersions.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVersionDetails**
> \Swagger\Client\Model\Version getVersionDetails($account_slug, $slug, $label, $sessionkey)

get version data of a package in details.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | value used to uniquely identify version.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getVersionDetails($account_slug, $slug, $label, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getVersionDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| value used to uniquely identify version. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\Version**](../Model/Version.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVersions**
> \Swagger\Client\Model\Versions getVersions($account_slug, $slug, $sessionkey)

return the list of package version



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getVersions($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getVersions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\Versions**](../Model/Versions.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getlike**
> \Swagger\Client\Model\Like getlike($account_slug, $slug, $sessionkey)

Returns like submitted by users for a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getlike($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getlike: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\Like**](../Model/Like.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **packageAccountList**
> \Swagger\Client\Model\Users packageAccountList($account_slug, $slug, $sessionkey)

Returns list of users.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->packageAccountList($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->packageAccountList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\Users**](../Model/Users.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **rejectAcquisitionInvite**
> rejectAcquisitionInvite($account_slug, $slug, $sessionkey, $body)

API to acquire package between accounts.

to resend email invite link for given acquisition type to other account

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | accounts slug
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\RejectAcquisitionPackage(); // \Swagger\Client\Model\RejectAcquisitionPackage | request data used to acquire package.

try {
    $api_instance->rejectAcquisitionInvite($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->rejectAcquisitionInvite: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accounts slug |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\RejectAcquisitionPackage**](../Model/\Swagger\Client\Model\RejectAcquisitionPackage.md)| request data used to acquire package. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removeLicense**
> removeLicense($account_slug, $slug, $label, $name, $sessionkey)

delete a package license.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | label for the version
$name = "name_example"; // string | name of the license
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $api_instance->removeLicense($account_slug, $slug, $label, $name, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->removeLicense: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| label for the version |
 **name** | **string**| name of the license |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removeLike**
> removeLike($account_slug, $slug, $sessionkey)

delete a package like.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $api_instance->removeLike($account_slug, $slug, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->removeLike: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **resendInvite**
> \Swagger\Client\Model\BlendedPackage resendInvite($account_slug, $slug, $sessionkey, $body)

API to acquire package between accounts.

to resend email invite link for given acquisition type to other account

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | accounts slug
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\ResendInvite(); // \Swagger\Client\Model\ResendInvite | request data used to acquire package.

try {
    $result = $api_instance->resendInvite($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->resendInvite: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accounts slug |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\ResendInvite**](../Model/\Swagger\Client\Model\ResendInvite.md)| request data used to acquire package. |

### Return type

[**\Swagger\Client\Model\BlendedPackage**](../Model/BlendedPackage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **revokeAcquiredPackage**
> \Swagger\Client\Model\BlendedPackage revokeAcquiredPackage($account_slug, $slug, $sessionkey, $body)

API to acquire package between accounts.

To revoke share a package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | accounts slug
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\Acquisition(); // \Swagger\Client\Model\Acquisition | request data used to acquire package.

try {
    $result = $api_instance->revokeAcquiredPackage($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->revokeAcquiredPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accounts slug |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\Acquisition**](../Model/\Swagger\Client\Model\Acquisition.md)| request data used to acquire package. |

### Return type

[**\Swagger\Client\Model\BlendedPackage**](../Model/BlendedPackage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **search**
> \Swagger\Client\Model\SearchResults search($filter_by, $order_by, $page)

Search Packages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$filter_by = "filter_by_example"; // string | filter by parameters.
$order_by = "order_by_example"; // string | to order package display.
$page = 56; // int | page to display.

try {
    $result = $api_instance->search($filter_by, $order_by, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->search: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **filter_by** | **string**| filter by parameters. | [optional]
 **order_by** | **string**| to order package display. | [optional]
 **page** | **int**| page to display. | [optional]

### Return type

[**\Swagger\Client\Model\SearchResults**](../Model/SearchResults.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **snapshot**
> \Swagger\Client\Model\Version snapshot($account_slug, $slug, $sessionkey, $body)

Create a snapshot of a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\CreateVersion(); // \Swagger\Client\Model\CreateVersion | request data used to snapshot package.

try {
    $result = $api_instance->snapshot($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->snapshot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\CreateVersion**](../Model/\Swagger\Client\Model\CreateVersion.md)| request data used to snapshot package. |

### Return type

[**\Swagger\Client\Model\Version**](../Model/Version.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateDraft**
> \Swagger\Client\Model\NewDraft updateDraft($account_slug, $slug, $sessionkey, $body)

Update package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\UpdateDraft(); // \Swagger\Client\Model\UpdateDraft | request data used to update package draft.

try {
    $result = $api_instance->updateDraft($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updateDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\UpdateDraft**](../Model/\Swagger\Client\Model\UpdateDraft.md)| request data used to update package draft. |

### Return type

[**\Swagger\Client\Model\NewDraft**](../Model/NewDraft.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateLicense**
> updateLicense($account_slug, $slug, $label, $name, $sessionkey, $body)

Update price of package license.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | label for the version
$name = "name_example"; // string | name of the license
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\UpdateLicense(); // \Swagger\Client\Model\UpdateLicense | request data used to update license price.

try {
    $api_instance->updateLicense($account_slug, $slug, $label, $name, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updateLicense: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| label for the version |
 **name** | **string**| name of the license |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\UpdateLicense**](../Model/\Swagger\Client\Model\UpdateLicense.md)| request data used to update license price. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updatePackage**
> updatePackage($account_slug, $slug, $sessionkey, $body)

Update Package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\UpdatePackage(); // \Swagger\Client\Model\UpdatePackage | request data used to update package.

try {
    $api_instance->updatePackage($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updatePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\UpdatePackage**](../Model/\Swagger\Client\Model\UpdatePackage.md)| request data used to update package. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updatePublication**
> object updatePublication($account_slug, $slug, $body, $sessionkey, $commit)

API used to update package publication.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$body = new \Swagger\Client\Model\UpdatePublication(); // \Swagger\Client\Model\UpdatePublication | request data used to update package.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$commit = "commit_example"; // string | passing '0' will just validated not update the publication while '1' will update the data too.

try {
    $result = $api_instance->updatePublication($account_slug, $slug, $body, $sessionkey, $commit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updatePublication: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **body** | [**\Swagger\Client\Model\UpdatePublication**](../Model/\Swagger\Client\Model\UpdatePublication.md)| request data used to update package. |
 **sessionkey** | **string**| value used to manage user session. | [optional]
 **commit** | **string**| passing &#39;0&#39; will just validated not update the publication while &#39;1&#39; will update the data too. | [optional]

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateRating**
> updateRating($account_slug, $slug, $sessionkey, $body)

Update rating of package.

API for user to update rating score.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddRating(); // \Swagger\Client\Model\AddRating | request data used to update rating.

try {
    $api_instance->updateRating($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updateRating: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\AddRating**](../Model/\Swagger\Client\Model\AddRating.md)| request data used to update rating. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **uploadMedia**
> \Swagger\Client\Model\InlineResponse200 uploadMedia($account_slug, $slug, $sessionkey, $hash_value, $name, $token, $image)

Upload a media file to package's draft



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$hash_value = "hash_value_example"; // string | 
$name = "name_example"; // string | 
$token = "token_example"; // string | 
$image = "/path/to/file.txt"; // \SplFileObject | media file

try {
    $result = $api_instance->uploadMedia($account_slug, $slug, $sessionkey, $hash_value, $name, $token, $image);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->uploadMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **hash_value** | **string**|  |
 **name** | **string**|  | [optional]
 **token** | **string**|  | [optional]
 **image** | **\SplFileObject**| media file | [optional]

### Return type

[**\Swagger\Client\Model\InlineResponse200**](../Model/InlineResponse200.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **validatePublication**
> validatePublication($account_slug, $slug, $sessionkey, $body)

Validate publication object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\Body1(); // \Swagger\Client\Model\Body1 | request data used to add package rating.

try {
    $api_instance->validatePublication($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->validatePublication: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\Body1**](../Model/\Swagger\Client\Model\Body1.md)| request data used to add package rating. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

