<?php
/**
 * AccountsApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

use \Swagger\Client\Configuration;
use \Swagger\Client\ApiClient;
use \Swagger\Client\ApiException;
use \Swagger\Client\ObjectSerializer;

/**
 * AccountsApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class AccountsApi
{

    /**
     * API Client
     *
     * @var \Swagger\Client\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Swagger\Client\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Swagger\Client\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://stgqahub.blended.co/v0');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Swagger\Client\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Swagger\Client\ApiClient $apiClient set the API client
     *
     * @return AccountsApi
     */
    public function setApiClient(\Swagger\Client\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation addAccountAdmin
     *
     * Add a admin user into account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddAdmin $body the content of the request used to add admin into account. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function addAccountAdmin($slug, $sessionkey, $body)
    {
        list($response) = $this->addAccountAdminWithHttpInfo($slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation addAccountAdminWithHttpInfo
     *
     * Add a admin user into account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddAdmin $body the content of the request used to add admin into account. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function addAccountAdminWithHttpInfo($slug, $sessionkey, $body)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling addAccountAdmin');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling addAccountAdmin');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling addAccountAdmin');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/admins/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/admins/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation addAccountUser
     *
     * Add a regular user into account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddAdmin $body the content of the request used to add admin into account. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function addAccountUser($slug, $sessionkey, $body)
    {
        list($response) = $this->addAccountUserWithHttpInfo($slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation addAccountUserWithHttpInfo
     *
     * Add a regular user into account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\AddAdmin $body the content of the request used to add admin into account. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function addAccountUserWithHttpInfo($slug, $sessionkey, $body)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling addAccountUser');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling addAccountUser');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling addAccountUser');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/users/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/users/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation changeAccountUserPrivilege
     *
     * account Regular user.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $user_slug user account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\ChangePrivilege $body the content of the request used to add admin into account. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function changeAccountUserPrivilege($slug, $user_slug, $sessionkey, $body)
    {
        list($response) = $this->changeAccountUserPrivilegeWithHttpInfo($slug, $user_slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation changeAccountUserPrivilegeWithHttpInfo
     *
     * account Regular user.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $user_slug user account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\ChangePrivilege $body the content of the request used to add admin into account. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function changeAccountUserPrivilegeWithHttpInfo($slug, $user_slug, $sessionkey, $body)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling changeAccountUserPrivilege');
        }
        // verify the required parameter 'user_slug' is set
        if ($user_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_slug when calling changeAccountUserPrivilege');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling changeAccountUserPrivilege');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling changeAccountUserPrivilege');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/users/{user_slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($user_slug !== null) {
            $resourcePath = str_replace(
                "{" . "user_slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($user_slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/users/{user_slug}/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createAccount
     *
     * Create a new user account.
     *
     * @param \Swagger\Client\Model\CreateAccount $body the content of the request used to create user account. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\User
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function createAccount($body, $verbose = null)
    {
        list($response) = $this->createAccountWithHttpInfo($body, $verbose);
        return $response;
    }

    /**
     * Operation createAccountWithHttpInfo
     *
     * Create a new user account.
     *
     * @param \Swagger\Client\Model\CreateAccount $body the content of the request used to create user account. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\User, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function createAccountWithHttpInfo($body, $verbose = null)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createAccount');
        }
        // parse inputs
        $resourcePath = "/accounts/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\User',
                '/accounts/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\User', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\User', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountAdmin
     *
     * Get account Admin.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $admin_slug admin account unique indentifier. (required)
     * @param string $sessionkey user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\User
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountAdmin($slug, $admin_slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getAccountAdminWithHttpInfo($slug, $admin_slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getAccountAdminWithHttpInfo
     *
     * Get account Admin.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $admin_slug admin account unique indentifier. (required)
     * @param string $sessionkey user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\User, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountAdminWithHttpInfo($slug, $admin_slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getAccountAdmin');
        }
        // verify the required parameter 'admin_slug' is set
        if ($admin_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $admin_slug when calling getAccountAdmin');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getAccountAdmin');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/admins/{admin_slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($admin_slug !== null) {
            $resourcePath = str_replace(
                "{" . "admin_slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($admin_slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\User',
                '/accounts/{slug}/admins/{admin_slug}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\User', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\User', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountAdmins
     *
     * get admin users of account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\Users
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountAdmins($slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getAccountAdminsWithHttpInfo($slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getAccountAdminsWithHttpInfo
     *
     * get admin users of account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\Users, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountAdminsWithHttpInfo($slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getAccountAdmins');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getAccountAdmins');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/admins/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Users',
                '/accounts/{slug}/admins/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Users', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Users', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountDetails
     *
     * Detail View of user account.
     *
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param string $sessionkey account session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\User
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountDetails($slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getAccountDetailsWithHttpInfo($slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getAccountDetailsWithHttpInfo
     *
     * Detail View of user account.
     *
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param string $sessionkey account session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\User, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountDetailsWithHttpInfo($slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getAccountDetails');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getAccountDetails');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\User',
                '/accounts/{slug}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\User', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\User', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountInvitesPendingList
     *
     * To get the List of all accounts who invite the user and request is pending to accept or reject.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return \Swagger\Client\Model\AccountInvitesPendingList
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountInvitesPendingList($slug, $sessionkey)
    {
        list($response) = $this->getAccountInvitesPendingListWithHttpInfo($slug, $sessionkey);
        return $response;
    }

    /**
     * Operation getAccountInvitesPendingListWithHttpInfo
     *
     * To get the List of all accounts who invite the user and request is pending to accept or reject.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of \Swagger\Client\Model\AccountInvitesPendingList, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountInvitesPendingListWithHttpInfo($slug, $sessionkey)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getAccountInvitesPendingList');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getAccountInvitesPendingList');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/accountpendings/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\AccountInvitesPendingList',
                '/accounts/{slug}/accountpendings/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\AccountInvitesPendingList', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\AccountInvitesPendingList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountList
     *
     * Returns all accounts from the system that the user has access to.
     *
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\Accounts
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountList($sessionkey, $slug, $verbose = null)
    {
        list($response) = $this->getAccountListWithHttpInfo($sessionkey, $slug, $verbose);
        return $response;
    }

    /**
     * Operation getAccountListWithHttpInfo
     *
     * Returns all accounts from the system that the user has access to.
     *
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\Accounts, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountListWithHttpInfo($sessionkey, $slug, $verbose = null)
    {
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getAccountList');
        }
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getAccountList');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/accounts/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Accounts',
                '/accounts/{slug}/accounts/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Accounts', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Accounts', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountUser
     *
     * account Regular user.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $user_slug user account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\User
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountUser($slug, $user_slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getAccountUserWithHttpInfo($slug, $user_slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getAccountUserWithHttpInfo
     *
     * account Regular user.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $user_slug user account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\User, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountUserWithHttpInfo($slug, $user_slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getAccountUser');
        }
        // verify the required parameter 'user_slug' is set
        if ($user_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_slug when calling getAccountUser');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getAccountUser');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/users/{user_slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($user_slug !== null) {
            $resourcePath = str_replace(
                "{" . "user_slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($user_slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\User',
                '/accounts/{slug}/users/{user_slug}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\User', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\User', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountUsers
     *
     * get Regular Users of account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\Users
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountUsers($slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getAccountUsersWithHttpInfo($slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getAccountUsersWithHttpInfo
     *
     * get Regular Users of account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\Users, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getAccountUsersWithHttpInfo($slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getAccountUsers');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getAccountUsers');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/users/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Users',
                '/accounts/{slug}/users/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Users', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Users', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCurrentAccount
     *
     * Get current user account.
     *
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\Account
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getCurrentAccount($slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getCurrentAccountWithHttpInfo($slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getCurrentAccountWithHttpInfo
     *
     * Get current user account.
     *
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\Account, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getCurrentAccountWithHttpInfo($slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getCurrentAccount');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getCurrentAccount');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/current/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Account',
                '/accounts/{slug}/current/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Account', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Account', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPendingUsers
     *
     * Get list of user's account pending users.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return \Swagger\Client\Model\PendingUsers
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPendingUsers($slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->getPendingUsersWithHttpInfo($slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation getPendingUsersWithHttpInfo
     *
     * Get list of user's account pending users.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of \Swagger\Client\Model\PendingUsers, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function getPendingUsersWithHttpInfo($slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling getPendingUsers');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling getPendingUsers');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/pendings/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\PendingUsers',
                '/accounts/{slug}/pendings/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\PendingUsers', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\PendingUsers', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation inviteUser
     *
     * Invite user to join account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey user session. (required)
     * @param \Swagger\Client\Model\AddPending $body the content of the request used to add admin into user account. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function inviteUser($slug, $sessionkey, $body)
    {
        list($response) = $this->inviteUserWithHttpInfo($slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation inviteUserWithHttpInfo
     *
     * Invite user to join account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey user session. (required)
     * @param \Swagger\Client\Model\AddPending $body the content of the request used to add admin into user account. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function inviteUserWithHttpInfo($slug, $sessionkey, $body)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling inviteUser');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling inviteUser');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling inviteUser');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/pendings/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/pendings/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation leaveAccount
     *
     * Returns all accounts from the system that the user has access to.
     *
     * @param string $slug unique value account slug which user wants to leave. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function leaveAccount($slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->leaveAccountWithHttpInfo($slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation leaveAccountWithHttpInfo
     *
     * Returns all accounts from the system that the user has access to.
     *
     * @param string $slug unique value account slug which user wants to leave. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function leaveAccountWithHttpInfo($slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling leaveAccount');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling leaveAccount');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/accounts/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/accounts/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation login
     *
     * Logs user account into the system.
     *
     * @param \Swagger\Client\Model\Login $body The request data used to login. (required)
     * @return \Swagger\Client\Model\SessionData
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function login($body)
    {
        list($response) = $this->loginWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation loginWithHttpInfo
     *
     * Logs user account into the system.
     *
     * @param \Swagger\Client\Model\Login $body The request data used to login. (required)
     * @return Array of \Swagger\Client\Model\SessionData, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function loginWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling login');
        }
        // parse inputs
        $resourcePath = "/login/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\SessionData',
                '/login/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\SessionData', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\SessionData', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation logout
     *
     * Logs out current logged in user account session.
     *
     * @param \Swagger\Client\Model\Logout $body The request data used to logout. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function logout($body)
    {
        list($response) = $this->logoutWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation logoutWithHttpInfo
     *
     * Logs out current logged in user account session.
     *
     * @param \Swagger\Client\Model\Logout $body The request data used to logout. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function logoutWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling logout');
        }
        // parse inputs
        $resourcePath = "/logout/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/logout/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation rejectUserInvite
     *
     * Reject User invitation of account.
     *
     * @param string $slug account unique indentifier from which logged in user got the invitation. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function rejectUserInvite($slug, $sessionkey, $verbose = null)
    {
        list($response) = $this->rejectUserInviteWithHttpInfo($slug, $sessionkey, $verbose);
        return $response;
    }

    /**
     * Operation rejectUserInviteWithHttpInfo
     *
     * Reject User invitation of account.
     *
     * @param string $slug account unique indentifier from which logged in user got the invitation. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param string $verbose parameter to provide detail view of hyperlink objects. (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function rejectUserInviteWithHttpInfo($slug, $sessionkey, $verbose = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling rejectUserInvite');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling rejectUserInvite');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/users/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($verbose !== null) {
            $queryParams['verbose'] = $this->apiClient->getSerializer()->toQueryValue($verbose);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/users/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation removeAccount
     *
     * Remove user Account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $account_slug specific account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removeAccount($slug, $account_slug, $sessionkey)
    {
        list($response) = $this->removeAccountWithHttpInfo($slug, $account_slug, $sessionkey);
        return $response;
    }

    /**
     * Operation removeAccountWithHttpInfo
     *
     * Remove user Account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $account_slug specific account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removeAccountWithHttpInfo($slug, $account_slug, $sessionkey)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling removeAccount');
        }
        // verify the required parameter 'account_slug' is set
        if ($account_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_slug when calling removeAccount');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling removeAccount');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/accounts/{account_slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($account_slug !== null) {
            $resourcePath = str_replace(
                "{" . "account_slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/accounts/{account_slug}/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation removeAccountAdmin
     *
     * deletes a admin user from account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $admin_slug admin account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removeAccountAdmin($slug, $admin_slug, $sessionkey)
    {
        list($response) = $this->removeAccountAdminWithHttpInfo($slug, $admin_slug, $sessionkey);
        return $response;
    }

    /**
     * Operation removeAccountAdminWithHttpInfo
     *
     * deletes a admin user from account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $admin_slug admin account unique indentifier. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removeAccountAdminWithHttpInfo($slug, $admin_slug, $sessionkey)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling removeAccountAdmin');
        }
        // verify the required parameter 'admin_slug' is set
        if ($admin_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $admin_slug when calling removeAccountAdmin');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling removeAccountAdmin');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/admins/{admin_slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($admin_slug !== null) {
            $resourcePath = str_replace(
                "{" . "admin_slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($admin_slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/admins/{admin_slug}/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation removeAccountUser
     *
     * Delete a regular user from account.
     *
     * @param string $slug account unique indentifier of account from which user needs to be removed. (required)
     * @param string $user_slug user account unique indentifier of user which needs to be removed. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removeAccountUser($slug, $user_slug, $sessionkey)
    {
        list($response) = $this->removeAccountUserWithHttpInfo($slug, $user_slug, $sessionkey);
        return $response;
    }

    /**
     * Operation removeAccountUserWithHttpInfo
     *
     * Delete a regular user from account.
     *
     * @param string $slug account unique indentifier of account from which user needs to be removed. (required)
     * @param string $user_slug user account unique indentifier of user which needs to be removed. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removeAccountUserWithHttpInfo($slug, $user_slug, $sessionkey)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling removeAccountUser');
        }
        // verify the required parameter 'user_slug' is set
        if ($user_slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_slug when calling removeAccountUser');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling removeAccountUser');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/users/{user_slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // path params
        if ($user_slug !== null) {
            $resourcePath = str_replace(
                "{" . "user_slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($user_slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/users/{user_slug}/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation removePendingInvitedUser
     *
     * Invite user to join account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey user session. (required)
     * @param \Swagger\Client\Model\RemovePending $body the content of the request used to add admin into user account. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removePendingInvitedUser($slug, $sessionkey, $body)
    {
        list($response) = $this->removePendingInvitedUserWithHttpInfo($slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation removePendingInvitedUserWithHttpInfo
     *
     * Invite user to join account.
     *
     * @param string $slug account unique indentifier. (required)
     * @param string $sessionkey user session. (required)
     * @param \Swagger\Client\Model\RemovePending $body the content of the request used to add admin into user account. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function removePendingInvitedUserWithHttpInfo($slug, $sessionkey, $body)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling removePendingInvitedUser');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling removePendingInvitedUser');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling removePendingInvitedUser');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/pendings/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/pendings/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation resendAccountVerificationEmail
     *
     * Resend Email Verification link to verifiy account if already not verified.
     *
     * @param string $sessionkey account session. (required)
     * @param \Swagger\Client\Model\ResendAccountVerificationLink $body request data used to resend link to user account. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function resendAccountVerificationEmail($sessionkey, $body)
    {
        list($response) = $this->resendAccountVerificationEmailWithHttpInfo($sessionkey, $body);
        return $response;
    }

    /**
     * Operation resendAccountVerificationEmailWithHttpInfo
     *
     * Resend Email Verification link to verifiy account if already not verified.
     *
     * @param string $sessionkey account session. (required)
     * @param \Swagger\Client\Model\ResendAccountVerificationLink $body request data used to resend link to user account. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function resendAccountVerificationEmailWithHttpInfo($sessionkey, $body)
    {
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling resendAccountVerificationEmail');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling resendAccountVerificationEmail');
        }
        // parse inputs
        $resourcePath = "/accounts/resend/emailverification/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/resend/emailverification/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation resetPassword
     *
     * Reset password of user account.
     *
     * @param \Swagger\Client\Model\ResetPassword $body The request data used to reset user account password. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function resetPassword($body)
    {
        list($response) = $this->resetPasswordWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation resetPasswordWithHttpInfo
     *
     * Reset password of user account.
     *
     * @param \Swagger\Client\Model\ResetPassword $body The request data used to reset user account password. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function resetPasswordWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling resetPassword');
        }
        // parse inputs
        $resourcePath = "/reset/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/reset/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation searchAccounts
     *
     * Search accounts by starting keywords of account name .
     *
     * @param string $sessionkey account session. (required)
     * @param string $pattern parameter to provide search accounts with passed starting keywords. (required)
     * @param int $account Needs to send 1 if you want matching accounts list. Default will be 0. (optional)
     * @param int $organization organization&#x3D;1 for organization only, organization&#x3D;0 for ~organization. Default will include all (optional)
     * @return \Swagger\Client\Model\Users
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function searchAccounts($sessionkey, $pattern, $account = null, $organization = null)
    {
        list($response) = $this->searchAccountsWithHttpInfo($sessionkey, $pattern, $account, $organization);
        return $response;
    }

    /**
     * Operation searchAccountsWithHttpInfo
     *
     * Search accounts by starting keywords of account name .
     *
     * @param string $sessionkey account session. (required)
     * @param string $pattern parameter to provide search accounts with passed starting keywords. (required)
     * @param int $account Needs to send 1 if you want matching accounts list. Default will be 0. (optional)
     * @param int $organization organization&#x3D;1 for organization only, organization&#x3D;0 for ~organization. Default will include all (optional)
     * @return Array of \Swagger\Client\Model\Users, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function searchAccountsWithHttpInfo($sessionkey, $pattern, $account = null, $organization = null)
    {
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling searchAccounts');
        }
        // verify the required parameter 'pattern' is set
        if ($pattern === null) {
            throw new \InvalidArgumentException('Missing the required parameter $pattern when calling searchAccounts');
        }
        // parse inputs
        $resourcePath = "/accounts/search/{pattern}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($account !== null) {
            $queryParams['account'] = $this->apiClient->getSerializer()->toQueryValue($account);
        }
        // query params
        if ($organization !== null) {
            $queryParams['organization'] = $this->apiClient->getSerializer()->toQueryValue($organization);
        }
        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($pattern !== null) {
            $resourcePath = str_replace(
                "{" . "pattern" . "}",
                $this->apiClient->getSerializer()->toPathValue($pattern),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\Users',
                '/accounts/search/{pattern}/'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\Users', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Users', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation setCurrentAccount
     *
     * Set user current account.
     *
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\ChangeCurrentAccount $body request data used to change current account. (required)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function setCurrentAccount($slug, $sessionkey, $body)
    {
        list($response) = $this->setCurrentAccountWithHttpInfo($slug, $sessionkey, $body);
        return $response;
    }

    /**
     * Operation setCurrentAccountWithHttpInfo
     *
     * Set user current account.
     *
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param string $sessionkey value used to manage user session. (required)
     * @param \Swagger\Client\Model\ChangeCurrentAccount $body request data used to change current account. (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function setCurrentAccountWithHttpInfo($slug, $sessionkey, $body)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling setCurrentAccount');
        }
        // verify the required parameter 'sessionkey' is set
        if ($sessionkey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $sessionkey when calling setCurrentAccount');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling setCurrentAccount');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/current/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/current/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateAccount
     *
     * Update User Account.
     *
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param \Swagger\Client\Model\UpdateAccount $body request data used to update user account. (required)
     * @param string $sessionkey user session. (optional)
     * @return void
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updateAccount($slug, $body, $sessionkey = null)
    {
        list($response) = $this->updateAccountWithHttpInfo($slug, $body, $sessionkey);
        return $response;
    }

    /**
     * Operation updateAccountWithHttpInfo
     *
     * Update User Account.
     *
     * @param string $slug unique value which will be used to fetch user account details. (required)
     * @param \Swagger\Client\Model\UpdateAccount $body request data used to update user account. (required)
     * @param string $sessionkey user session. (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \Swagger\Client\ApiException on non-2xx response
     */
    public function updateAccountWithHttpInfo($slug, $body, $sessionkey = null)
    {
        // verify the required parameter 'slug' is set
        if ($slug === null) {
            throw new \InvalidArgumentException('Missing the required parameter $slug when calling updateAccount');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updateAccount');
        }
        // parse inputs
        $resourcePath = "/accounts/{slug}/";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // header params
        if ($sessionkey !== null) {
            $headerParams['sessionkey'] = $this->apiClient->getSerializer()->toHeaderValue($sessionkey);
        }
        // path params
        if ($slug !== null) {
            $resourcePath = str_replace(
                "{" . "slug" . "}",
                $this->apiClient->getSerializer()->toPathValue($slug),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/accounts/{slug}/'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse400', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ErrorResponse500', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\Error', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
