<?php
/**
 * Acquisition
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * Acquisition Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Acquisition implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Acquisition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'label' => 'string',
        'account_name' => 'string',
        'new_package_slug' => 'string',
        'license_name' => 'string',
        'email' => 'string',
        'message' => 'string',
        'auto_share_packages' => 'string[]',
        'purchase_packages' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'label' => 'label',
        'account_name' => 'account_name',
        'new_package_slug' => 'new_package_slug',
        'license_name' => 'license_name',
        'email' => 'email',
        'message' => 'message',
        'auto_share_packages' => 'auto_share_packages',
        'purchase_packages' => 'purchase_packages'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'label' => 'setLabel',
        'account_name' => 'setAccountName',
        'new_package_slug' => 'setNewPackageSlug',
        'license_name' => 'setLicenseName',
        'email' => 'setEmail',
        'message' => 'setMessage',
        'auto_share_packages' => 'setAutoSharePackages',
        'purchase_packages' => 'setPurchasePackages'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'label' => 'getLabel',
        'account_name' => 'getAccountName',
        'new_package_slug' => 'getNewPackageSlug',
        'license_name' => 'getLicenseName',
        'email' => 'getEmail',
        'message' => 'getMessage',
        'auto_share_packages' => 'getAutoSharePackages',
        'purchase_packages' => 'getPurchasePackages'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['label'] = isset($data['label']) ? $data['label'] : null;
        $this->container['account_name'] = isset($data['account_name']) ? $data['account_name'] : null;
        $this->container['new_package_slug'] = isset($data['new_package_slug']) ? $data['new_package_slug'] : null;
        $this->container['license_name'] = isset($data['license_name']) ? $data['license_name'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
        $this->container['auto_share_packages'] = isset($data['auto_share_packages']) ? $data['auto_share_packages'] : null;
        $this->container['purchase_packages'] = isset($data['purchase_packages']) ? $data['purchase_packages'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['type'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Type of acquisition user is going to create.Example : share, get,buy,transfer,extend and clone.
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets label
     * @return string
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     * @param string $label version of the package for clone.
     * @return $this
     */
    public function setLabel($label)
    {
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets account_name
     * @return string
     */
    public function getAccountName()
    {
        return $this->container['account_name'];
    }

    /**
     * Sets account_name
     * @param string $account_name Name of the account where user wants to share or transfer package.
     * @return $this
     */
    public function setAccountName($account_name)
    {
        $this->container['account_name'] = $account_name;

        return $this;
    }

    /**
     * Gets new_package_slug
     * @return string
     */
    public function getNewPackageSlug()
    {
        return $this->container['new_package_slug'];
    }

    /**
     * Sets new_package_slug
     * @param string $new_package_slug new package name used in clone and extend package.
     * @return $this
     */
    public function setNewPackageSlug($new_package_slug)
    {
        $this->container['new_package_slug'] = $new_package_slug;

        return $this;
    }

    /**
     * Gets license_name
     * @return string
     */
    public function getLicenseName()
    {
        return $this->container['license_name'];
    }

    /**
     * Sets license_name
     * @param string $license_name Name of the license used to buy or get package.
     * @return $this
     */
    public function setLicenseName($license_name)
    {
        $this->container['license_name'] = $license_name;

        return $this;
    }

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     * @param string $email Email address for Inviting user via email.
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets message
     * @return string
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     * @param string $message Message will be send with the invite in the email.
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets auto_share_packages
     * @return string[]
     */
    public function getAutoSharePackages()
    {
        return $this->container['auto_share_packages'];
    }

    /**
     * Sets auto_share_packages
     * @param string[] $auto_share_packages list of dependency packages which needs to shared.
     * @return $this
     */
    public function setAutoSharePackages($auto_share_packages)
    {
        $this->container['auto_share_packages'] = $auto_share_packages;

        return $this;
    }

    /**
     * Gets purchase_packages
     * @return string[]
     */
    public function getPurchasePackages()
    {
        return $this->container['purchase_packages'];
    }

    /**
     * Sets purchase_packages
     * @param string[] $purchase_packages list of dependency packages which needs to purchases.
     * @return $this
     */
    public function setPurchasePackages($purchase_packages)
    {
        $this->container['purchase_packages'] = $purchase_packages;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


