<?php
/**
 * DependencyPackageDetail
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * DependencyPackageDetail Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DependencyPackageDetail implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'dependencyPackageDetail';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'package' => 'string',
        'label' => 'string',
        'title' => 'string',
        'thumbnail_image' => 'string',
        'thumbnail_image_hash' => 'string',
        'license_price' => 'int',
        'type' => 'string',
        'dependency_of_package' => '\Swagger\Client\Model\DependencyPackageDetailDependencyOfPackage'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'package' => 'package',
        'label' => 'label',
        'title' => 'title',
        'thumbnail_image' => 'thumbnail_image',
        'thumbnail_image_hash' => 'thumbnail_image_hash',
        'license_price' => 'license_price',
        'type' => 'type',
        'dependency_of_package' => 'dependency_of_package'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'package' => 'setPackage',
        'label' => 'setLabel',
        'title' => 'setTitle',
        'thumbnail_image' => 'setThumbnailImage',
        'thumbnail_image_hash' => 'setThumbnailImageHash',
        'license_price' => 'setLicensePrice',
        'type' => 'setType',
        'dependency_of_package' => 'setDependencyOfPackage'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'package' => 'getPackage',
        'label' => 'getLabel',
        'title' => 'getTitle',
        'thumbnail_image' => 'getThumbnailImage',
        'thumbnail_image_hash' => 'getThumbnailImageHash',
        'license_price' => 'getLicensePrice',
        'type' => 'getType',
        'dependency_of_package' => 'getDependencyOfPackage'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['package'] = isset($data['package']) ? $data['package'] : null;
        $this->container['label'] = isset($data['label']) ? $data['label'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['thumbnail_image'] = isset($data['thumbnail_image']) ? $data['thumbnail_image'] : null;
        $this->container['thumbnail_image_hash'] = isset($data['thumbnail_image_hash']) ? $data['thumbnail_image_hash'] : null;
        $this->container['license_price'] = isset($data['license_price']) ? $data['license_price'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['dependency_of_package'] = isset($data['dependency_of_package']) ? $data['dependency_of_package'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets package
     * @return string
     */
    public function getPackage()
    {
        return $this->container['package'];
    }

    /**
     * Sets package
     * @param string $package fully qualified package name
     * @return $this
     */
    public function setPackage($package)
    {
        $this->container['package'] = $package;

        return $this;
    }

    /**
     * Gets label
     * @return string
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     * @param string $label version label of dependency package
     * @return $this
     */
    public function setLabel($label)
    {
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title title of the dependency package
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets thumbnail_image
     * @return string
     */
    public function getThumbnailImage()
    {
        return $this->container['thumbnail_image'];
    }

    /**
     * Sets thumbnail_image
     * @param string $thumbnail_image thumbnail_image of the dependency package
     * @return $this
     */
    public function setThumbnailImage($thumbnail_image)
    {
        $this->container['thumbnail_image'] = $thumbnail_image;

        return $this;
    }

    /**
     * Gets thumbnail_image_hash
     * @return string
     */
    public function getThumbnailImageHash()
    {
        return $this->container['thumbnail_image_hash'];
    }

    /**
     * Sets thumbnail_image_hash
     * @param string $thumbnail_image_hash thumbnail_image_hash for base64 lookup in thumbnail_image_data
     * @return $this
     */
    public function setThumbnailImageHash($thumbnail_image_hash)
    {
        $this->container['thumbnail_image_hash'] = $thumbnail_image_hash;

        return $this;
    }

    /**
     * Gets license_price
     * @return int
     */
    public function getLicensePrice()
    {
        return $this->container['license_price'];
    }

    /**
     * Sets license_price
     * @param int $license_price price of the license which the dependency package is part of
     * @return $this
     */
    public function setLicensePrice($license_price)
    {
        $this->container['license_price'] = $license_price;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type package type of dependency package
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets dependency_of_package
     * @return \Swagger\Client\Model\DependencyPackageDetailDependencyOfPackage
     */
    public function getDependencyOfPackage()
    {
        return $this->container['dependency_of_package'];
    }

    /**
     * Sets dependency_of_package
     * @param \Swagger\Client\Model\DependencyPackageDetailDependencyOfPackage $dependency_of_package
     * @return $this
     */
    public function setDependencyOfPackage($dependency_of_package)
    {
        $this->container['dependency_of_package'] = $dependency_of_package;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


