<?php
/**
 * Blended Admin Meta Boxes
 *
 * @author      Blended
 * @category    Admin
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Blended_Admin_Meta_Boxes {
	
		
	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'add_meta_boxes', array( $this, 'remove_meta_boxes' ), 10 );
		add_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ), 30 );
		add_action( 'save_post', array( $this, 'save_meta_boxes' ), 1, 2 );
	}
	
	/**
	 * Add Meta boxes.
	 */
	public function add_meta_boxes() {
		add_meta_box(
            'blended-blocks',
            __( 'Block Contents', 'blended' ),
            array( $this, 'render_metabox' ),
            array('post','page'),
            'advanced',
            'default'
        );
	}
	
	/**
     * Render Meta Box content.
     *
     * @param WP_Post $post The post object.
     */
    public function render_metabox( $post ) {
		$fields = $this->get_meta_fields();
		if($fields):
		
		foreach($fields as $key => $field):
		 ?>
		 <h3><?php echo $field['label']; ?></h3>
		 <h5><?php echo $field['description']; ?><h5>
		 
		 <?php
		  $settings = array(
			'textarea_name' => "blended".$field['id'],
			'quicktags'     => array( 'buttons' => 'em,strong,link' ),
			'tinymce'       => array(
				'theme_advanced_buttons1' => 'bold,italic,strikethrough,separator,bullist,numlist,separator,blockquote,separator,justifyleft,justifycenter,justifyright,separator,link,unlink,separator,undo,redo,separator',
				'theme_advanced_buttons2' => '',
			),
			'editor_css'    => '<style>#wp-excerpt-editor-container .wp-editor-area{height:175px; width:100%;}</style>',
		);
		// Get block contents.
        $value = get_post_meta( $post->ID, "blended".$field['id'], true );
		wp_editor( htmlspecialchars_decode( $value ), "blended".$field['id'], apply_filters( 'blended_blocks_editor_settings', $settings ) );
		
		// Add an nonce field.
        wp_nonce_field( 'blended_block_contents', '__nonce_blended_block_contents' );
		?>
		<div style="margin-bottom:40px;" class="clearfix"></div>
		
		<?php
		endforeach;
		
		endif;
		
	}
	
	/**
	 * Remove meta boxes.
	 */
	public function remove_meta_boxes() {
		remove_meta_box( 'blended-blocks', array('post','page'), 'advanced' );
	}
	
	private function get_meta_fields() {
		return apply_filters( 'blended_meta_blocks', array(
			"block_2" => array(
				'id'            => '_block_2',
				'label'         => __( 'Block 2', 'blended' ),
				'description'   => __( 'Enter contents for block 2.', 'blended' ),
			),
			"block_3" => array(
				'id'            => '_block_3',
				'label'         => __( 'Block 3', 'blended' ),
				'description'   => __( 'Enter contents for block 3.', 'blended' ),
			),
			"block_4" => array(
				'id'            => '_block_4',
				'label'         => __( 'Block 4', 'blended' ),
				'description'   => __( 'Enter contents for block 4.', 'blended' ),
			),
			"block_5" => array(
				'id'            => '_block_5',
				'label'         => __( 'Block 5', 'blended' ),
				'description'   => __( 'Enter contents for block 5.', 'blended' ),
			),
			"block_6" => array(
				'id'            => '_block_6',
				'label'         => __( 'Block 6', 'blended' ),
				'description'   => __( 'Enter contents for block 6.', 'blended' ),
			),
			"hero_text" => array(
				'id'            => '_hero_text',
				'label'         => __( 'Hero Text', 'blended' ),
				'description'   => __( 'Enter contents for Hero Text.', 'blended' ),
			),
			"footer_content" => array(
				'id'            => '_footer_content',
				'label'         => __( 'Footer Content', 'blended' ),
				'description'   => __( 'Enter contents for Footer Block.', 'blended' ),
			)
			
		
		));
	}
	
	/**
	 * Save block contents.
	 *
	 * @param  int $post_id
	 * @param  object $post
	 */
	public function save_meta_boxes( $post_id, $post ) {
		// $post_id and $post are required
		if ( empty( $post_id ) || empty( $post ) ) {
			return;
		}

		// Dont' save meta boxes for revisions or autosaves
		if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
			return;
		}

		// Check the nonce
		if ( empty( $_POST['__nonce_blended_block_contents'] ) || ! wp_verify_nonce( $_POST['__nonce_blended_block_contents'], 'blended_block_contents' ) ) {
			return;
		}

		// Check the post being saved == the $post_id to prevent triggering this call for other save_post events
		if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
			return;
		}

		// Check user has permission to edit
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		// Check the post type
		if ( in_array( $post->post_type, array( 'page', 'post' ) ) ) {
			$fields = $this->get_meta_fields();	
			foreach((array)$fields as $key => $field):
			  if(isset($_POST["blended".$field["id"]]))
				  update_post_meta($post_id, "blended".$field["id"],  $_POST["blended".$field["id"]]);
			  else
				  delete_post_meta($post_id, "blended".$field["id"]);
			endforeach;
		}
	}
}

new Blended_Admin_Meta_Boxes();