<?php
/**
 * AcquisitionResponseData
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * AcquisitionResponseData Class Doc Comment
 *
 * @category    Class */
 // @description data returned from hub
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AcquisitionResponseData implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'acquisitionResponse_data';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'account' => 'string',
        'slug' => 'string',
        'title' => 'string',
        'revoked_for' => 'string',
        'revoked_by' => 'string',
        'shared_to' => 'string',
        'shared_by' => 'string',
        'transferred_to' => 'string',
        'transferred_by' => 'string',
        'redirect_url' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'account' => 'account',
        'slug' => 'slug',
        'title' => 'title',
        'revoked_for' => 'revoked_for',
        'revoked_by' => 'revoked_by',
        'shared_to' => 'shared_to',
        'shared_by' => 'shared_by',
        'transferred_to' => 'transferred_to',
        'transferred_by' => 'transferred_by',
        'redirect_url' => 'redirect_url'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'account' => 'setAccount',
        'slug' => 'setSlug',
        'title' => 'setTitle',
        'revoked_for' => 'setRevokedFor',
        'revoked_by' => 'setRevokedBy',
        'shared_to' => 'setSharedTo',
        'shared_by' => 'setSharedBy',
        'transferred_to' => 'setTransferredTo',
        'transferred_by' => 'setTransferredBy',
        'redirect_url' => 'setRedirectUrl'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'account' => 'getAccount',
        'slug' => 'getSlug',
        'title' => 'getTitle',
        'revoked_for' => 'getRevokedFor',
        'revoked_by' => 'getRevokedBy',
        'shared_to' => 'getSharedTo',
        'shared_by' => 'getSharedBy',
        'transferred_to' => 'getTransferredTo',
        'transferred_by' => 'getTransferredBy',
        'redirect_url' => 'getRedirectUrl'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['account'] = isset($data['account']) ? $data['account'] : null;
        $this->container['slug'] = isset($data['slug']) ? $data['slug'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['revoked_for'] = isset($data['revoked_for']) ? $data['revoked_for'] : null;
        $this->container['revoked_by'] = isset($data['revoked_by']) ? $data['revoked_by'] : null;
        $this->container['shared_to'] = isset($data['shared_to']) ? $data['shared_to'] : null;
        $this->container['shared_by'] = isset($data['shared_by']) ? $data['shared_by'] : null;
        $this->container['transferred_to'] = isset($data['transferred_to']) ? $data['transferred_to'] : null;
        $this->container['transferred_by'] = isset($data['transferred_by']) ? $data['transferred_by'] : null;
        $this->container['redirect_url'] = isset($data['redirect_url']) ? $data['redirect_url'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets account
     * @return string
     */
    public function getAccount()
    {
        return $this->container['account'];
    }

    /**
     * Sets account
     * @param string $account account slug of package
     * @return $this
     */
    public function setAccount($account)
    {
        $this->container['account'] = $account;

        return $this;
    }

    /**
     * Gets slug
     * @return string
     */
    public function getSlug()
    {
        return $this->container['slug'];
    }

    /**
     * Sets slug
     * @param string $slug slug of package
     * @return $this
     */
    public function setSlug($slug)
    {
        $this->container['slug'] = $slug;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title title of package
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets revoked_for
     * @return string
     */
    public function getRevokedFor()
    {
        return $this->container['revoked_for'];
    }

    /**
     * Sets revoked_for
     * @param string $revoked_for acquisition revoked for account/email
     * @return $this
     */
    public function setRevokedFor($revoked_for)
    {
        $this->container['revoked_for'] = $revoked_for;

        return $this;
    }

    /**
     * Gets revoked_by
     * @return string
     */
    public function getRevokedBy()
    {
        return $this->container['revoked_by'];
    }

    /**
     * Sets revoked_by
     * @param string $revoked_by acquisition revoked by account
     * @return $this
     */
    public function setRevokedBy($revoked_by)
    {
        $this->container['revoked_by'] = $revoked_by;

        return $this;
    }

    /**
     * Gets shared_to
     * @return string
     */
    public function getSharedTo()
    {
        return $this->container['shared_to'];
    }

    /**
     * Sets shared_to
     * @param string $shared_to shared to account
     * @return $this
     */
    public function setSharedTo($shared_to)
    {
        $this->container['shared_to'] = $shared_to;

        return $this;
    }

    /**
     * Gets shared_by
     * @return string
     */
    public function getSharedBy()
    {
        return $this->container['shared_by'];
    }

    /**
     * Sets shared_by
     * @param string $shared_by shared by account.
     * @return $this
     */
    public function setSharedBy($shared_by)
    {
        $this->container['shared_by'] = $shared_by;

        return $this;
    }

    /**
     * Gets transferred_to
     * @return string
     */
    public function getTransferredTo()
    {
        return $this->container['transferred_to'];
    }

    /**
     * Sets transferred_to
     * @param string $transferred_to transferred to account
     * @return $this
     */
    public function setTransferredTo($transferred_to)
    {
        $this->container['transferred_to'] = $transferred_to;

        return $this;
    }

    /**
     * Gets transferred_by
     * @return string
     */
    public function getTransferredBy()
    {
        return $this->container['transferred_by'];
    }

    /**
     * Sets transferred_by
     * @param string $transferred_by transferred by account.
     * @return $this
     */
    public function setTransferredBy($transferred_by)
    {
        $this->container['transferred_by'] = $transferred_by;

        return $this;
    }

    /**
     * Gets redirect_url
     * @return string
     */
    public function getRedirectUrl()
    {
        return $this->container['redirect_url'];
    }

    /**
     * Sets redirect_url
     * @param string $redirect_url url if redirection to website is needed at all.
     * @return $this
     */
    public function setRedirectUrl($redirect_url)
    {
        $this->container['redirect_url'] = $redirect_url;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


