<?php
/**
 * BundledPackagesError
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * BundledPackagesError Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BundledPackagesError implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BundledPackagesError';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'label' => 'string',
        'package' => 'string',
        'license_name' => 'string',
        'license_type' => 'string',
        'price' => 'float',
        'title' => 'string',
        'type' => 'string',
        'third_party' => 'string',
        'dependency_of_package' => 'string',
        'license_type_dependency_of_package' => 'string',
        'thumbnail_image' => 'string',
        'error' => '\Swagger\Client\Model\PublicationValidationError[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'label' => 'label',
        'package' => 'package',
        'license_name' => 'license_name',
        'license_type' => 'license_type',
        'price' => 'price',
        'title' => 'title',
        'type' => 'type',
        'third_party' => 'third_party',
        'dependency_of_package' => 'dependency_of_package',
        'license_type_dependency_of_package' => 'license_type_dependency_of_package',
        'thumbnail_image' => 'thumbnail_image',
        'error' => 'ERROR'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'label' => 'setLabel',
        'package' => 'setPackage',
        'license_name' => 'setLicenseName',
        'license_type' => 'setLicenseType',
        'price' => 'setPrice',
        'title' => 'setTitle',
        'type' => 'setType',
        'third_party' => 'setThirdParty',
        'dependency_of_package' => 'setDependencyOfPackage',
        'license_type_dependency_of_package' => 'setLicenseTypeDependencyOfPackage',
        'thumbnail_image' => 'setThumbnailImage',
        'error' => 'setError'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'label' => 'getLabel',
        'package' => 'getPackage',
        'license_name' => 'getLicenseName',
        'license_type' => 'getLicenseType',
        'price' => 'getPrice',
        'title' => 'getTitle',
        'type' => 'getType',
        'third_party' => 'getThirdParty',
        'dependency_of_package' => 'getDependencyOfPackage',
        'license_type_dependency_of_package' => 'getLicenseTypeDependencyOfPackage',
        'thumbnail_image' => 'getThumbnailImage',
        'error' => 'getError'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['label'] = isset($data['label']) ? $data['label'] : null;
        $this->container['package'] = isset($data['package']) ? $data['package'] : null;
        $this->container['license_name'] = isset($data['license_name']) ? $data['license_name'] : null;
        $this->container['license_type'] = isset($data['license_type']) ? $data['license_type'] : null;
        $this->container['price'] = isset($data['price']) ? $data['price'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['third_party'] = isset($data['third_party']) ? $data['third_party'] : null;
        $this->container['dependency_of_package'] = isset($data['dependency_of_package']) ? $data['dependency_of_package'] : null;
        $this->container['license_type_dependency_of_package'] = isset($data['license_type_dependency_of_package']) ? $data['license_type_dependency_of_package'] : null;
        $this->container['thumbnail_image'] = isset($data['thumbnail_image']) ? $data['thumbnail_image'] : null;
        $this->container['error'] = isset($data['error']) ? $data['error'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['label'] === null) {
            $invalid_properties[] = "'label' can't be null";
        }
        if ($this->container['package'] === null) {
            $invalid_properties[] = "'package' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['label'] === null) {
            return false;
        }
        if ($this->container['package'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets label
     * @return string
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     * @param string $label label of package version
     * @return $this
     */
    public function setLabel($label)
    {
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets package
     * @return string
     */
    public function getPackage()
    {
        return $this->container['package'];
    }

    /**
     * Sets package
     * @param string $package fully qualified name of package
     * @return $this
     */
    public function setPackage($package)
    {
        $this->container['package'] = $package;

        return $this;
    }

    /**
     * Gets license_name
     * @return string
     */
    public function getLicenseName()
    {
        return $this->container['license_name'];
    }

    /**
     * Sets license_name
     * @param string $license_name license name
     * @return $this
     */
    public function setLicenseName($license_name)
    {
        $this->container['license_name'] = $license_name;

        return $this;
    }

    /**
     * Gets license_type
     * @return string
     */
    public function getLicenseType()
    {
        return $this->container['license_type'];
    }

    /**
     * Sets license_type
     * @param string $license_type license type
     * @return $this
     */
    public function setLicenseType($license_type)
    {
        $this->container['license_type'] = $license_type;

        return $this;
    }

    /**
     * Gets price
     * @return float
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     * @param float $price license type
     * @return $this
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title title of bundled package
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type type of bundled package
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets third_party
     * @return string
     */
    public function getThirdParty()
    {
        return $this->container['third_party'];
    }

    /**
     * Sets third_party
     * @param string $third_party is it a third_party package?
     * @return $this
     */
    public function setThirdParty($third_party)
    {
        $this->container['third_party'] = $third_party;

        return $this;
    }

    /**
     * Gets dependency_of_package
     * @return string
     */
    public function getDependencyOfPackage()
    {
        return $this->container['dependency_of_package'];
    }

    /**
     * Sets dependency_of_package
     * @param string $dependency_of_package package name of upstream package
     * @return $this
     */
    public function setDependencyOfPackage($dependency_of_package)
    {
        $this->container['dependency_of_package'] = $dependency_of_package;

        return $this;
    }

    /**
     * Gets license_type_dependency_of_package
     * @return string
     */
    public function getLicenseTypeDependencyOfPackage()
    {
        return $this->container['license_type_dependency_of_package'];
    }

    /**
     * Sets license_type_dependency_of_package
     * @param string $license_type_dependency_of_package license_type of upstream package
     * @return $this
     */
    public function setLicenseTypeDependencyOfPackage($license_type_dependency_of_package)
    {
        $this->container['license_type_dependency_of_package'] = $license_type_dependency_of_package;

        return $this;
    }

    /**
     * Gets thumbnail_image
     * @return string
     */
    public function getThumbnailImage()
    {
        return $this->container['thumbnail_image'];
    }

    /**
     * Sets thumbnail_image
     * @param string $thumbnail_image thumbnail_image of upstream package
     * @return $this
     */
    public function setThumbnailImage($thumbnail_image)
    {
        $this->container['thumbnail_image'] = $thumbnail_image;

        return $this;
    }

    /**
     * Gets error
     * @return \Swagger\Client\Model\PublicationValidationError[]
     */
    public function getError()
    {
        return $this->container['error'];
    }

    /**
     * Sets error
     * @param \Swagger\Client\Model\PublicationValidationError[] $error list of errors will be displayed here.
     * @return $this
     */
    public function setError($error)
    {
        $this->container['error'] = $error;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


