<?php
/**
 * CreateVersion
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * CreateVersion Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateVersion implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateVersion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'label' => 'string',
        'hash_as_token' => 'string',
        'auto_share_packages' => 'string[]',
        'purchase_packages' => 'string[]',
        'skip_validation' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'label' => 'label',
        'hash_as_token' => 'hash_as_token',
        'auto_share_packages' => 'auto_share_packages',
        'purchase_packages' => 'purchase_packages',
        'skip_validation' => 'skip_validation'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'label' => 'setLabel',
        'hash_as_token' => 'setHashAsToken',
        'auto_share_packages' => 'setAutoSharePackages',
        'purchase_packages' => 'setPurchasePackages',
        'skip_validation' => 'setSkipValidation'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'label' => 'getLabel',
        'hash_as_token' => 'getHashAsToken',
        'auto_share_packages' => 'getAutoSharePackages',
        'purchase_packages' => 'getPurchasePackages',
        'skip_validation' => 'getSkipValidation'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['label'] = isset($data['label']) ? $data['label'] : null;
        $this->container['hash_as_token'] = isset($data['hash_as_token']) ? $data['hash_as_token'] : null;
        $this->container['auto_share_packages'] = isset($data['auto_share_packages']) ? $data['auto_share_packages'] : null;
        $this->container['purchase_packages'] = isset($data['purchase_packages']) ? $data['purchase_packages'] : null;
        $this->container['skip_validation'] = isset($data['skip_validation']) ? $data['skip_validation'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets label
     * @return string
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     * @param string $label version label.
     * @return $this
     */
    public function setLabel($label)
    {
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets hash_as_token
     * @return string
     */
    public function getHashAsToken()
    {
        return $this->container['hash_as_token'];
    }

    /**
     * Sets hash_as_token
     * @param string $hash_as_token use as token for push
     * @return $this
     */
    public function setHashAsToken($hash_as_token)
    {
        $this->container['hash_as_token'] = $hash_as_token;

        return $this;
    }

    /**
     * Gets auto_share_packages
     * @return string[]
     */
    public function getAutoSharePackages()
    {
        return $this->container['auto_share_packages'];
    }

    /**
     * Sets auto_share_packages
     * @param string[] $auto_share_packages list of dependency packages which needs to shared.
     * @return $this
     */
    public function setAutoSharePackages($auto_share_packages)
    {
        $this->container['auto_share_packages'] = $auto_share_packages;

        return $this;
    }

    /**
     * Gets purchase_packages
     * @return string[]
     */
    public function getPurchasePackages()
    {
        return $this->container['purchase_packages'];
    }

    /**
     * Sets purchase_packages
     * @param string[] $purchase_packages list of dependency packages which needs to purchases.
     * @return $this
     */
    public function setPurchasePackages($purchase_packages)
    {
        $this->container['purchase_packages'] = $purchase_packages;

        return $this;
    }

    /**
     * Gets skip_validation
     * @return bool
     */
    public function getSkipValidation()
    {
        return $this->container['skip_validation'];
    }

    /**
     * Sets skip_validation
     * @param bool $skip_validation Flag to specify whether to run validators or skip
     * @return $this
     */
    public function setSkipValidation($skip_validation)
    {
        $this->container['skip_validation'] = $skip_validation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


