<?php
/**
 * PublicationVersionError
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * PublicationVersionError Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PublicationVersionError implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PublicationVersionError';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'label' => 'string',
        'canonical' => 'bool',
        'bundle_packages' => '\Swagger\Client\Model\BundledPackagesError[]',
        'created_date' => 'string',
        'bundles_price' => 'float',
        'error' => '\Swagger\Client\Model\PublicationValidationError[]',
        'validation_status' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'label' => 'label',
        'canonical' => 'canonical',
        'bundle_packages' => 'bundle_packages',
        'created_date' => 'created_date',
        'bundles_price' => 'bundles_price',
        'error' => 'ERROR',
        'validation_status' => 'validation_status'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'label' => 'setLabel',
        'canonical' => 'setCanonical',
        'bundle_packages' => 'setBundlePackages',
        'created_date' => 'setCreatedDate',
        'bundles_price' => 'setBundlesPrice',
        'error' => 'setError',
        'validation_status' => 'setValidationStatus'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'label' => 'getLabel',
        'canonical' => 'getCanonical',
        'bundle_packages' => 'getBundlePackages',
        'created_date' => 'getCreatedDate',
        'bundles_price' => 'getBundlesPrice',
        'error' => 'getError',
        'validation_status' => 'getValidationStatus'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['label'] = isset($data['label']) ? $data['label'] : null;
        $this->container['canonical'] = isset($data['canonical']) ? $data['canonical'] : null;
        $this->container['bundle_packages'] = isset($data['bundle_packages']) ? $data['bundle_packages'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['bundles_price'] = isset($data['bundles_price']) ? $data['bundles_price'] : null;
        $this->container['error'] = isset($data['error']) ? $data['error'] : null;
        $this->container['validation_status'] = isset($data['validation_status']) ? $data['validation_status'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['label'] === null) {
            $invalid_properties[] = "'label' can't be null";
        }
        if ($this->container['canonical'] === null) {
            $invalid_properties[] = "'canonical' can't be null";
        }
        if ($this->container['bundle_packages'] === null) {
            $invalid_properties[] = "'bundle_packages' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['label'] === null) {
            return false;
        }
        if ($this->container['canonical'] === null) {
            return false;
        }
        if ($this->container['bundle_packages'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets label
     * @return string
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     * @param string $label label of package version
     * @return $this
     */
    public function setLabel($label)
    {
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets canonical
     * @return bool
     */
    public function getCanonical()
    {
        return $this->container['canonical'];
    }

    /**
     * Sets canonical
     * @param bool $canonical canonical boolean value
     * @return $this
     */
    public function setCanonical($canonical)
    {
        $this->container['canonical'] = $canonical;

        return $this;
    }

    /**
     * Gets bundle_packages
     * @return \Swagger\Client\Model\BundledPackagesError[]
     */
    public function getBundlePackages()
    {
        return $this->container['bundle_packages'];
    }

    /**
     * Sets bundle_packages
     * @param \Swagger\Client\Model\BundledPackagesError[] $bundle_packages bundle package of given version label
     * @return $this
     */
    public function setBundlePackages($bundle_packages)
    {
        $this->container['bundle_packages'] = $bundle_packages;

        return $this;
    }

    /**
     * Gets created_date
     * @return string
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param string $created_date version create date
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets bundles_price
     * @return float
     */
    public function getBundlesPrice()
    {
        return $this->container['bundles_price'];
    }

    /**
     * Sets bundles_price
     * @param float $bundles_price total price of bundled packages
     * @return $this
     */
    public function setBundlesPrice($bundles_price)
    {
        $this->container['bundles_price'] = $bundles_price;

        return $this;
    }

    /**
     * Gets error
     * @return \Swagger\Client\Model\PublicationValidationError[]
     */
    public function getError()
    {
        return $this->container['error'];
    }

    /**
     * Sets error
     * @param \Swagger\Client\Model\PublicationValidationError[] $error list of errors will be displayed here.
     * @return $this
     */
    public function setError($error)
    {
        $this->container['error'] = $error;

        return $this;
    }

    /**
     * Gets validation_status
     * @return string
     */
    public function getValidationStatus()
    {
        return $this->container['validation_status'];
    }

    /**
     * Sets validation_status
     * @param string $validation_status validation_status of version
     * @return $this
     */
    public function setValidationStatus($validation_status)
    {
        $this->container['validation_status'] = $validation_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


