<?php
/**
 * ValidatorSetsInBadge
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Blended Hub API Explorer
 *
 * A collection of Swagger documentation for the Blended Hub APIs.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: api@blended.co
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;

/**
 * ValidatorSetsInBadge Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ValidatorSetsInBadge implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ValidatorSetsInBadge';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'badge_name' => 'string',
        'badge_slug' => 'string',
        'description' => 'string',
        'mandatory_for' => 'string[]',
        'message' => 'string',
        'modified_date' => '\DateTime',
        'created_date' => '\DateTime',
        'list_of_validator_sets' => '\Swagger\Client\Model\ValidatorDetail[][]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'badge_name' => 'badge_name',
        'badge_slug' => 'badge_slug',
        'description' => 'description',
        'mandatory_for' => 'mandatory_for',
        'message' => 'message',
        'modified_date' => 'modified_date',
        'created_date' => 'created_date',
        'list_of_validator_sets' => 'list_of_validator_sets'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'badge_name' => 'setBadgeName',
        'badge_slug' => 'setBadgeSlug',
        'description' => 'setDescription',
        'mandatory_for' => 'setMandatoryFor',
        'message' => 'setMessage',
        'modified_date' => 'setModifiedDate',
        'created_date' => 'setCreatedDate',
        'list_of_validator_sets' => 'setListOfValidatorSets'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'badge_name' => 'getBadgeName',
        'badge_slug' => 'getBadgeSlug',
        'description' => 'getDescription',
        'mandatory_for' => 'getMandatoryFor',
        'message' => 'getMessage',
        'modified_date' => 'getModifiedDate',
        'created_date' => 'getCreatedDate',
        'list_of_validator_sets' => 'getListOfValidatorSets'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['badge_name'] = isset($data['badge_name']) ? $data['badge_name'] : null;
        $this->container['badge_slug'] = isset($data['badge_slug']) ? $data['badge_slug'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['mandatory_for'] = isset($data['mandatory_for']) ? $data['mandatory_for'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
        $this->container['modified_date'] = isset($data['modified_date']) ? $data['modified_date'] : null;
        $this->container['created_date'] = isset($data['created_date']) ? $data['created_date'] : null;
        $this->container['list_of_validator_sets'] = isset($data['list_of_validator_sets']) ? $data['list_of_validator_sets'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets badge_name
     * @return string
     */
    public function getBadgeName()
    {
        return $this->container['badge_name'];
    }

    /**
     * Sets badge_name
     * @param string $badge_name badge name/title
     * @return $this
     */
    public function setBadgeName($badge_name)
    {
        $this->container['badge_name'] = $badge_name;

        return $this;
    }

    /**
     * Gets badge_slug
     * @return string
     */
    public function getBadgeSlug()
    {
        return $this->container['badge_slug'];
    }

    /**
     * Sets badge_slug
     * @param string $badge_slug badge slug
     * @return $this
     */
    public function setBadgeSlug($badge_slug)
    {
        $this->container['badge_slug'] = $badge_slug;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description description representing the badge
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets mandatory_for
     * @return string[]
     */
    public function getMandatoryFor()
    {
        return $this->container['mandatory_for'];
    }

    /**
     * Sets mandatory_for
     * @param string[] $mandatory_for Actions for which badge is mandatory
     * @return $this
     */
    public function setMandatoryFor($mandatory_for)
    {
        $this->container['mandatory_for'] = $mandatory_for;

        return $this;
    }

    /**
     * Gets message
     * @return string
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     * @param string $message message regarding badge
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets modified_date
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modified_date'];
    }

    /**
     * Sets modified_date
     * @param \DateTime $modified_date last modified date.
     * @return $this
     */
    public function setModifiedDate($modified_date)
    {
        $this->container['modified_date'] = $modified_date;

        return $this;
    }

    /**
     * Gets created_date
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['created_date'];
    }

    /**
     * Sets created_date
     * @param \DateTime $created_date package draft creation date.
     * @return $this
     */
    public function setCreatedDate($created_date)
    {
        $this->container['created_date'] = $created_date;

        return $this;
    }

    /**
     * Gets list_of_validator_sets
     * @return \Swagger\Client\Model\ValidatorDetail[][]
     */
    public function getListOfValidatorSets()
    {
        return $this->container['list_of_validator_sets'];
    }

    /**
     * Sets list_of_validator_sets
     * @param \Swagger\Client\Model\ValidatorDetail[][] $list_of_validator_sets List of validator sets
     * @return $this
     */
    public function setListOfValidatorSets($list_of_validator_sets)
    {
        $this->container['list_of_validator_sets'] = $list_of_validator_sets;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Swagger\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}


