<?php

/**
 * Blended REST Accounts Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Accounts
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Accounts_Login_Controller extends BD_REST_Controller {

    protected $rest_base = 'login';

    public function register_routes() {
        register_rest_route(
                $this->namespace, '/' . $this->rest_base, array(
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'create_item'),
            )
                )
        );
    }

    public function create_item($request) {
        try {
            $network = BD()->network();
            $backend = BD()->backend();
            $wpSession = BD()->api->authentication->session_key;
            $lastActiveAccount = BD()->controller()->getLastActiveAccount();
            $body = $this->get_body($request);
            $details = $network->login($body['user_name'], $body['password'], $lastActiveAccount);
            $sessionKey = BD()->api->authentication->blended_authenticate($details['session_key'], $wpSession);
            BD()->network_key = BD()->api->authentication->blended_session_setter($wpSession);
            
            $currentAccount = $details['active_account'];
            if (!$currentAccount) {
                $currentAccount = BD()->network->getCurrentAccount($details['slug'], true);
                $currentAccount = $currentAccount['slug'];
            }
            
            $backend->setCurrentAccount($currentAccount['slug']);
            $backend->setCurrentUser($body['user_name']);
            $details['last_active_account'] = $backend->getLastActiveAccount();
            $backend->setLastActiveAccount($currentAccount);

            //Sync packages
            $conflicts = [];
            if (isset($body['action']) && $body['action'] == "signup") {
                $accountSlug = BD()->controller()->getCurrentAccount();
            	$packages = BD()->network->getPackages($accountSlug);
                $checkConflicts = BD()->controller()->sync_client_hub($packages);
            	$checkConflicts = BD()->controller()->checkConflicts($checkConflicts);
                $backend->movePackage($checkConflicts, BD()->controller());
                $conflicts = $checkConflicts['conflictFound'];
            }
            $details['session_key'] = $sessionKey;
            $details['packageConflicts'] = $conflicts;
            $response = rest_ensure_response($details);
            $response->set_status(200);
            return $response;
        } catch (\Exception $e) {
            $error = json_decode($e->getMessage(), true);
            BD()->api->BD_REST_Accounts_Logout_Controller->logout($request);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

}
