<?php

/**
 * Blended REST Accounts Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Accounts
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Accounts_Logout_Controller extends BD_REST_Controller {

    protected $rest_base = 'logout';

    public function register_routes() {
        register_rest_route(
                $this->namespace, '/' . $this->rest_base, array(
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'logout'),
            )
                )
        );
    }

    public function logout($request) {
        try {
            BD()->network();
            $backend = BD()->backend();
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            BD()->api->authentication->blended_authenticate(null, $wpSession);
            BD()->network->logout();
            $backend->setCurrentAccount('anonymous');
            $backend->setCurrentUser('anonymous');
        } catch (\Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error( $error['status_code'], $error['message'], array( 'status' => $e->getCode() ) );
        }
    }

}
