<?php

/**
 * Blended REST Authentication 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Authentication
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Authentication {

    public $session_key = null;
    
    private $namespace;

    public function __construct() {
        add_filter('rest_pre_dispatch', array($this, 'check_user_permissions'), 10, 3);
    }
    
    /**
     * Check user permission before any rest request
     * @global object $blendedConfig
     * @param obect $result
     * @param object $server
     * @param object $request
     * @return \WP_Error
     */
    public function check_user_permissions($result, $server, $request) {
        $headers = $request->get_headers();
        $route = $request->get_route();
        $auth_skipped = $this->unauthorized_routes();
        if (strpos($route, '/' . $this->namespace) !== 0)
            return;
        if (array_filter($auth_skipped, function($value) use($route) {
                    if (strpos($route, '/' . $value) === 0)
                        return true;
                })) {
            return;
        }

        if (!isset($headers['sessionkey']))
            return new WP_Error('session_key_required', __('No Session key defined in request header.', 'blended'), array('status' => 500));
        $this->session_key = $headers['sessionkey'][0];
        return $result;
    }

    /**
     * Authenticate hub and WordPress session
     * @param string $hubSession
     * @param string $wpSession
     * @return user WordPress session
     */
    public function blended_authenticate($hubSession, $wpSession) {
        $backend = BD()->backend();
        if (isset($_COOKIE[LOGGED_IN_COOKIE])) {
            $userSession = $_COOKIE[LOGGED_IN_COOKIE];
            $userId = wp_validate_auth_cookie($userSession, 'logged_in');
        } else {
            $userId = wp_validate_auth_cookie($wpSession, 'logged_in');
            $userSession = $wpSession;
        }
        $backend->set_session_key($hubSession, $userId);
        return $userSession;
    }
    
    /**
     * Set Hub session key against WordPress session key
     * @param type $session_key
     * @param type $no_user
     * @return \WP_Error|boolean
     */
    public function blended_session_setter($session_key, $no_user = false) {
        $backend = BD()->backend();
        $network = BD()->network();
        $user_id = wp_validate_auth_cookie($session_key, 'logged_in');
        $session = 'offline';
        if ($no_user == true) {
            return true;
        } elseif ($user_id != false && user_can( $user_id, "manage_options" )) {
            $network_key = $backend->get_session_key();
            if (!empty($network_key))
                 $session = $network_key;
            $network->sessionKey = $session;
        } else {
            return new WP_Error('invalid_session_key', __('Session not authenticated.', 'blended'), array('status' => 500));
        }
        return $session;
    }
    
    private function unauthorized_routes() {
        global $blendedConfig;
        $this->namespace = $blendedConfig->get('swagger', 'BASE_PATH_2');
        return array(
            $this->namespace. "/menus",
            $this->namespace."/menus/(?P<id>\d+)",
            $this->namespace, '/packages/local/media/(?P<hash>[a-z0-9_\-]+)/(?P<filters>[a-zA-Z0-9_\-]+)'
        );
    }

}

return new BD_REST_Authentication();
