<?php

/**
 * Blended REST Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Controller extends WP_REST_Controller {

    /**
     * endpoint namespace.
     * @var string
     */
    protected $namespace = '';

    /**
     * route base
     * @var string
     */
    protected $rest_base = '';
    
    /**
     * Blended hostlib Iternerary object
     * @var object
     */
    protected $itinerary_route = null;

    public function __construct() {
        $this->itinerary_route = new Blended\hostlib\ItineraryRoute();
        $this->get_namespace();
    }
    
    /**
     * Rest API Namespace
     * @global object $blendedConfig
     */
    protected function get_namespace() {
        global $blendedConfig;
        $this->namespace = $blendedConfig->get('swagger', 'BASE_PATH_2');
    }
    
    /**
     * Get request body
     * @param object $request
     * @return array
     */
    protected function get_body($request) {
        $body = $request->get_body();
        $body = json_decode($body, true);
        return $body;
    }

}
