<?php

/**
 * Blended REST Host Endpoints Controller 
 * Predicts the endpoints for 
 * Library, SourceCode, Settings
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Host/AppEndpoints
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Host_Controller extends BD_REST_Controller {

    /**
     * Endpoint
     * @var string
     */
    protected $rest_base = 'host/endpoints';

    public function register_routes() {
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/(?P<endPointName>[a-z0-9_\-]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_host_app_endpoints'),
            ),
                )
        );
    }
    
    /**
     * GET: Get Host endpoints for Apps
     * @param object $request
     * @return WP_Error|WP_Rest_Response
     */
    public function get_host_app_endpoints($request) {
        try {
            $endPointName = $request['endPointName'];
            $url = blendedAppUrl($endPointName);
            $response = rest_ensure_response($url);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['code'], $error['message'], "");
        }
    }

}
