<?php

/**
 * Blended REST Host Menus Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Host/Menus
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Host_Menus_Controller extends BD_REST_Controller {

    /**
     * Endpoint
     * @var string
     */
    protected $rest_base = 'menus';

    public function register_routes() {
        register_rest_route(
                $this->namespace, '/' . $this->rest_base, array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_get_nav_list'),
            ),
                )
        );

        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/(?P<id>\d+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_get_nav_menu'),
            ),
                )
        );
    }

    /**
     * GET: Get Host Menus
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function get_get_nav_list($request) {
        try {
            $getNavList = get_nav_list();
            $response = rest_ensure_response($getNavList);
            $response->set_status(200);
            return $response;
        } catch (Exception $error) {
            $error = json_decode($error->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    public function get_get_nav_menu($request) {
        try {
            $id = $request['id'];
            $menuWordpress = blended_nav_menu($id);
            $response = rest_ensure_response($menuWordpress);
            $response->set_status(200);
            return $response;
        } catch (Exception $error) {
            $error = json_decode($error->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

}
