<?php

/**
 * Blended REST Packages Canonical Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Packages
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Packages_Canonical_Controller extends BD_REST_Packages_Controller {

    /**
     * Endpoint
     * @var string
     */
    protected $rest_base = 'packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/canonical';

    public function register_routes() {
        register_rest_route(
                $this->namespace, '/' . $this->rest_base, array(
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'canonicalSet')
            ),
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'canonicalDetails')
            ))
        );
        
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/documents', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'canonicalDownload')
            ))
        );
    }
    
    /**
     * GET: Get canonical details of a package
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function canonicalDetails($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $verbose     = true;
            $packageDetails = $this->itinerary_route->get_canonicalDetails($accountSlug, $slug, $wpSession, $verbose);
            $response = rest_ensure_response($packageDetails);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * GET: Download canonical version of a package
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function canonicalDownload($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $packageJptf = $this->itinerary_route->get_canonicalDownload($accountSlug, $slug, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * PUT: Update canonical version of a package
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function canonicalSet($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $body = $this->get_body($request);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $package = $this->itinerary_route->put_canonicalSet($accountSlug, $slug, $body, $wpSession);
            $response = rest_ensure_response($package);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    

}
