<?php

/**
 * Blended REST Packages Local Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Packages
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Packages_Local_Controller extends BD_REST_Packages_Controller {

    /**
     * Endpoint
     * @var string
     */
    protected $rest_base = 'packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)/local';

    public function register_routes() {
        register_rest_route(
                $this->namespace, '/' . $this->rest_base, array(
            array(
                'methods' => WP_REST_Server::DELETABLE,
                'callback' => array($this, 'localDelete')
            ),
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'localPackageGet')
            ))
        );

        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/documents', array(
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'localCreate')
            ),
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'localDownload')
            ),
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'localUpdate')
            ))
        );

        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/documents/(?P<name>[a-z0-9.%/|*_-]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'localDownloadFile')
            ))
        );

        register_rest_route(
                $this->namespace, '/' . 'packages/local/media/(?P<hash>[a-z0-9_\-]+)/(?P<filters>[a-zA-Z0-9_\-]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'localDownloadMedia')
            ))
        );
    }

    /**
     * GET: Get package details either from Hub or local
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function localPackageGet($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $packageJptf = $this->itinerary_route->get_localPackageGet($accountSlug, $slug, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Get file JPTF from local
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function localDownloadFile($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $filePath = $request['name'];
            $filePath = urldecode(urldecode($filePath));
            $filePath = ltrim(str_replace('*', '/', $filePath), '/');
            $fileJptf = $this->itinerary_route->get_localDownloadFile($accountSlug, $slug, $filePath, $wpSession);
            $response = rest_ensure_response($fileJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    public function localDownloadMedia($request) {
        try {
            $hash = $request['hash'];
            $filters = $request['filters'];
            $filters = encrypt_decrypt("decrypt", $filters);
            $args = explode("_", $filters);
            if (!empty($args) && in_array(count($args), range(2, 3))) {
                $filename = $hash . "_" . $args[0] . "_" . $args[1];
                $filename = (isset($args[2]) ? $filename . "_" . $args[2] : $filename);
                $filename = $filename . ".tmp.txt";
                $filepath = BD()->config['media_meta_path'] . "/" . $filename;
                if (file_exists($filepath)) {
                    $contents = file_get_contents($filepath);
                    $contents = json_decode($contents, true);
                    if (file_exists($contents['ref_part'])) {
                        $href = file_get_contents($contents['ref_part']);
                        //Get ref file
                        $part_filepath = str_replace("\/", "/", $contents['ref_part']);
                        $part_file = BD()->backend()->getLastString($part_filepath, "/");
                        $ref_file = rtrim(ltrim($part_file, "."), ".part");
                        $ref_filepath = str_replace($part_file, $ref_file, $part_filepath);
                        //Download
                        BD()->backend->downloadFile($href, $ref_filepath);
                        unlink($contents['ref_part']);
                        $contents = array_merge($contents, [
                            "hash" => $hash,
                            "filename" => $ref_file,
                            "ext" => BD()->backend()->getLastString($ref_file)
                        ]);
                        $contents["data"] = $ref_filepath;
                        $url = image($contents, $args[0], $args[1], (isset($args[2]) ? $args[2] : ""));
                        $finfo = finfo_open(FILEINFO_MIME_TYPE);
                        $contentType = finfo_file($finfo, $ref_filepath);
                        finfo_close($finfo);
                        //http_response_code(307);
                        header('Content-Type: ' . $contentType);
                        readfile($url);
                        exit;
                    }
                }
            }
            return new WP_Error();
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * DELETE: Delete package from local
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function localDelete($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $packageJptf = $this->itinerary_route->delete_localDelete($accountSlug, $slug, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Get package JPTF from local or Hub.
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function localDownload($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $asHash = $request['as_hash'];
            $packageJptf = $this->itinerary_route->get_localDownload($accountSlug, $slug, $asHash, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            $data = isset($error['data']) ? $error['data'] : "";
            return new WP_Error($error['status_code'], $error['message'], $data);
        }
    }

    /**
     * POST: Create empty package on local
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function localCreate($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $body = $this->get_body($request);
            $packageJptf = $this->itinerary_route->post_localCreate($accountSlug, $slug, $body, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * PUT: Update local package
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function localUpdate($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $body = $this->get_body($request);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $packageJptf = $this->itinerary_route->put_localUpdate($accountSlug, $slug, $body, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

}
