<?php

/**
 * Blended REST Packages Publications Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Packages
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Packages_Publications_Controller extends BD_REST_Packages_Controller {

    /**
     * Endpoint
     * @var string
     */
    protected $rest_base = 'packages/(?P<accountSlug>[a-z0-9_\-]+)/(?P<slug>[a-z0-9_\-]+)';

    public function register_routes() {
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/publications', array(
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'putPublication')
            ),
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'getPublication')
            ))
        );
        
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/publicationvalidations', array(
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'validatePublication')
            ))
        );
        
        register_rest_route(
                $this->namespace, '/' . $this->rest_base. '/versionbundles', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'versionBundles')
            ))
        );
    }
    
    /**
     * GET: Get a package publication
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function getPublication($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $packageJptf = $this->itinerary_route->get_publication($accountSlug, $slug, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * PUT: Update package publication
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function putPublication($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $body = $this->get_body($request);
            $commit = isset($request['commit']) && !empty($request['commit']) ? $request['commit'] : "";
            $fileJptf = $this->itinerary_route->put_publications($accountSlug, $slug, $commit, $body, $wpSession);
            $response = rest_ensure_response($fileJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            if (isset($error['status_code']) && isset($error['message'])) {
                return new WP_Error($error['status_code'], $error['message'], "");
            } else if (isset($error['status_code']) && isset($error['publication'])) {
                return new WP_Error($error['status_code'], "", $error);
            } else if (isset($error['status_code']) && isset($error['error'])) {
                return new WP_Error($error['status_code'], "", $error['error']);
            }
        }
    }

    /**
     * POST: Update package publication validations
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function validatePublication($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $body = $this->get_body($request);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $packageJptf = $this->itinerary_route->post_validatePublication($accountSlug, $slug, $wpSession, $body);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Get package version bundles
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function versionBundles($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $slug = strtolower($request['slug']);
            $accountSlug = strtolower($request['accountSlug']);
            $packageJptf = $this->itinerary_route->get_versionBundles($accountSlug, $slug, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
}
