<?php

/**
 * Blended REST Packages Update Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Packages
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Packages_Update_Controller extends BD_REST_Packages_Controller {

    /**
     * Endpoint
     * @var string
     */
    protected $rest_base = 'packages/(?P<accountSlug1>[a-z0-9_\-]+)/(?P<slug1>[a-z0-9_\-]+)/update/(?P<accountSlug2>[a-z0-9_\-]+)/(?P<slug2>[a-z0-9_\-]+)';

    public function register_routes() {
        //Draft
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/draft/documents', array(
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'updateFromDraft')
            ),
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'draftClone')
            ),
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'compareDraft')
            ))
        );

        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/draft/documents/(?P<document>[a-z0-9.%/|*_-]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'compareFileWithDraft')
            ))
        );

        //Local
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/local/documents', array(
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'localClone')
            ),
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'compareWithLocal')
            ),
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'updateFromLocal')
            ))
        );

        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/local/documents/(?P<document>[a-z0-9.%/|*_-]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'compareFileWithLocal')
            ))
        );

        //Canonical
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/canonical/documents', array(
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'canonicalClone')
            ),
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'compareCanonical')
            ),
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'updateFromCanonical')
            ))
        );

        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/canonical/documents/(?P<document>[a-z0-9.%/|*_-]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'compareFileWithCanonical')
            ))
        );

        //Versions
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/versions/(?P<label>[a-z0-9._\-]+)/documents', array(
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'versionClone')
            ),
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'compareVersion')
            ),
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'updateFromVersion')
            ))
        );

        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/versions/(?P<label>[a-z0-9._\-]+)/documents/(?P<document>[a-z0-9.%/|*_-]+)', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'compareFileWithVersion')
            ))
        );
    }

    /**
     * GET: Compare version document
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function compareFileWithVersion($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $version = $request['label'];
            $filePath = $request['document'];
            $filePath = urldecode(urldecode($filePath));
            $filePath = ltrim(str_replace('*', '/', $filePath), '/');
            $fileComparison = $this->itinerary_route->get_compareFileWithVersion($accountSlug1, $slug1, $accountSlug2, $slug2, $version, $filePath, $wpSession);
            $response = rest_ensure_response($fileComparison);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * PUT: Update draft from version document
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function updateFromVersion($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $files = $this->get_body($request);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $label = $request['label'];
            $packageJptf = $this->itinerary_route->put_updateFromVersion($accountSlug1, $slug1, $accountSlug2, $slug2, $label, $files, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Compare package version
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function compareVersion($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $label = $request['label'];
            $comparison = $this->itinerary_route->get_compare_version($accountSlug1, $slug1, $accountSlug2, $slug2, $label, $wpSession);
            $response = rest_ensure_response($comparison);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * POST: Clone version of a package on local file system
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function versionClone($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $body = $this->get_body($request);
            $body = json_decode($body, true);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $version = $request['label'];
            $packageHash = $body['previousPackageHash'];
            $packageJptf = $this->itinerary_route->post_versionClone($accountSlug1, $slug1, $accountSlug2, $slug2, $version, $packageHash, $body, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Compare Canonical version of a document
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function compareFileWithCanonical($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $filePath = $request['document'];
            $filePath = urldecode(urldecode($filePath));
            $filePath = ltrim(str_replace('*', '/', $filePath), '/');
            $packageJptf = $this->itinerary_route->get_compareFileWithCanonical($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * PUT: Update draft from version document
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function updateFromCanonical($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $packageJptf = $this->itinerary_route->put_updateFromCanonical($accountSlug1, $slug1, $accountSlug2, $slug2, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Compare canonical package version
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function compareCanonical($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $comparison = $this->itinerary_route->get_compare_canonical($accountSlug1, $slug1, $accountSlug2, $slug2, $wpSession);
            $response = rest_ensure_response($comparison);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * POST: Clone version of a package on local file system
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function canonicalClone($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $body = $this->get_body($request);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $body = $request->get_body();
            $body = json_decode($body, true);
            $packageJptf = $this->itinerary_route->post_canonicalClone($accountSlug1, $slug1, $accountSlug2, $slug2, $body, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * POST: Clone package on local file system
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function localClone($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $body = $this->get_body($request);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $body = $request->get_body();
            $body = json_decode($body, true);
            $packageJptf = $this->itinerary_route->post_localClone($accountSlug1, $slug1, $accountSlug2, $slug2, $body, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            if (isset($error['status_code']) && trim($error['status_code']) == "5059") {
                $this->itinerary_route->delete_localDelete($accountSlug2, $slug2, $wpSession);
                return new WP_Error($error['status_code'], "Package name already in use.", "");
            } else if (isset($error['code']) && trim($error['code']) == "4035") {
                $this->itinerary_route->delete_localDelete($accountSlug2, $slug2, $wpSession);
                return new WP_Error($error['code'], $error['message'], $error['data']);
            } else if (isset($error['message']) && trim($error['message']) == "Draft has been changed. Please pull it first.") {
                $this->itinerary_route->delete_localDelete($accountSlug2, $slug2, $wpSession);
                return new WP_Error($error['status_code'], "Package name already in use.", "");
            } else if (isset($error['message']) && trim($error['message']) == "Package does not have draft") {
                $this->itinerary_route->delete_localDelete($accountSlug2, $slug2, $wpSession);
                return new WP_Error($error['status_code'], "Package name already in use.", "");
            } else if (isset($error['status_code']) && isset($error['message']) && isset($error['data'])) {
                if ($error['message'] === "Invalid File!") {
                    $this->itinerary_route->delete_localDelete($accountSlug2, $slug2, $wpSession);
                }
                return new WP_Error($error['status_code'], $error['message'], $error['data']);
            } else {
                return new WP_Error($error['status_code'], $error['message'], "");
            }
        }
    }

    /**
     * GET: Compare local package
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function compareWithLocal($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $comparison = $this->itinerary_route->get_compareWithLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $wpSession);
            $response = rest_ensure_response($comparison);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Compare local document
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function compareFileWithLocal($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $filePath = $request['document'];
            $filePath = urldecode(urldecode($filePath));
            $filePath = ltrim(str_replace('*', '/', $filePath), '/');
            $packageJptf = $this->itinerary_route->get_compareFileWithLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * PUT: Update local draft
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function updateFromLocal($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $files = $this->get_body($request);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $packageJptf = $this->itinerary_route->put_updateFromLocal($accountSlug1, $slug1, $accountSlug2, $slug2, $files, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * PUT: Update local draft
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function updateFromDraft($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $packageJptf = $this->itinerary_route->put_updateFromDraft($accountSlug1, $slug1, $accountSlug2, $slug2, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * POST: Clone draft on local file system
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function draftClone($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $packageJptf = $this->itinerary_route->post_draftClone($accountSlug1, $slug1, $accountSlug2, $slug2, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Compare draft package
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function compareDraft($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $comparison = $this->itinerary_route->get_compare_draft($accountSlug1, $slug1, $accountSlug2, $slug2, $wpSession);
            $response = rest_ensure_response($comparison);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * GET: Compare draft document
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function compareFileWithDraft($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $accountSlug1 = strtolower($request['accountSlug1']);
            $slug1 = strtolower($request['slug1']);
            $accountSlug2 = strtolower($request['accountSlug2']);
            $slug2 = strtolower($request['slug2']);
            $filePath = $request['document'];
            $filePath = urldecode(urldecode($filePath));
            $filePath = ltrim(str_replace('*', '/', $filePath), '/');
            $packageJptf = $this->itinerary_route->get_compareFileWithDraft($accountSlug1, $slug1, $accountSlug2, $slug2, $filePath, $wpSession);
            $response = rest_ensure_response($packageJptf);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

}
