<?php

/**
 * Blended REST Settings Controller 
 *
 * @class    Blended
 * @author   Blended
 * @package  Blended/Rest/Settings
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_REST_Settings_Controller extends BD_REST_Controller {

    /**
     * Endpoint
     * @var string
     */
    protected $rest_base = 'settings';

    public function register_routes() {
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/updates', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_get_hub_settings')
            ),
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'put_save_hub_settings')
            ),
                )
        );

        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/wordpress', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_get_wordpress_settings'),
            ),
            array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'put_save_wordpress_settings'),
            ),
                )
        );
        
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/navigations', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_get_navigation_settings'),
            ),
             array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'put_get_navigation_settings'),
            ),
                )
        );
        
        register_rest_route(
                $this->namespace, '/' . $this->rest_base . '/theme', array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_get_theme_settings'),
            ),
             array(
                'methods' => WP_REST_Server::EDITABLE,
                'callback' => array($this, 'put_save_theme_settings'),
            ),
                )
        );
    }

    /**
     * GET: Get hub settings
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function get_get_hub_settings($request) {
        try {
            $getSetting = $this->itinerary_route->get_get_hub_settings();
            $response = rest_ensure_response($getSetting);
            $response->set_status(200);
            return $response;
        } catch (Exception $error) {
            $error = json_decode($error->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }

    /**
     * PUT: Save hub settings
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function put_save_hub_settings($request) {
        try {
            $body = $this->get_body($request);
            $updateSetting = $this->itinerary_route->put_save_hub_settings($body);
            $response = rest_ensure_response($updateSetting);
            $response->set_status(200);
            return $response;
        } catch (Exception $error) {
            $error = json_decode($error->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * GET: Get WordPress settings
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function get_get_wordpress_settings($request) {
        try {
            $settingsWordpress = $this->itinerary_route->get_get_wordpress_settings();
            $response = rest_ensure_response($settingsWordpress);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * PUT: Save WordPress settings
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function put_save_wordpress_settings($request) {
        try {
            $settings = $this->get_body($request);
            $settingsWordpress = $this->itinerary_route->put_save_wordpress_settings($settings);
            $response = rest_ensure_response($settingsWordpress);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * GET: Get navigation settings
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function get_get_navigation_settings($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $settingsNavigation = $this->itinerary_route->get_get_navigation_settings();
            $response = rest_ensure_response($settingsNavigation);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * PUT: Save navigation settings
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function put_get_navigation_settings($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $settings = $this->get_body($request);
            $settingsNavigation = $this->itinerary_route->put_get_navigation_settings($settings);
            $response = rest_ensure_response($settingsNavigation);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * GET: Get theme settings
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function get_get_theme_settings($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $settingsTheme = $this->itinerary_route->get_get_theme_settings();
            $response = rest_ensure_response($settingsTheme);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    
    /**
     * PUT: Save theme settings
     * @param object $request
     * @return WP_Error|WP_REST_Response
     */
    public function put_save_theme_settings($request) {
        try {
            $wpSession = BD()->api->authentication->session_key;
            BD()->api->authentication->blended_session_setter($wpSession);
            $settings = $this->get_body($request);
            $settingsTheme = $this->itinerary_route->put_get_navigation_settings($settings);
            $response = rest_ensure_response($settingsTheme);
            $response->set_status(200);
            return $response;
        } catch (Exception $e) {
            $error = json_decode($e->getMessage(), true);
            return new WP_Error($error['status_code'], $error['message'], "");
        }
    }
    

}
