<?php

/**
 * Blended Theme API 
 *
 * @class    Blended
 * @author   Blended
 * @package  blended_fw/inc
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class BD_API {
    
    /**
     * Authentication Class
     * @var object
     */
    public $authentication;

    /**
     * Constructor
     */
    public function __construct() {
        //REST API.
        $this->rest_api_init();
    }

    private function rest_api_init() {
        // Check WP REST API
        if (!class_exists('WP_REST_Server')) {
            return;
        }
        $this->rest_api_includes();
        // Init REST API routes.
        add_action('rest_api_init', array($this, 'register_rest_routes'), 10);
        add_filter('rest_url_prefix', "blended_api");
    }

    private function rest_api_includes() {
        $this->authentication = include_once BD_PATH . '/inc/api/class-bd-rest-authentication.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-accounts-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-accounts-login-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-accounts-logout-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-settings-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-host-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-host-menus-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-packages-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-packages-acquisitions-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-packages-versions-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-packages-canonical-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-packages-draft-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-packages-local-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-packages-update-controller.php';
        include_once BD_PATH . '/inc/api/class-bd-rest-packages-publications-controller.php';
        
    }

    public function register_rest_routes() {
        $controllers = array(
            'BD_REST_Accounts_Controller',
            'BD_REST_Accounts_Login_Controller',
            'BD_REST_Accounts_Logout_Controller',
            'BD_REST_Settings_Controller',
            'BD_REST_Host_Controller',
            'BD_REST_Host_Menus_Controller',
            'BD_REST_Packages_Controller',
            'BD_REST_Packages_Acquisitions_Controller',
            'BD_REST_Packages_Versions_Controller',
            'BD_REST_Packages_Canonical_Controller',
            'BD_REST_Packages_Draft_Controller',
            'BD_REST_Packages_Local_Controller',
            'BD_REST_Packages_Update_Controller',
            'BD_REST_Packages_Publications_Controller'
        );
        foreach ($controllers as $controller) {
            $this->$controller = new $controller();
            $this->$controller->register_routes();
        }
    }

}
