<?php

/**
 * Blended WooCommerce Support
 * @since 1.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 *  Blended_WC Class
 */
class Blended_WC {

    public function __construct() {
        // We safely integrate with WC with this hook
        if (!$this->is_wc_active())
            return;
        add_action('after_setup_theme', array(&$this, 'support_woocommerce'));
        add_action('widgets_init', array(&$this, 'shop_widgets'));
        add_action("init", array(&$this, "includes"));
    }

    public function includes() {

        require_once dirname(__FILE__) . "/woocommerce-helper-functions.php";
    }

    public function include_templates() {
        
    }
    
    public function shop_widgets() {
        register_sidebar(array(
        'name' => __('Shop Widget Area', 'blended_fw'),
        'id' => 'blended_shop_sidebar',
        'description' => __('Appears on shop posts and pages in the sidebar.', 'blended_fw'),
        'before_widget' => '<div class="bd-shop-widget">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>'
    ));
    }

    /**
     * Check if WooCommerce is active
     */
    public function is_wc_active() {
        if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
            return false;
        }
        return true;
    }

    public function support_woocommerce() {
        add_theme_support('woocommerce', array(
            'thumbnail_image_width' => 360,
            'single_image_width' => 600,
            'product_grid' => array(
                'default_rows' => 3,
                'min_rows' => 2,
                'max_rows' => 8,
                'default_columns' => 4,
                'min_columns' => 2,
                'max_columns' => 5,
            ),
        ));

        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
    }

}

//Instantiate Blended_WC
new Blended_WC();
