<?php

/**
 * WooCommerce Helper Functions
 *
 * @author   Blended
 * @category Core
 * @package  Blended/WooCommerce/Functions
 * @version  1.0.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


/**
 * Set WooCommerce product in loop context
 * @global object $product
 * @global object $post
 * @param object $this_post
 */
function timber_set_product($this_post) {
    global $product;
    global $post;
    if (is_woocommerce()) {
        $product = wc_get_product($this_post->ID);
        $post = get_post($this_post->ID);
    }
}

/**
 * Header Cart
 */
add_filter('timber_context', function($context) {
    if (is_admin())
        return $context;
    ob_start();
    ?>
    <a class="cart-customlocation shopping_icon" href="<?php echo wc_get_cart_url(); ?>" title="<?php _e('View your shopping cart'); ?>"><i class="fa fa-shopping-cart"></i><span class="added__item"><?php echo WC()->cart->get_cart_contents_count(); ?></span></a>
    <?php
    $context['woocommerce_header_cart'] = ob_get_clean();
    return $context;
});

/**
 * Header Cart Ajax Update
 */
add_filter('woocommerce_add_to_cart_fragments', 'wc_header_cart', 10, 1);

function wc_header_cart($fragments) {
    global $woocommerce;

    ob_start();
    ?>
    <a class="cart-customlocation shopping_icon" href="<?php echo wc_get_cart_url(); ?>" title="<?php _e('View your shopping cart'); ?>"><i class="fa fa-shopping-cart"></i><span class="added__item"><?php echo WC()->cart->get_cart_contents_count(); ?></span></a>
    <?php
    $fragments['a.cart-customlocation'] = ob_get_clean();
    return $fragments;
}
