<?php

/**
 * Blended Seo Functions
 * @since 1.0
 */
if (!defined('WPSEO_VERSION')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    return;
}

/**
 * function : Blended seo head init
 */
function blended_seo_head_init() {
    add_action("blended_seo_head", array(blended_seo_instance(), "front_page_specific_init"), 0);
    add_action("blended_seo_head", "blended_head", 1);
}

/**
 * Callback of twig function seo_head()
 */
function blended_seo_head() {
    blended_seo_head_init();
    do_action("blended_seo_head");
}

/**
 * Callback of twig function seo_title()
 */
function blended_seo_title() {
    return blended_seo_instance()->title('');
}

/**
 * Get Yoast Seo Instance
 * @return type
 */
function blended_seo_instance() {
    $instance = WPSEO_Frontend::get_instance();
    return $instance;
}

/**
 * Main wrapper function attached to blended_seo_head. This combines all the output on the frontend of the Yoast SEO plugin.
 */
function blended_head() {
    global $wp_query;

    $old_wp_query = null;

    if (!$wp_query->is_main_query()) {
        $old_wp_query = $wp_query;
        wp_reset_query();
    }

    /**
     * Action: 'wpseo_head' - Allow other plugins to output inside the Yoast SEO section of the head section.
     */
    do_action('wpseo_head');

    if (!empty($old_wp_query)) {
        $GLOBALS['wp_query'] = $old_wp_query;
        unset($old_wp_query);
    }

    return;
}
