<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author 	WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */
 
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

$context = Timber::get_context();
$context['sidebar'] = Timber::get_widgets('sidebar-1');
$context['shop_sidebar'] = Timber::get_widgets('blended_shop_sidebar');
$context['title'] = get_the_title(wc_get_page_id('shop'));
$posts = Timber::get_posts();

$context['products'] = $posts;



if (is_product_category()) {
    $queried_object = get_queried_object();
    $term_id = $queried_object->term_id;
    $context['category'] = get_term($term_id, 'product_cat');
    $context['title'] = single_term_title('', false);
}

Timber::render(array('woocommerce/archive-product.twig'), $context);