<?php
# Header definition for React app.
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept');
//header("Access-Control-Allow-Headers : Content-Type, sessionkey");

# React UI url
define('REACT_URI', '//cdn.blended.co/app/blendedapp_v0.0.1');

# React CDN url
define('REACT_CDN', '//maxcdn.bootstrapcdn.com');

# React jQuery url
define('REACT_JQUERY', '//ajax.googleapis.com');

# If timber not already installed as a plugin use this plugin.
include dirname(__FILE__) . '/inc/tgmaBlended.php';

# Include article function.
include dirname(__FILE__) . '/inc/article_functions.php';

# Include navigation functions.
include dirname(__FILE__) . '/inc/navigation_functions.php';

# Include general helper functions.
include dirname(__FILE__) . '/inc/blended_helper_functions.php';

# Register blended posts
include_once( dirname( __FILE__ ) . '/inc/class-blended-post-types.php' );

#Register Shortcodes
include_once( dirname( __FILE__ ) . '/inc/class-blended-shortcodes.php' );

# If not installed plugin or not having already included into framework, generate error to install Timber Plugin.
# Blended themes can not run without twig/timber.
if (class_exists('Twig_Extension')) {
    # Include Blended host specific template-loader to interact and to run Blended.
    require(dirname(__FILE__) . '/template-loader.php');   
    $blended_loader = new Blended_Loader();
    include 'inc/theme-preview.php';
}

if(class_exists('Blended_ini_Parser')) {
    
    # Make NAMESPACE globally available
    global $NAMESPACE;
    $NAMESPACE = $config->get('swagger', 'BASE_PATH_2');

    # Defined all Hub related REST calls.
    require(dirname(__FILE__) . '/hostlib/routes.php');
    
    # Overriding default wp-json prefix to 'blended' here.
    add_filter('rest_url_prefix', 'blended_api');

    $display_popup = $THEME_SETTINGS->get('hub_settings', 'updates');
    $display_popup = json_decode($display_popup, true);
    if(isset($display_popup['signInpopup'])) {
       $display_popup = $display_popup['signInpopup'];
    } else {
       $display_popup = true;
    }   
}

function blended_api($prefix)
{
    global $config;
    $prefix = $config->get('swagger', 'BASE_PATH_1');
    
    return $prefix;
}

# Get WP Current User session key used by React App to validate user session.
add_action('admin_print_scripts', 'blended_inline_authenticate');

function blended_inline_authenticate()
{
    echo "<script>\n";
    echo 'var sessionKey = "' . $_COOKIE[LOGGED_IN_COOKIE] . '";';
    echo 'localStorage.setItem ("sessionKey" , sessionKey)';
    echo "\n</script>";
}

# Switch permalink to post type.
add_action('admin_footer', 'default_permalink');
add_action('init', 'default_permalink');
function default_permalink()
{
    
    global $wp_rewrite;
    $wp_rewrite->set_permalink_structure('/%postname%/');
    $wp_rewrite->flush_rules();
    if (function_exists('flush_rewrite_rules')) {
        flush_rewrite_rules(true);
    } //Set default permalink to postname end       
    update_option('change_permalink', 'post_name_permalink');
}

# unset react session_key on theme activate.
wp_register_theme_activation_hook('Blended Themes', 'unset_session_key');
add_action( 'after_switch_theme', 'unset_session_key' );
function unset_session_key() {
    echo "<script>\n";
    echo 'localStorage.removeItem("session_key")';
    echo "\n</script>";
}

function wp_register_theme_activation_hook($code, $function) {
    $optionKey="theme_is_activated_" . $code;
    if(!get_option($optionKey)) {
        call_user_func($function);
        update_option($optionKey , 1);
    }
}

// Include jQuery
if(!function_exists('blended_scripts')) {
	function blended_scripts() {
		 wp_enqueue_script('jquery');
	}
	add_action("wp_enqueue_scripts", "blended_scripts");
}



# blended login onboard popup
if (is_admin() && isset($_GET['activated']) && 'themes.php' == $GLOBALS['pagenow'] || 'index.php' == $GLOBALS['pagenow']) {
    function show_popup($hook_suffix)
    {
        print '<div class="blendedux-page onboarding-page" id="blendedux"></div>';
        wp_enqueue_script('react_jquery', REACT_URI . '/App/Onboard-popup/lib/jquery-1.11.2.min.js', array(), null, true);
        wp_enqueue_script('react_bundle', REACT_URI . '/App/Onboard-popup/bundle.js', array(), null, true);
        $output = '<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Blended On-Boarding</title>
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Onboard-popup/css/normalize.css">
        <link rel="stylesheet" href=" '. REACT_CDN .'/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Onboard-popup/css/style.css">';
        
        echo $output;
    }
}

if (function_exists('show_popup') && class_exists('Twig_Extension') && $display_popup == true) {
    add_action('admin_enqueue_scripts', 'show_popup');
}

# Custom admin page for React Library Onboarding page and Settings app.
add_action('admin_menu', 'blended_admin_menu');

function blended_admin_menu()
{
    $library     = add_menu_page('Blended Library', 'Blended Library', 'manage_options', 'Library', 'blended_library_admin_page', 'dashicons-welcome-view-site', 6);
    $setting = add_menu_page('Blended Setting', 'Blended Settings', 'manage_options', 'Setting', 'blended_setting_admin_page', 'dashicons-admin-generic', 7);
    $onboard = add_submenu_page(null, 'Blended Onboard', 'Blended Onboard', 'manage_options', 'Onboard', 'blended_Onboarding_page');
    $sourceCode = add_submenu_page(null, 'Source Code', 'Source Code', 'manage_options', 'Source Code', 'blended_source_code_admin_page');
    
    if (class_exists('Twig_Extension')) {
        add_action("admin_print_scripts-$library", 'Library_head');
        add_action("admin_print_scripts-$setting", 'Setting_head');
        add_action("admin_print_scripts-$onboard", 'Onboard_page');
        add_action("admin_print_scripts-$sourceCode", 'Source_code');
    }
}

function blended_library_admin_page()
{
    print '<div className="blendedux-page" id="blendedux"></div>';
}

# Library part of React app.
function Library_head()
{
    wp_register_style('style', plugins_url('style.css', __FILE__));
    wp_enqueue_script('react_jquery', REACT_URI . '/App/Library/lib/jquery-1.3.2.min.js', array(), null, true);
    wp_enqueue_script('react_jquery_ui', REACT_URI . '/App/Library/lib/jquery-ui-1.7.2.js', array(), null, true);
    wp_enqueue_script('react_bundle', REACT_URI . '/App/Library/bundle.js', array(), null, true);
    wp_enqueue_script('object_assign', REACT_URI . '/App/Library/lib/object_assign.js', array(), null, true);
    $output = '<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Blended Library</title>
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Library/css/normalize.css">
        <link rel="stylesheet" href=" '. REACT_CDN .'/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Library/css/grid.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Library/css/style_wp.css">';
    
    echo $output;
}

function blended_setting_admin_page()
{
    print '<div className="blendedux-page" id="blendedux"></div>';
}

# Setting part of React app.
function Setting_head()
{
    wp_enqueue_script('react_jquery', REACT_URI . '/App/Settings/js/jquery-1.11.2.min.js', array(), null, true);
    wp_enqueue_script('react_bundle', REACT_URI . '/App/Settings/bundle.js', array(), null, true);
    wp_enqueue_script('react_msgpop', REACT_URI . '/App/Settings/js/msgPop.js', array(), null, true);
    wp_enqueue_script('object_assign', REACT_URI . '/App/Settings/js/object_assign.js', array(), null, true);
    $output = '<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Blended Library</title>
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Settings/css/normalize.css">
        <link rel="stylesheet" href=" '. REACT_CDN .'/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Settings/css/grid.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Settings/css/msgPop.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Settings/css/style.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Settings/css/slider.css">';
    
    echo $output;
}

function blended_Onboarding_page()
{
    print '<div class="blendedux-page onboarding-page" id="blendedux"></div>';
}

function Onboard_page()
{
    wp_enqueue_script('react_jquery', REACT_URI . '/App/Onboard-app/lib/jquery-1.11.2.min.js', array(), null, true);
    wp_enqueue_script('react_bundle', REACT_URI . '/App/Onboard-app/bundle.js', array(), null, true);
    $output = '<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Blended On-Boarding</title>
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Onboard-app/css/normalize.css">
        <link rel="stylesheet" href=" '. REACT_CDN .'/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/Onboard-app/css/style.css">';
    
    echo $output;
}

function blended_source_code_admin_page()
{
    print '<div className="blendedux-page" id="blendedux"></div>';
}

function Source_code()
{
    wp_enqueue_script('react_jquery', REACT_URI . '/App/SourceCode/js/jquery-1.11.2.min.js', array(), null, true);
    wp_enqueue_script('react_jquery', REACT_URI . '/App/SourceCode/js/custom-select.js', array(), null, true);
    wp_enqueue_script('react_jquery', REACT_URI . '/App/SourceCode/js/source-code.js', array(), null, true);
    wp_enqueue_script('react_jquery', REACT_JQUERY . '/ajax/libs/jquery/1.12.2/jquery.min.js', array(), null, true);
    wp_enqueue_script('react_bundle', REACT_URI . '/App/SourceCode/bundle.js', array(), null, true);
    wp_enqueue_script('object_assign', REACT_URI . '/App/SourceCode/js/object_assign.js', array(), null, true);
    $output = '<meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Blended Source Code</title>
        <link rel="stylesheet" href=" '. REACT_URI .'/App/SourceCode/css/normalize.css">
        <link rel="stylesheet" href=" '. REACT_CDN .'/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href=" '. REACT_URI .'/App/SourceCode/css/style.css">';

    echo $output;
}

add_action('wp_logout','remove_react_local_storage');

function remove_react_local_storage(){
    echo "<script>\n";
    echo 'localStorage.removeItem("session_key")';
    echo "\n</script>";
}


/* .....................................................................................................................................................*/

/* wordpress widgets are defined and initialized here */
function blended_fw_widgets_init()
{
    
    register_sidebar(array(
        'name' => __('Main Widget Area', 'blended_fw'),
        'id' => 'sidebar-1',
        'description' => __('Appears in the footer section of the site.', 'blended_fw'),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>'
    ));
    
    register_sidebar(array(
        'name' => __('Secondary Widget Area', 'blended_fw'),
        'id' => 'sidebar-2',
        'description' => __('Appears on posts and pages in the sidebar.', 'blended_fw'),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>'
    ));
    
    register_sidebar(array(
        'name' => __('Footer Widget Area', 'blended_fw'),
        'id' => 'sidebar-3',
        'description' => __('Appears on Footer Area.', 'blended_fw'),
        'before_widget' => '<div class="one_third-md footer-content__col">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>'
    ));
    
    register_sidebar(array(
        'name' => __('Contact Map', 'blended_fw'),
        'id' => 'sidebar-4',
        'description' => __('Appears on Contact Page.', 'blended_fw'),
        'before_widget' => '<div class="map-responsive">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>'
    ));
}

add_action('widgets_init', 'blended_fw_widgets_init');


if (!function_exists('blended_fw_entry_meta')):
    function blended_fw_entry_meta()
    {
        if (is_sticky() && is_home() && !is_paged())
            echo '<span class="featured-post">' . esc_html__('Sticky', 'blended_fw') . '</span>';
        
        if (!has_post_format('link') && 'post' == get_post_type())
            blended_fw_entry_date();
        
        // Translators: used between list items, there is a space after the comma.
        $categories_list = get_the_category_list(__(', ', 'blended_fw'));
        if ($categories_list) {
            echo '<span class="categories-links">' . $categories_list . '</span>';
        }
        
        // Translators: used between list items, there is a space after the comma.
        $tag_list = get_the_tag_list('', __(', ', 'blended_fw'));
        if ($tag_list) {
            echo '<span class="tags-links">' . $tag_list . '</span>';
        }
        
        // Post author
        if ('post' == get_post_type()) {
            printf('<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>', esc_url(get_author_posts_url(get_the_author_meta('ID'))), esc_attr(sprintf(__('View all posts by %s', 'blended_fw'), get_the_author())), get_the_author());
        }
    }
endif;

if (!function_exists('blended_fw_entry_date')): /**
 * Print HTML with date information for current post.
 *
 * Create your own blended_fw_entry_date() to override in a child theme.
 *
 * @param boolean $echo (optional) Whether to echo the date. Default true.
 * @return string The HTML-formatted post date.
 */ 
    function blended_fw_entry_date($echo = true)
    {
        if (has_post_format(array(
            'chat',
            'status'
        )))
            $format_prefix = _x('%1$s on %2$s', '1: post format name. 2: date', 'blended_fw');
        else
            $format_prefix = '%2$s';
        
        $date = sprintf('<span class="date"><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a></span>', esc_url(get_permalink()), esc_attr(sprintf(__('Permalink to %s', 'blended_fw'), the_title_attribute('echo=0'))), esc_attr(get_the_date('c')), esc_html(sprintf($format_prefix, get_post_format_string(get_post_format()), get_the_date())));
        
        if ($echo)
            echo $date;
        
        return $date;
    }
endif;



if ( ! function_exists( 'blended_fw_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 *
 * Create your own blended_fw_setup() function to override in a child theme.
 *
 * @since Twenty Sixteen 1.0
 */
function blended_fw_setup() {
    // This theme uses wp_nav_menu() in two locations.
    register_nav_menus( array(
        'primary' => __( 'Primary Menu', 'twentysixteen' ),
        'social'  => __( 'Social Links Menu', 'twentysixteen' ),
    ) );
    
    add_image_size( 'admin-list-thumb', 80, 80, true );
    add_image_size( 'gallery-list-thumb', 360, 260, true );
}
endif; // blended_fw_setup
add_action( 'after_setup_theme', 'blended_fw_setup' );

# Include woocommerce.
include dirname(__FILE__) . '/inc/class-wc-support.php';

# Include admin instances.
if(is_admin())
include dirname(__FILE__) . '/inc/admin/class-blended-admin.php';

# Include comment functions.
include dirname(__FILE__) . '/inc/comment-functions.php';