# Swagger\Client\AccountsApi

All URIs are relative to *https://stgqahub.blended.co/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**addAccountAdmin**](AccountsApi.md#addAccountAdmin) | **POST** /accounts/{slug}/admins/ | Add a admin user into account.
[**addAccountUser**](AccountsApi.md#addAccountUser) | **POST** /accounts/{slug}/users/ | Add a regular user into account.
[**createAccount**](AccountsApi.md#createAccount) | **POST** /accounts/ | Create a new user account.
[**getAccountAdmin**](AccountsApi.md#getAccountAdmin) | **GET** /accounts/{slug}/admins/{admin_slug}/ | Get account Admin.
[**getAccountAdmins**](AccountsApi.md#getAccountAdmins) | **GET** /accounts/{slug}/admins/ | get admin users of account.
[**getAccountDetails**](AccountsApi.md#getAccountDetails) | **GET** /accounts/{slug}/ | Detail View of user account.
[**getAccountList**](AccountsApi.md#getAccountList) | **GET** /accounts/{slug}/accounts/ | Returns all accounts from the system that the user has access to.
[**getAccountUser**](AccountsApi.md#getAccountUser) | **GET** /accounts/{slug}/users/{user_slug}/ | account Regular user.
[**getAccountUsers**](AccountsApi.md#getAccountUsers) | **GET** /accounts/{slug}/users/ | get Regular Users of account.
[**getCurrentAccount**](AccountsApi.md#getCurrentAccount) | **GET** /accounts/{slug}/current/ | Get current user account.
[**getPendingUsers**](AccountsApi.md#getPendingUsers) | **GET** /accounts/{slug}/pendings/ | Get list of user&#39;s account pending users.
[**inviteUser**](AccountsApi.md#inviteUser) | **POST** /accounts/{slug}/pendings/ | Invite user to join account.
[**login**](AccountsApi.md#login) | **POST** /login/ | Logs user account into the system.
[**logout**](AccountsApi.md#logout) | **POST** /logout/ | Logs out current logged in user account session.
[**removeAccount**](AccountsApi.md#removeAccount) | **DELETE** /accounts/{slug}/accounts/{account_slug}/ | Remove user Account.
[**removeAccountAdmin**](AccountsApi.md#removeAccountAdmin) | **DELETE** /accounts/{slug}/admins/{admin_slug}/ | deletes a admin user from account.
[**removeAccountUser**](AccountsApi.md#removeAccountUser) | **DELETE** /accounts/{slug}/users/{user_slug}/ | Delete a regular user from account.
[**removePendingUser**](AccountsApi.md#removePendingUser) | **DELETE** /accounts/{slug}/pendings/{email}/ | Delete a pending user from user account.
[**resetPassword**](AccountsApi.md#resetPassword) | **POST** /reset/ | Reset password of user account.
[**setCurrentAccount**](AccountsApi.md#setCurrentAccount) | **PUT** /accounts/{slug}/current/ | Set user current account.
[**updateAccount**](AccountsApi.md#updateAccount) | **PUT** /accounts/{slug}/ | Update User Account.


# **addAccountAdmin**
> addAccountAdmin($slug, $sessionkey, $body)

Add a admin user into account.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddAdmin(); // \Swagger\Client\Model\AddAdmin | the content of the request used to add admin into account.

try {
    $api_instance->addAccountAdmin($slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->addAccountAdmin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\AddAdmin**](../Model/\Swagger\Client\Model\AddAdmin.md)| the content of the request used to add admin into account. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addAccountUser**
> addAccountUser($slug, $sessionkey, $body)

Add a regular user into account.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddAdmin(); // \Swagger\Client\Model\AddAdmin | the content of the request used to add admin into account.

try {
    $api_instance->addAccountUser($slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->addAccountUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\AddAdmin**](../Model/\Swagger\Client\Model\AddAdmin.md)| the content of the request used to add admin into account. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createAccount**
> \Swagger\Client\Model\User createAccount($body, $verbose)

Create a new user account.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$body = new \Swagger\Client\Model\CreateAccount(); // \Swagger\Client\Model\CreateAccount | the content of the request used to create user account.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->createAccount($body, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->createAccount: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Swagger\Client\Model\CreateAccount**](../Model/\Swagger\Client\Model\CreateAccount.md)| the content of the request used to create user account. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\User**](../Model/User.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAccountAdmin**
> \Swagger\Client\Model\User getAccountAdmin($slug, $admin_slug, $sessionkey, $verbose)

Get account Admin.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$admin_slug = "admin_slug_example"; // string | admin account unique indentifier.
$sessionkey = "sessionkey_example"; // string | user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getAccountAdmin($slug, $admin_slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->getAccountAdmin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **admin_slug** | **string**| admin account unique indentifier. |
 **sessionkey** | **string**| user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\User**](../Model/User.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAccountAdmins**
> \Swagger\Client\Model\Users getAccountAdmins($slug, $sessionkey, $verbose)

get admin users of account.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getAccountAdmins($slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->getAccountAdmins: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Users**](../Model/Users.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAccountDetails**
> \Swagger\Client\Model\User getAccountDetails($slug, $sessionkey, $verbose)

Detail View of user account.

user should be logged in to see detail view of account.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | unique value which will be used to fetch user account details.
$sessionkey = "sessionkey_example"; // string | account session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getAccountDetails($slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->getAccountDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| unique value which will be used to fetch user account details. |
 **sessionkey** | **string**| account session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\User**](../Model/User.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAccountList**
> \Swagger\Client\Model\Accounts getAccountList($sessionkey, $slug, $verbose)

Returns all accounts from the system that the user has access to.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$slug = "slug_example"; // string | unique value which will be used to fetch user account details.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getAccountList($sessionkey, $slug, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->getAccountList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sessionkey** | **string**| value used to manage user session. |
 **slug** | **string**| unique value which will be used to fetch user account details. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Accounts**](../Model/Accounts.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAccountUser**
> \Swagger\Client\Model\User getAccountUser($slug, $user_slug, $sessionkey, $verbose)

account Regular user.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$user_slug = "user_slug_example"; // string | user account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getAccountUser($slug, $user_slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->getAccountUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **user_slug** | **string**| user account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\User**](../Model/User.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAccountUsers**
> \Swagger\Client\Model\Users getAccountUsers($slug, $sessionkey, $verbose)

get Regular Users of account.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getAccountUsers($slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->getAccountUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Users**](../Model/Users.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCurrentAccount**
> \Swagger\Client\Model\Account getCurrentAccount($slug, $sessionkey, $verbose)

Get current user account.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | unique value which will be used to fetch user account details.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getCurrentAccount($slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->getCurrentAccount: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| unique value which will be used to fetch user account details. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Account**](../Model/Account.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPendingUsers**
> \Swagger\Client\Model\PendingUsers getPendingUsers($slug, $sessionkey, $verbose)

Get list of user's account pending users.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getPendingUsers($slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->getPendingUsers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\PendingUsers**](../Model/PendingUsers.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **inviteUser**
> inviteUser($slug, $sessionkey, $body)

Invite user to join account.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$sessionkey = "sessionkey_example"; // string | user session.
$body = new \Swagger\Client\Model\AddPending(); // \Swagger\Client\Model\AddPending | the content of the request used to add admin into user account.

try {
    $api_instance->inviteUser($slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->inviteUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **sessionkey** | **string**| user session. |
 **body** | [**\Swagger\Client\Model\AddPending**](../Model/\Swagger\Client\Model\AddPending.md)| the content of the request used to add admin into user account. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **login**
> \Swagger\Client\Model\SessionData login($body)

Logs user account into the system.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$body = new \Swagger\Client\Model\Login(); // \Swagger\Client\Model\Login | The request data used to login.

try {
    $result = $api_instance->login($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->login: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Swagger\Client\Model\Login**](../Model/\Swagger\Client\Model\Login.md)| The request data used to login. |

### Return type

[**\Swagger\Client\Model\SessionData**](../Model/SessionData.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **logout**
> logout($body)

Logs out current logged in user account session.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$body = new \Swagger\Client\Model\Logout(); // \Swagger\Client\Model\Logout | The request data used to logout.

try {
    $api_instance->logout($body);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->logout: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Swagger\Client\Model\Logout**](../Model/\Swagger\Client\Model\Logout.md)| The request data used to logout. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removeAccount**
> removeAccount($slug, $account_slug, $sessionkey)

Remove user Account.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$account_slug = "account_slug_example"; // string | specific account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $api_instance->removeAccount($slug, $account_slug, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->removeAccount: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **account_slug** | **string**| specific account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removeAccountAdmin**
> removeAccountAdmin($slug, $admin_slug, $sessionkey)

deletes a admin user from account.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$admin_slug = "admin_slug_example"; // string | admin account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $api_instance->removeAccountAdmin($slug, $admin_slug, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->removeAccountAdmin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **admin_slug** | **string**| admin account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removeAccountUser**
> removeAccountUser($slug, $user_slug, $sessionkey)

Delete a regular user from account.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | account unique indentifier.
$user_slug = "user_slug_example"; // string | user account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $api_instance->removeAccountUser($slug, $user_slug, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->removeAccountUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| account unique indentifier. |
 **user_slug** | **string**| user account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removePendingUser**
> removePendingUser($email, $slug, $sessionkey)

Delete a pending user from user account.

This can only be done by the logged in user.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$email = "email_example"; // string | Invited user email address.
$slug = "slug_example"; // string | account unique indentifier.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $api_instance->removePendingUser($email, $slug, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->removePendingUser: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email** | **string**| Invited user email address. |
 **slug** | **string**| account unique indentifier. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **resetPassword**
> resetPassword($body)

Reset password of user account.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$body = new \Swagger\Client\Model\ResetPassword(); // \Swagger\Client\Model\ResetPassword | The request data used to reset user account password.

try {
    $api_instance->resetPassword($body);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->resetPassword: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Swagger\Client\Model\ResetPassword**](../Model/\Swagger\Client\Model\ResetPassword.md)| The request data used to reset user account password. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **setCurrentAccount**
> setCurrentAccount($slug, $sessionkey, $body)

Set user current account.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | unique value which will be used to fetch user account details.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\ChangeCurrentAccount(); // \Swagger\Client\Model\ChangeCurrentAccount | request data used to change current account.

try {
    $api_instance->setCurrentAccount($slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->setCurrentAccount: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| unique value which will be used to fetch user account details. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\ChangeCurrentAccount**](../Model/\Swagger\Client\Model\ChangeCurrentAccount.md)| request data used to change current account. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateAccount**
> updateAccount($slug, $body, $sessionkey)

Update User Account.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\AccountsApi();
$slug = "slug_example"; // string | unique value which will be used to fetch user account details.
$body = new \Swagger\Client\Model\UpdateAccount(); // \Swagger\Client\Model\UpdateAccount | request data used to update user account.
$sessionkey = "sessionkey_example"; // string | user session.

try {
    $api_instance->updateAccount($slug, $body, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling AccountsApi->updateAccount: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **slug** | **string**| unique value which will be used to fetch user account details. |
 **body** | [**\Swagger\Client\Model\UpdateAccount**](../Model/\Swagger\Client\Model\UpdateAccount.md)| request data used to update user account. |
 **sessionkey** | **string**| user session. | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

