# Swagger\Client\LibraryApi

All URIs are relative to *https://stgqahub.blended.co/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**canonicalSet**](LibraryApi.md#canonicalSet) | **PUT** /packages/{accountSlug}/{slug}/canonical/ | Get package draft.


# **canonicalSet**
> canonicalSet($account_slug, $slug, $sessionkey, $body)

Get package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\LibraryApi();
$account_slug = "account_slug_example"; // string | accountSlug
$slug = "slug_example"; // string | package slug used to uniquely identify a package.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\CreateCanonical(); // \Swagger\Client\Model\CreateCanonical | request data used to update package.

try {
    $api_instance->canonicalSet($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling LibraryApi->canonicalSet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accountSlug |
 **slug** | **string**| package slug used to uniquely identify a package. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\CreateCanonical**](../Model/\Swagger\Client\Model\CreateCanonical.md)| request data used to update package. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: text/plain
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

