# Swagger\Client\PackagesApi

All URIs are relative to *https://stgqahub.blended.co/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**acquirePackage**](PackagesApi.md#acquirePackage) | **POST** /packages/{accountSlug}/{slug}/acquisitions/ | API to acquire package between accounts.
[**addLicense**](PackagesApi.md#addLicense) | **POST** /packages/{accountSlug}/{slug}/versions/{label}/licenses/ | Add a license to package.
[**addRating**](PackagesApi.md#addRating) | **POST** /packages/{accountSlug}/{slug}/ratings/ | Add a rating to a package.
[**canonicalSet**](PackagesApi.md#canonicalSet) | **PUT** /packages/{accountSlug}/{slug}/canonical/ | Get package draft.
[**createDraft**](PackagesApi.md#createDraft) | **POST** /packages/{accountSlug}/{slug}/draft/documents/ | Create package draft.
[**createPackage**](PackagesApi.md#createPackage) | **POST** /packages/{accountSlug}/ | Create Package.
[**download**](PackagesApi.md#download) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/documents/ | get version documents
[**downloadCanonical**](PackagesApi.md#downloadCanonical) | **GET** /packages/{accountSlug}/{slug}/canonical/documents/ | API used to Download a package.
[**downloadDraft**](PackagesApi.md#downloadDraft) | **GET** /packages/{accountSlug}/{slug}/draft/documents/ | Download package draft.
[**getCanonical**](PackagesApi.md#getCanonical) | **GET** /packages/{accountSlug}/{slug}/canonical/ | Get detail view of canonical version of a package.
[**getDependencies**](PackagesApi.md#getDependencies) | **GET** /packages/{accountSlug}/{slug}/dependencies/ | Return package dependencies.
[**getDetailDocument**](PackagesApi.md#getDetailDocument) | **GET** /packages/{accountSlug}/{slug}/draft/documents/{name}/ | Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)
[**getDraft**](PackagesApi.md#getDraft) | **GET** /packages/{accountSlug}/{slug}/draft/ | Get package draft.
[**getLicenses**](PackagesApi.md#getLicenses) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/licenses/ | Get list of licenses associated with package.
[**getPackageDetails**](PackagesApi.md#getPackageDetails) | **GET** /packages/{accountSlug}/{slug}/ | Package Detail view.
[**getPackageInitial**](PackagesApi.md#getPackageInitial) | **GET** /packages/initial/ | Packages initial
[**getPackages**](PackagesApi.md#getPackages) | **GET** /packages/{accountSlug}/ | Packages.
[**getPublication**](PackagesApi.md#getPublication) | **GET** /packages/{accountSlug}/{slug}/publication/ | Returns list of publication submitted by users for a package.
[**getRatingDetails**](PackagesApi.md#getRatingDetails) | **GET** /packages/{accountSlug}/{slug}/ratings/{rating_pk}/ | Get Details of package rating submitted by any user.
[**getRatings**](PackagesApi.md#getRatings) | **GET** /packages/{accountSlug}/{slug}/ratings/ | Returns list of ratings submitted by users for a package.
[**getVersionDetails**](PackagesApi.md#getVersionDetails) | **GET** /packages/{accountSlug}/{slug}/versions/{label}/ | get version data of a package in details.
[**getVersions**](PackagesApi.md#getVersions) | **GET** /packages/{accountSlug}/{slug}/versions/ | return the list of package version
[**removeLicense**](PackagesApi.md#removeLicense) | **DELETE** /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/ | delete a package license.
[**search**](PackagesApi.md#search) | **GET** /search/ | Search Packages.
[**snapshot**](PackagesApi.md#snapshot) | **POST** /packages/{accountSlug}/{slug}/versions/ | Create a snapshot of a package.
[**updateDraft**](PackagesApi.md#updateDraft) | **PUT** /packages/{accountSlug}/{slug}/draft/documents/ | Update package draft.
[**updateLicense**](PackagesApi.md#updateLicense) | **PUT** /packages/{accountSlug}/{slug}/versions/{label}/licenses/{name}/ | Update price of package license.
[**updatePackage**](PackagesApi.md#updatePackage) | **PUT** /packages/{accountSlug}/{slug}/ | Update Package.
[**updateRating**](PackagesApi.md#updateRating) | **PUT** /packages/{accountSlug}/{slug}/ratings/{rating_pk}/ | Update rating of package.
[**uploadMedia**](PackagesApi.md#uploadMedia) | **POST** /packages/{accountSlug}/{slug}/media/ | Upload a media file to package&#39;s draft
[**validatePublication**](PackagesApi.md#validatePublication) | **POST** /packages/{accountSlug}/{slug}/publication/ | Validate publication object


# **acquirePackage**
> \Swagger\Client\Model\BlendedPackage acquirePackage($account_slug, $slug, $sessionkey, $body)

API to acquire package between accounts.

To share,transfer, get, buy, extend and clone a package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | accounts slug
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\Acquisition(); // \Swagger\Client\Model\Acquisition | request data used to acquire package.

try {
    $result = $api_instance->acquirePackage($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->acquirePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accounts slug |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\Acquisition**](../Model/\Swagger\Client\Model\Acquisition.md)| request data used to acquire package. |

### Return type

[**\Swagger\Client\Model\BlendedPackage**](../Model/BlendedPackage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addLicense**
> addLicense($account_slug, $slug, $label, $sessionkey, $body)

Add a license to package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | label for the version
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddLicense(); // \Swagger\Client\Model\AddLicense | request data used to add package license.

try {
    $api_instance->addLicense($account_slug, $slug, $label, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->addLicense: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| label for the version |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\AddLicense**](../Model/\Swagger\Client\Model\AddLicense.md)| request data used to add package license. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **addRating**
> addRating($account_slug, $slug, $sessionkey, $body)

Add a rating to a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddRating(); // \Swagger\Client\Model\AddRating | request data used to add package rating.

try {
    $api_instance->addRating($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->addRating: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\AddRating**](../Model/\Swagger\Client\Model\AddRating.md)| request data used to add package rating. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **canonicalSet**
> canonicalSet($account_slug, $slug, $sessionkey, $body)

Get package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | accountSlug
$slug = "slug_example"; // string | package slug used to uniquely identify a package.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\CreateCanonical(); // \Swagger\Client\Model\CreateCanonical | request data used to update package.

try {
    $api_instance->canonicalSet($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->canonicalSet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| accountSlug |
 **slug** | **string**| package slug used to uniquely identify a package. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\CreateCanonical**](../Model/\Swagger\Client\Model\CreateCanonical.md)| request data used to update package. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: text/plain
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createDraft**
> \Swagger\Client\Model\NewDraft createDraft($account_slug, $slug, $sessionkey, $body)

Create package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\UpdateDraft(); // \Swagger\Client\Model\UpdateDraft | request data used to create package draft.

try {
    $result = $api_instance->createDraft($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->createDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\UpdateDraft**](../Model/\Swagger\Client\Model\UpdateDraft.md)| request data used to create package draft. |

### Return type

[**\Swagger\Client\Model\NewDraft**](../Model/NewDraft.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createPackage**
> \Swagger\Client\Model\BlendedPackage createPackage($account_slug, $sessionkey, $body, $verbose)

Create Package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\CreatePackage(); // \Swagger\Client\Model\CreatePackage | request data used to create package.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->createPackage($account_slug, $sessionkey, $body, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->createPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\CreatePackage**](../Model/\Swagger\Client\Model\CreatePackage.md)| request data used to create package. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\BlendedPackage**](../Model/BlendedPackage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **download**
> object[] download($account_slug, $slug, $label, $sessionkey, $as_hashes)

get version documents



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | value used to uniquely identify version.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$as_hashes = "as_hashes_example"; // string | value used to return only hashes

try {
    $result = $api_instance->download($account_slug, $slug, $label, $sessionkey, $as_hashes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->download: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| value used to uniquely identify version. |
 **sessionkey** | **string**| value used to manage user session. | [optional]
 **as_hashes** | **string**| value used to return only hashes | [optional]

### Return type

**object[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **downloadCanonical**
> object[] downloadCanonical($account_slug, $slug, $sessionkey)

API used to Download a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->downloadCanonical($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->downloadCanonical: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

**object[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **downloadDraft**
> object[] downloadDraft($account_slug, $slug, $sessionkey, $as_hashes)

Download package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$as_hashes = "as_hashes_example"; // string | value used to return only hashes

try {
    $result = $api_instance->downloadDraft($account_slug, $slug, $sessionkey, $as_hashes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->downloadDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **as_hashes** | **string**| value used to return only hashes | [optional]

### Return type

**object[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCanonical**
> \Swagger\Client\Model\CanonicalVersion getCanonical($account_slug, $slug, $sessionkey, $verbose)

Get detail view of canonical version of a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getCanonical($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getCanonical: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\CanonicalVersion**](../Model/CanonicalVersion.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDependencies**
> \Swagger\Client\Model\Packages getDependencies($account_slug, $slug, $sessionkey, $verbose)

Return package dependencies.

Returns package dependencies.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getDependencies($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getDependencies: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Packages**](../Model/Packages.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDetailDocument**
> object[] getDetailDocument($account_slug, $slug, $name, $sessionkey)

Access draft documents and directory.REVIEW.just to make sure that we can do this by /draft/documents/ and have single call(single function in swagger)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$name = "name_example"; // string | path of the directory. Ex. - meta/config.css
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getDetailDocument($account_slug, $slug, $name, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getDetailDocument: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **name** | **string**| path of the directory. Ex. - meta/config.css |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

**object[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDraft**
> \Swagger\Client\Model\HyperLinkDraft getDraft($account_slug, $slug, $sessionkey)

Get package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getDraft($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\HyperLinkDraft**](../Model/HyperLinkDraft.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLicenses**
> \Swagger\Client\Model\HyperLinkLicenses getLicenses($account_slug, $slug, $label, $sessionkey)

Get list of licenses associated with package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | label for the version
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getLicenses($account_slug, $slug, $label, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getLicenses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| label for the version |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\HyperLinkLicenses**](../Model/HyperLinkLicenses.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackageDetails**
> \Swagger\Client\Model\BlendedPackage getPackageDetails($account_slug, $slug, $sessionkey, $verbose)

Package Detail view.

Returns a single package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getPackageDetails($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getPackageDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\BlendedPackage**](../Model/BlendedPackage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackageInitial**
> \Swagger\Client\Model\InitialPackages getPackageInitial()

Packages initial

default packages for any user (public packages available at initial time)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();

try {
    $result = $api_instance->getPackageInitial();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getPackageInitial: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\Swagger\Client\Model\InitialPackages**](../Model/InitialPackages.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackages**
> \Swagger\Client\Model\Packages getPackages($account_slug, $sessionkey, $verbose)

Packages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getPackages($account_slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getPackages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Packages**](../Model/Packages.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPublication**
> \Swagger\Client\Model\Publications getPublication($account_slug, $slug, $sessionkey, $verbose)

Returns list of publication submitted by users for a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getPublication($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getPublication: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Publications**](../Model/Publications.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRatingDetails**
> \Swagger\Client\Model\Rating getRatingDetails($account_slug, $slug, $rating_pk, $sessionkey, $verbose)

Get Details of package rating submitted by any user.

Returns package rating details.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$rating_pk = 789; // int | value used to uniquely identify rating.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getRatingDetails($account_slug, $slug, $rating_pk, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getRatingDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **rating_pk** | **int**| value used to uniquely identify rating. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\Rating**](../Model/Rating.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRatings**
> \Swagger\Client\Model\HyperLinkRatings getRatings($account_slug, $slug, $sessionkey, $verbose)

Returns list of ratings submitted by users for a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$verbose = "verbose_example"; // string | parameter to provide detail view of hyperlink objects.

try {
    $result = $api_instance->getRatings($account_slug, $slug, $sessionkey, $verbose);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getRatings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **verbose** | **string**| parameter to provide detail view of hyperlink objects. | [optional]

### Return type

[**\Swagger\Client\Model\HyperLinkRatings**](../Model/HyperLinkRatings.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVersionDetails**
> \Swagger\Client\Model\Version getVersionDetails($account_slug, $slug, $label, $sessionkey)

get version data of a package in details.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | value used to uniquely identify version.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getVersionDetails($account_slug, $slug, $label, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getVersionDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| value used to uniquely identify version. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\Version**](../Model/Version.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVersions**
> \Swagger\Client\Model\Versions getVersions($account_slug, $slug, $sessionkey)

return the list of package version



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $result = $api_instance->getVersions($account_slug, $slug, $sessionkey);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->getVersions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

[**\Swagger\Client\Model\Versions**](../Model/Versions.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **removeLicense**
> removeLicense($account_slug, $slug, $label, $name, $sessionkey)

delete a package license.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | label for the version
$name = "name_example"; // string | name of the license
$sessionkey = "sessionkey_example"; // string | value used to manage user session.

try {
    $api_instance->removeLicense($account_slug, $slug, $label, $name, $sessionkey);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->removeLicense: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| label for the version |
 **name** | **string**| name of the license |
 **sessionkey** | **string**| value used to manage user session. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **search**
> \Swagger\Client\Model\SearchResults search($filter_by, $order_by)

Search Packages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$filter_by = "filter_by_example"; // string | filter by parameters.
$order_by = "order_by_example"; // string | to order package display.

try {
    $result = $api_instance->search($filter_by, $order_by);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->search: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **filter_by** | **string**| filter by parameters. | [optional]
 **order_by** | **string**| to order package display. | [optional]

### Return type

[**\Swagger\Client\Model\SearchResults**](../Model/SearchResults.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **snapshot**
> \Swagger\Client\Model\Version snapshot($account_slug, $slug, $sessionkey, $body)

Create a snapshot of a package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\CreateVersion(); // \Swagger\Client\Model\CreateVersion | request data used to snapshot package.

try {
    $result = $api_instance->snapshot($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->snapshot: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\CreateVersion**](../Model/\Swagger\Client\Model\CreateVersion.md)| request data used to snapshot package. |

### Return type

[**\Swagger\Client\Model\Version**](../Model/Version.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateDraft**
> \Swagger\Client\Model\NewDraft updateDraft($account_slug, $slug, $sessionkey, $body)

Update package draft.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\UpdateDraft(); // \Swagger\Client\Model\UpdateDraft | request data used to update package draft.

try {
    $result = $api_instance->updateDraft($account_slug, $slug, $sessionkey, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updateDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\UpdateDraft**](../Model/\Swagger\Client\Model\UpdateDraft.md)| request data used to update package draft. |

### Return type

[**\Swagger\Client\Model\NewDraft**](../Model/NewDraft.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateLicense**
> updateLicense($account_slug, $slug, $label, $name, $sessionkey, $body)

Update price of package license.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$label = "label_example"; // string | label for the version
$name = "name_example"; // string | name of the license
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\UpdateLicense(); // \Swagger\Client\Model\UpdateLicense | request data used to update license price.

try {
    $api_instance->updateLicense($account_slug, $slug, $label, $name, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updateLicense: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **label** | **string**| label for the version |
 **name** | **string**| name of the license |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\UpdateLicense**](../Model/\Swagger\Client\Model\UpdateLicense.md)| request data used to update license price. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updatePackage**
> updatePackage($account_slug, $slug, $sessionkey, $body)

Update Package.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\UpdatePackage(); // \Swagger\Client\Model\UpdatePackage | request data used to update package.

try {
    $api_instance->updatePackage($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updatePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\UpdatePackage**](../Model/\Swagger\Client\Model\UpdatePackage.md)| request data used to update package. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateRating**
> updateRating($account_slug, $slug, $rating_pk, $sessionkey, $body)

Update rating of package.

API for user to update rating score.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$rating_pk = 789; // int | value used to uniquely identify rating.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\AddRating(); // \Swagger\Client\Model\AddRating | request data used to update rating.

try {
    $api_instance->updateRating($account_slug, $slug, $rating_pk, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->updateRating: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **rating_pk** | **int**| value used to uniquely identify rating. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\AddRating**](../Model/\Swagger\Client\Model\AddRating.md)| request data used to update rating. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **uploadMedia**
> \Swagger\Client\Model\InlineResponse200 uploadMedia($account_slug, $slug, $sessionkey, $hash_value, $name, $token, $image)

Upload a media file to package's draft



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$hash_value = "hash_value_example"; // string | 
$name = "name_example"; // string | 
$token = "token_example"; // string | 
$image = "/path/to/file.txt"; // \SplFileObject | media file

try {
    $result = $api_instance->uploadMedia($account_slug, $slug, $sessionkey, $hash_value, $name, $token, $image);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->uploadMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **hash_value** | **string**|  |
 **name** | **string**|  | [optional]
 **token** | **string**|  | [optional]
 **image** | **\SplFileObject**| media file | [optional]

### Return type

[**\Swagger\Client\Model\InlineResponse200**](../Model/InlineResponse200.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **validatePublication**
> validatePublication($account_slug, $slug, $sessionkey, $body)

Validate publication object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new Swagger\Client\Api\PackagesApi();
$account_slug = "account_slug_example"; // string | slug of account
$slug = "slug_example"; // string | slug of package to return.
$sessionkey = "sessionkey_example"; // string | value used to manage user session.
$body = new \Swagger\Client\Model\Publication(); // \Swagger\Client\Model\Publication | request data used to add package rating.

try {
    $api_instance->validatePublication($account_slug, $slug, $sessionkey, $body);
} catch (Exception $e) {
    echo 'Exception when calling PackagesApi->validatePublication: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **account_slug** | **string**| slug of account |
 **slug** | **string**| slug of package to return. |
 **sessionkey** | **string**| value used to manage user session. |
 **body** | [**\Swagger\Client\Model\Publication**](../Model/\Swagger\Client\Model\Publication.md)| request data used to add package rating. |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

